/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.swagger;

import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.StatusCode;
import com.webcohesion.enunciate.modules.swagger.FindBestDataTypeMethod;
import com.webcohesion.enunciate.modules.swagger.SwaggerResponse;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ResponsesOfMethod
implements TemplateMethodModelEx {
    private static Set<String> DEFAULT_201_METHODS = new TreeSet<String>(Collections.singletonList("POST"));
    private static Set<String> DEFAULT_204_METHODS = new TreeSet<String>(Arrays.asList("PATCH", "PUT", "DELETE"));

    public Object exec(List list) throws TemplateModelException {
        if (list.size() < 1) {
            throw new TemplateModelException("The responsesOf method must have a parameter.");
        }
        TemplateModel from = (TemplateModel)list.get(0);
        Object unwrapped = new BeansWrapperBuilder(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS).build().unwrap(from);
        if (unwrapped instanceof Method) {
            Method method = (Method)unwrapped;
            ArrayList<SwaggerResponse> responses = new ArrayList<SwaggerResponse>();
            List successHeaders = method.getResponseHeaders();
            DataTypeReference successDataType = FindBestDataTypeMethod.findBestDataType(method.getResponseEntity());
            boolean successResponseFound = false;
            if (method.getResponseCodes() != null) {
                for (StatusCode code : method.getResponseCodes()) {
                    boolean successResponse = code.getCode() >= 200 && code.getCode() < 300;
                    DataTypeReference dataType = FindBestDataTypeMethod.findBestDataType(code.getMediaTypes());
                    dataType = dataType == null && successResponse ? successDataType : dataType;
                    List headers = successResponse ? successHeaders : Collections.emptyList();
                    responses.add(new SwaggerResponse(code.getCode(), dataType, headers, code.getCondition()));
                    successResponseFound |= successResponse;
                }
            }
            if (!successResponseFound) {
                int code = DEFAULT_201_METHODS.contains(method.getHttpMethod().toUpperCase()) ? 201 : (DEFAULT_204_METHODS.contains(method.getHttpMethod().toUpperCase()) ? 204 : 200);
                responses.add(new SwaggerResponse(code, successDataType, successHeaders, "Success"));
            }
            return responses;
        }
        throw new TemplateModelException("No responses for: " + unwrapped);
    }
}

