/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.api.impl;

import com.webcohesion.enunciate.api.Styles;
import com.webcohesion.enunciate.api.resources.Parameter;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.modules.spring_web.model.RequestParameter;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceParameterConstraints;
import com.webcohesion.enunciate.util.AnnotationUtils;
import com.webcohesion.enunciate.util.BeanValidationUtils;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.springframework.format.annotation.DateTimeFormat;

public class ParameterImpl
implements Parameter {
    private final RequestParameter param;

    public ParameterImpl(RequestParameter param) {
        this.param = param;
    }

    public String getName() {
        return this.param.getParameterName();
    }

    public String getDescription() {
        return this.param.getDocValue();
    }

    public String getTypeLabel() {
        return this.param.getTypeName();
    }

    public String getTypeName() {
        return this.param.getDataType().name().toLowerCase();
    }

    public String getDefaultValue() {
        return this.param.getDefaultValue();
    }

    public String getConstraints() {
        String validationConstraints = BeanValidationUtils.describeConstraints((Element)((Object)this.param), (boolean)this.param.isRequired(), (String)this.getDefaultValue());
        String dateTimeFormatDescription = ParameterImpl.describeDateTimeFormat((Element)((Object)this.param));
        if (validationConstraints != null || dateTimeFormatDescription != null) {
            StringBuilder constraints = new StringBuilder();
            if (dateTimeFormatDescription != null) {
                constraints.append(dateTimeFormatDescription);
                if (validationConstraints != null) {
                    constraints.append(", ");
                }
            }
            if (validationConstraints != null) {
                constraints.append(validationConstraints);
            }
            return constraints.toString();
        }
        ResourceParameterConstraints constraints = this.param.getConstraints();
        if (constraints != null && constraints.getType() != null) {
            switch (constraints.getType()) {
                case ENUMERATION: {
                    StringBuilder builder = new StringBuilder();
                    Iterator<String> it = ((ResourceParameterConstraints.Enumeration)constraints).getValues().iterator();
                    while (it.hasNext()) {
                        String next = it.next();
                        builder.append('\"').append(next).append('\"');
                        if (!it.hasNext()) continue;
                        builder.append(" or ");
                    }
                    return builder.toString();
                }
                case PRIMITIVE: {
                    return ((ResourceParameterConstraints.Primitive)constraints).getKind().name().toLowerCase();
                }
                case REGEX: {
                    return "regex: " + ((ResourceParameterConstraints.Regex)constraints).getRegex();
                }
                case REQUIRED: {
                    return "required";
                }
            }
        }
        return null;
    }

    private static String describeDateTimeFormat(Element element) {
        DateTimeFormat dateFormat = element.getAnnotation(DateTimeFormat.class);
        String description = null;
        if (dateFormat != null) {
            if (!"".equals(dateFormat.pattern())) {
                description = "date (" + dateFormat.pattern() + ")";
            } else if (dateFormat.iso() != DateTimeFormat.ISO.NONE) {
                switch (dateFormat.iso()) {
                    case DATE: {
                        description = "date (yyyy-MM-dd)";
                        break;
                    }
                    case TIME: {
                        description = "time (HH:mm:ss.SSSZ)";
                        break;
                    }
                    case DATE_TIME: {
                        description = "date+time (yyyy-MM-dd'T'HH:mm:ss.SSSZ)";
                    }
                }
            }
        }
        return description;
    }

    public Set<String> getConstraintValues() {
        ResourceParameterConstraints constraints = this.param.getConstraints();
        if (constraints != null && constraints.getType() != null) {
            switch (constraints.getType()) {
                case UNBOUND_STRING: {
                    return null;
                }
                case ENUMERATION: {
                    return ((ResourceParameterConstraints.Enumeration)constraints).getValues();
                }
                case PRIMITIVE: {
                    return null;
                }
                case REGEX: {
                    return null;
                }
                case REQUIRED: {
                    return null;
                }
            }
        }
        return null;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)this.param.getAnnotation(annotationType);
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.param.getAnnotations();
    }

    public JavaDoc getJavaDoc() {
        return this.param.getJavaDoc();
    }

    public boolean isMultivalued() {
        return this.param.isMultivalued();
    }

    public Set<String> getStyles() {
        return Styles.gatherStyles((Element)((Object)this.param), Collections.emptyMap());
    }

    public String getTypeFormat() {
        return AnnotationUtils.getJsonStringFormat((Element)((Object)this.param));
    }
}

