/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxws.model;

import com.webcohesion.enunciate.modules.jaxb.model.ImplicitChildElement;
import com.webcohesion.enunciate.modules.jaxb.model.ImplicitRootElement;
import com.webcohesion.enunciate.modules.jaxws.model.WebMessage;
import com.webcohesion.enunciate.modules.jaxws.model.WebMessagePart;
import com.webcohesion.enunciate.modules.jaxws.model.WebMethod;
import com.webcohesion.enunciate.modules.jaxws.model.WebParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;

public class RequestWrapper
implements WebMessage,
WebMessagePart,
ImplicitRootElement {
    private WebMethod webMethod;

    public RequestWrapper(WebMethod webMethod) {
        this.webMethod = webMethod;
    }

    @Override
    public WebMethod getWebMethod() {
        return this.webMethod;
    }

    public String getRequestBeanName() {
        String capitalizedName = this.webMethod.getSimpleName().toString();
        capitalizedName = Character.toString(capitalizedName.charAt(0)).toUpperCase() + capitalizedName.substring(1);
        String requestBeanName = this.webMethod.getDeclaringEndpointInterface().getPackage().getQualifiedName() + ".jaxws." + capitalizedName;
        javax.xml.ws.RequestWrapper annotation = (javax.xml.ws.RequestWrapper)this.webMethod.getAnnotation(javax.xml.ws.RequestWrapper.class);
        if (annotation != null && annotation.className() != null && !"".equals(annotation.className())) {
            requestBeanName = annotation.className();
        }
        return requestBeanName;
    }

    public String getElementName() {
        String name = this.webMethod.getOperationName();
        javax.xml.ws.RequestWrapper annotation = (javax.xml.ws.RequestWrapper)this.webMethod.getAnnotation(javax.xml.ws.RequestWrapper.class);
        if (annotation != null && annotation.localName() != null && !"".equals(annotation.localName())) {
            name = annotation.localName();
        }
        return name;
    }

    public String getTargetNamespace() {
        return this.getElementNamespace();
    }

    public String getElementNamespace() {
        String targetNamespace = this.webMethod.getDeclaringEndpointInterface().getTargetNamespace();
        javax.xml.ws.RequestWrapper annotation = (javax.xml.ws.RequestWrapper)this.webMethod.getAnnotation(javax.xml.ws.RequestWrapper.class);
        if (annotation != null && annotation.localName() != null && !"".equals(annotation.targetNamespace())) {
            targetNamespace = annotation.targetNamespace();
        }
        return targetNamespace;
    }

    public String getElementDocs() {
        String docs = "doc/lit request wrapper for operation \"" + this.webMethod.getOperationName() + "\".";
        String methodDocs = this.webMethod.getJavaDoc().toString();
        if (methodDocs.trim().length() > 0) {
            docs = docs + " (" + methodDocs.trim() + ")";
        }
        return docs;
    }

    @Override
    public boolean isImplicitSchemaElement() {
        return true;
    }

    @Override
    public WebMessagePart.ParticleType getParticleType() {
        return WebMessagePart.ParticleType.ELEMENT;
    }

    @Override
    public QName getParticleQName() {
        return new QName(this.getElementNamespace(), this.getElementName());
    }

    public QName getTypeQName() {
        return null;
    }

    public Collection<ImplicitChildElement> getChildElements() {
        ArrayList<ImplicitChildElement> childElements = new ArrayList<ImplicitChildElement>();
        for (WebParam webParam : this.webMethod.getWebParameters()) {
            if (!webParam.isInput() || webParam.isHeader()) continue;
            childElements.add(webParam);
        }
        return childElements;
    }

    @Override
    public boolean isInput() {
        return true;
    }

    @Override
    public boolean isOutput() {
        return false;
    }

    @Override
    public boolean isHeader() {
        return false;
    }

    @Override
    public boolean isFault() {
        return false;
    }

    @Override
    public Collection<WebMessagePart> getParts() {
        return new ArrayList<WebMessagePart>(Arrays.asList(this));
    }

    @Override
    public String getMessageName() {
        return this.webMethod.getDeclaringEndpointInterface().getSimpleName() + "." + this.webMethod.getSimpleName();
    }

    @Override
    public String getMessageDocs() {
        String docs = "request message for operation \"" + this.webMethod.getOperationName() + "\".";
        String methodDocs = this.webMethod.getJavaDoc().toString();
        if (methodDocs.trim().length() > 0) {
            docs = docs + " (" + methodDocs.trim() + ")";
        }
        return docs;
    }

    @Override
    public String getPartDocs() {
        return null;
    }

    @Override
    public String getPartName() {
        return "parameters";
    }
}

