/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs.model;

import java.util.Set;
import javax.lang.model.type.TypeKind;

public interface ResourceParameterConstraints {
    public ResourceParameterContraintType getType();

    public static class Enumeration
    implements ResourceParameterConstraints {
        private final Set<String> values;

        public Enumeration(Set<String> values) {
            this.values = values;
        }

        @Override
        public ResourceParameterContraintType getType() {
            return ResourceParameterContraintType.ENUMERATION;
        }

        public Set<String> getValues() {
            return this.values;
        }
    }

    public static class Regex
    implements ResourceParameterConstraints {
        private final String regex;

        public Regex(String regex) {
            this.regex = regex;
        }

        @Override
        public ResourceParameterContraintType getType() {
            return ResourceParameterContraintType.REGEX;
        }

        public String getRegex() {
            return this.regex;
        }
    }

    public static class Primitive
    implements ResourceParameterConstraints {
        private final TypeKind kind;

        public Primitive(TypeKind kind) {
            this.kind = kind;
        }

        public TypeKind getKind() {
            return this.kind;
        }

        @Override
        public ResourceParameterContraintType getType() {
            return ResourceParameterContraintType.PRIMITIVE;
        }
    }

    public static class UnboundString
    implements ResourceParameterConstraints {
        @Override
        public ResourceParameterContraintType getType() {
            return ResourceParameterContraintType.UNBOUND_STRING;
        }
    }

    public static enum ResourceParameterContraintType {
        UNBOUND_STRING,
        PRIMITIVE,
        REGEX,
        ENUMERATION;

    }
}

