/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs.api.impl;

import com.webcohesion.enunciate.api.datatype.DataType;
import com.webcohesion.enunciate.api.datatype.Example;
import com.webcohesion.enunciate.api.datatype.Syntax;
import com.webcohesion.enunciate.api.resources.Entity;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.javadoc.DefaultJavaDocTagHandler;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.javac.javadoc.JavaDocTagHandler;
import com.webcohesion.enunciate.metadata.DocumentationExample;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.CustomMediaTypeDescriptor;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.MediaTypeDescriptorImpl;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceMethod;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceRepresentationMetadata;
import com.webcohesion.enunciate.modules.jaxrs.model.util.MediaType;
import com.webcohesion.enunciate.util.TypeHintUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class ResponseEntityImpl
implements Entity {
    private ResourceMethod resourceMethod;
    private ResourceRepresentationMetadata responseMetadata;

    public ResponseEntityImpl(ResourceMethod resourceMethod, ResourceRepresentationMetadata responseMetadata) {
        this.resourceMethod = resourceMethod;
        this.responseMetadata = responseMetadata;
    }

    public String getDescription() {
        return this.responseMetadata.getDocValue();
    }

    public List<? extends MediaTypeDescriptor> getMediaTypes() {
        Set<MediaType> produces = this.resourceMethod.getProducesMediaTypes();
        ArrayList<Object> mts = new ArrayList<Object>(produces.size());
        for (MediaType mt : produces) {
            boolean descriptorFound = false;
            DecoratedTypeMirror type = (DecoratedTypeMirror)this.responseMetadata.getDelegate();
            for (Syntax syntax : this.resourceMethod.getContext().getContext().getApiRegistry().getSyntaxes()) {
                MediaTypeDescriptor descriptor = syntax.findMediaTypeDescriptor(mt.getMediaType(), type);
                if (descriptor == null) continue;
                mts.add(new MediaTypeDescriptorImpl(descriptor, mt, this.loadExample(syntax, descriptor)));
                descriptorFound = true;
            }
            if (descriptorFound) continue;
            mts.add(new CustomMediaTypeDescriptor(mt));
        }
        return mts;
    }

    protected Example loadExample(Syntax syntax, MediaTypeDescriptor descriptor) {
        List dataTypes;
        Element element;
        TypeMirror typeHint;
        DocumentationExample documentationExample;
        String tag;
        Example example = descriptor.getExample();
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.resourceMethod.getJavaDoc().get((Object)"documentationType");
        if (tags != null && tags.size() > 0 && !(tag = ((String)tags.get(0)).trim()).isEmpty()) {
            TypeElement typeElement = this.resourceMethod.getContext().getContext().getProcessingEnvironment().getElementUtils().getTypeElement(tag);
            if (typeElement != null) {
                List dataTypes2 = syntax.findDataTypes(typeElement.getQualifiedName().toString());
                if (dataTypes2 != null && !dataTypes2.isEmpty()) {
                    example = ((DataType)dataTypes2.get(0)).getExample();
                }
            } else {
                this.resourceMethod.getContext().getContext().getLogger().warn("Invalid documentation type %s.", new Object[]{tag});
            }
        }
        if ((documentationExample = (DocumentationExample)this.resourceMethod.getAnnotation(DocumentationExample.class)) != null && (typeHint = TypeHintUtils.getTypeHint((TypeHint)documentationExample.type(), (DecoratedProcessingEnvironment)this.resourceMethod.getContext().getContext().getProcessingEnvironment(), null)) instanceof DeclaredType && (element = ((DeclaredType)typeHint).asElement()) instanceof TypeElement && (dataTypes = syntax.findDataTypes(((TypeElement)element).getQualifiedName().toString())) != null && !dataTypes.isEmpty()) {
            example = ((DataType)dataTypes.get(0)).getExample();
        }
        return example;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return null;
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return Collections.emptyMap();
    }

    public JavaDoc getJavaDoc() {
        return new JavaDoc(null, (JavaDocTagHandler)new DefaultJavaDocTagHandler());
    }
}

