/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs.api.impl;

import com.webcohesion.enunciate.api.Styles;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.MethodImpl;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceMethod;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public class ResourceImpl
implements Resource {
    final ResourceMethod resourceMethod;
    private final ResourceGroup group;
    private final List<Method> methods;

    public ResourceImpl(ResourceMethod resourceMethod, ResourceGroup group) {
        this.resourceMethod = resourceMethod;
        this.group = group;
        Set<String> httpMethods = this.resourceMethod.getHttpMethods();
        this.methods = new ArrayList<Method>(httpMethods.size());
        for (String httpMethod : httpMethods) {
            this.methods.add(new MethodImpl(httpMethod, this.resourceMethod, this.group));
        }
    }

    public String getPath() {
        return this.resourceMethod.getFullpath();
    }

    public String getRelativePath() {
        String relativePath = this.getPath();
        while (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return relativePath;
    }

    public String getSlug() {
        return this.group.getSlug() + "_" + this.resourceMethod.getSimpleName();
    }

    public String getDeprecated() {
        return ElementUtils.findDeprecationMessage((DecoratedElement)this.resourceMethod);
    }

    public String getSince() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.resourceMethod.getJavaDoc().get((Object)"since");
        return tags == null ? null : tags.toString();
    }

    public String getVersion() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.resourceMethod.getJavaDoc().get((Object)"version");
        return tags == null ? null : tags.toString();
    }

    public List<? extends Method> getMethods() {
        return this.methods;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)this.resourceMethod.getAnnotation(annotationType);
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.resourceMethod.getAnnotations();
    }

    public Set<Facet> getFacets() {
        return this.resourceMethod.getFacets();
    }

    public JavaDoc getJavaDoc() {
        return this.resourceMethod.getJavaDoc();
    }

    public Set<String> getStyles() {
        return Styles.gatherStyles((Element)((Object)this.resourceMethod), (Map)this.resourceMethod.getContext().getContext().getConfiguration().getAnnotationStyles());
    }
}

