/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs.api.impl;

import com.webcohesion.enunciate.api.datatype.DataType;
import com.webcohesion.enunciate.api.datatype.Example;
import com.webcohesion.enunciate.api.datatype.Syntax;
import com.webcohesion.enunciate.api.resources.Entity;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.metadata.DocumentationExample;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.CustomMediaTypeDescriptor;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.MediaTypeDescriptorImpl;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceEntityParameter;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceMethod;
import com.webcohesion.enunciate.modules.jaxrs.model.util.MediaType;
import com.webcohesion.enunciate.util.TypeHintUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class RequestEntityImpl
implements Entity {
    private final ResourceMethod resourceMethod;
    private final ResourceEntityParameter entityParameter;

    public RequestEntityImpl(ResourceMethod resourceMethod, ResourceEntityParameter entityParameter) {
        this.resourceMethod = resourceMethod;
        this.entityParameter = entityParameter;
    }

    public String getDescription() {
        return this.entityParameter == null ? null : this.entityParameter.getDocValue();
    }

    public List<? extends MediaTypeDescriptor> getMediaTypes() {
        Set<MediaType> consumes = this.resourceMethod.getConsumesMediaTypes();
        ArrayList<Object> mts = new ArrayList<Object>(consumes.size());
        for (MediaType mt : consumes) {
            boolean descriptorFound = false;
            if (this.entityParameter != null) {
                DecoratedTypeMirror type = (DecoratedTypeMirror)this.entityParameter.getType();
                for (Syntax syntax : this.resourceMethod.getContext().getContext().getApiRegistry().getSyntaxes()) {
                    MediaTypeDescriptor descriptor = syntax.findMediaTypeDescriptor(mt.getMediaType(), type);
                    if (descriptor == null) continue;
                    Example example = this.loadExample(syntax, descriptor);
                    mts.add(new MediaTypeDescriptorImpl(descriptor, mt, example));
                    descriptorFound = true;
                }
            }
            if (descriptorFound) continue;
            mts.add(new CustomMediaTypeDescriptor(mt));
        }
        return mts;
    }

    protected Example loadExample(Syntax syntax, MediaTypeDescriptor descriptor) {
        List dataTypes;
        Element element;
        TypeMirror typeHint;
        Example example = descriptor.getExample();
        DocumentationExample documentationExample = (DocumentationExample)this.entityParameter.getAnnotation(DocumentationExample.class);
        if (documentationExample != null && (typeHint = TypeHintUtils.getTypeHint((TypeHint)documentationExample.type(), (DecoratedProcessingEnvironment)this.resourceMethod.getContext().getContext().getProcessingEnvironment(), null)) instanceof DeclaredType && (element = ((DeclaredType)typeHint).asElement()) instanceof TypeElement && (dataTypes = syntax.findDataTypes(((TypeElement)element).getQualifiedName().toString())) != null && !dataTypes.isEmpty()) {
            example = ((DataType)dataTypes.get(0)).getExample();
        }
        return example;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)(this.entityParameter == null ? null : this.entityParameter.getAnnotation(annotationType));
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.entityParameter == null ? Collections.emptyMap() : this.entityParameter.getAnnotations();
    }

    public JavaDoc getJavaDoc() {
        return this.entityParameter == null ? null : this.entityParameter.getJavaDoc();
    }
}

