/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.api.InterfaceDescriptionFile;
import com.webcohesion.enunciate.api.resources.ResourceApi;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.TypeElementComparator;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.metadata.rs.ServiceContextRoot;
import com.webcohesion.enunciate.module.EnunciateModuleContext;
import com.webcohesion.enunciate.modules.jaxrs.JaxrsModule;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.AnnotationBasedResourceGroupImpl;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.PathBasedResourceGroupImpl;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.ResourceClassResourceGroupImpl;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.ResourceImpl;
import com.webcohesion.enunciate.modules.jaxrs.model.Resource;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceMethod;
import com.webcohesion.enunciate.modules.jaxrs.model.RootResource;
import com.webcohesion.enunciate.modules.jaxrs.model.util.JaxrsUtil;
import com.webcohesion.enunciate.modules.jaxrs.model.util.MediaType;
import com.webcohesion.enunciate.util.OneTimeLogMessage;
import com.webcohesion.enunciate.util.PathSortStrategy;
import com.webcohesion.enunciate.util.ResourceComparator;
import com.webcohesion.enunciate.util.ResourceGroupComparator;
import com.webcohesion.enunciate.util.SortedList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import org.apache.commons.configuration.HierarchicalConfiguration;

public class EnunciateJaxrsContext
extends EnunciateModuleContext
implements ResourceApi {
    private final Map<String, String> mediaTypeIds;
    private final Set<RootResource> rootResources;
    private final Set<TypeElement> providers;
    private final Set<String> customResourceParameterAnnotations;
    private final Set<String> systemResourceParameterAnnotations;
    private String relativeContextPath = "";
    private GroupingStrategy groupingStrategy = GroupingStrategy.resource_class;
    private PathSortStrategy pathSortStrategy = PathSortStrategy.breadth_first;
    private InterfaceDescriptionFile wadlFile = null;
    private final boolean disableExamples;

    public EnunciateJaxrsContext(EnunciateContext context, boolean disableExamples) {
        super(context);
        this.disableExamples = disableExamples;
        this.mediaTypeIds = this.loadKnownMediaTypes();
        this.rootResources = new TreeSet<RootResource>(new RootResourceComparator());
        this.providers = new TreeSet<TypeElement>((Comparator<TypeElement>)new TypeElementComparator());
        this.customResourceParameterAnnotations = this.loadKnownCustomResourceParameterAnnotations(context);
        this.systemResourceParameterAnnotations = this.loadKnownSystemResourceParameterAnnotations(context);
    }

    protected Map<String, String> loadKnownMediaTypes() {
        HashMap<String, String> mediaTypes = new HashMap<String, String>();
        mediaTypes.put("application/atom+xml", "atom");
        mediaTypes.put("application/x-www-form-urlencoded", "form");
        mediaTypes.put("application/json", "json");
        mediaTypes.put("application/octet-stream", "bin");
        mediaTypes.put("application/svg+xml", "svg");
        mediaTypes.put("application/xhtml+xml", "xhtml");
        mediaTypes.put("application/xml", "xml");
        mediaTypes.put("multipart/form-data", "multipart");
        mediaTypes.put("text/html", "html");
        mediaTypes.put("text/plain", "text");
        return mediaTypes;
    }

    protected Set<String> loadKnownCustomResourceParameterAnnotations(EnunciateContext context) {
        TreeSet<String> customResourceParameterAnnotations = new TreeSet<String>();
        customResourceParameterAnnotations.add("com.sun.jersey.multipart.FormDataParam");
        customResourceParameterAnnotations.add("org.glassfish.jersey.media.multipart.FormDataParam");
        customResourceParameterAnnotations.add("org.apache.cxf.jaxrs.ext.multipart.Multipart");
        List configuredParameterAnnotations = context.getConfiguration().getSource().configurationsAt("modules.jaxrs.custom-resource-parameter-annotation");
        for (HierarchicalConfiguration configuredParameterAnnotation : configuredParameterAnnotations) {
            String fqn = configuredParameterAnnotation.getString("[@qualifiedName]", null);
            if (fqn == null) continue;
            customResourceParameterAnnotations.add(fqn);
        }
        return customResourceParameterAnnotations;
    }

    protected Set<String> loadKnownSystemResourceParameterAnnotations(EnunciateContext context) {
        TreeSet<String> systemResourceParameterAnnotations = new TreeSet<String>();
        systemResourceParameterAnnotations.add("javax.inject.Inject");
        systemResourceParameterAnnotations.add("com.sun.jersey.api.core.InjectParam");
        systemResourceParameterAnnotations.add("org.springframework.beans.factory.annotation.Autowired");
        List configuredSystemAnnotations = context.getConfiguration().getSource().configurationsAt("modules.jaxrs.custom-system-parameter-annotation");
        for (HierarchicalConfiguration configuredSystemAnnotation : configuredSystemAnnotations) {
            String fqn = configuredSystemAnnotation.getString("[@qualifiedName]", null);
            if (fqn == null) continue;
            systemResourceParameterAnnotations.add(fqn);
        }
        return systemResourceParameterAnnotations;
    }

    public EnunciateContext getContext() {
        return this.context;
    }

    public Map<String, String> getMediaTypeIds() {
        return this.mediaTypeIds;
    }

    public boolean isDisableExamples() {
        return this.disableExamples;
    }

    public void addMediaType(MediaType mediaType) {
        String id;
        if (!this.mediaTypeIds.containsKey(mediaType.getMediaType()) && (id = this.getDefaultContentTypeId(mediaType.getMediaType())) != null) {
            this.mediaTypeIds.put(mediaType.getMediaType(), id);
        }
    }

    protected String getDefaultContentTypeId(String contentType) {
        int plus;
        int lastSlash;
        String id = contentType;
        if (id.endsWith("/")) {
            throw new IllegalArgumentException("Illegal content type: " + id);
        }
        int semiColon = id.indexOf(59);
        if (semiColon > -1) {
            id = id.substring(0, semiColon);
        }
        if ((lastSlash = id.lastIndexOf(47)) > -1) {
            id = id.substring(lastSlash + 1);
        }
        if ((plus = id.indexOf(43)) > -1) {
            id = id.substring(0, plus);
        }
        if (id.contains("*")) {
            return null;
        }
        return id;
    }

    public Set<RootResource> getRootResources() {
        return this.rootResources;
    }

    public Set<TypeElement> getProviders() {
        return this.providers;
    }

    public Set<String> getCustomResourceParameterAnnotations() {
        return this.customResourceParameterAnnotations;
    }

    public Set<String> getSystemResourceParameterAnnotations() {
        return this.systemResourceParameterAnnotations;
    }

    public void add(RootResource rootResource) {
        if (rootResource.isInterface()) {
            for (RootResource resource : this.rootResources) {
                if (!((DecoratedTypeMirror)resource.asType()).isInstanceOf((Element)((Object)rootResource))) continue;
                this.debug("%s was identified as a JAX-RS root resource, but will be ignored because root resource %s implements it.", new Object[]{rootResource.getQualifiedName(), resource.getQualifiedName()});
                return;
            }
        } else {
            DecoratedTypeMirror rootResourceType = (DecoratedTypeMirror)rootResource.asType();
            Iterator<RootResource> it = this.rootResources.iterator();
            while (it.hasNext()) {
                RootResource resource = it.next();
                if (!rootResourceType.isInstanceOf((Element)((Object)resource))) continue;
                this.debug("%s was identified as a JAX-RS root resource, but will be ignored because root resource %s implements it.", new Object[]{resource.getQualifiedName(), rootResource.getQualifiedName()});
                it.remove();
            }
        }
        this.rootResources.add(rootResource);
        this.debug("Added %s as a JAX-RS root resource.", new Object[]{rootResource.getQualifiedName()});
        if (this.getContext().getProcessingEnvironment().findSourcePosition((Element)((Object)rootResource)) == null) {
            OneTimeLogMessage.SOURCE_FILES_NOT_FOUND.log(this.getContext());
            this.debug("Unable to find source file for %s.", new Object[]{rootResource.getQualifiedName()});
        }
    }

    public void addJAXRSProvider(TypeElement declaration) {
        Consumes consumes;
        this.providers.add(declaration);
        this.debug("Added %s as a JAX-RS provider.", new Object[]{declaration.getQualifiedName()});
        Produces produces = declaration.getAnnotation(Produces.class);
        if (produces != null) {
            for (MediaType contentType : JaxrsUtil.value(produces)) {
                this.addMediaType(contentType);
            }
        }
        if ((consumes = declaration.getAnnotation(Consumes.class)) != null) {
            for (MediaType contentType : JaxrsUtil.value(consumes)) {
                this.addMediaType(contentType);
            }
        }
    }

    public boolean isIncludeResourceGroupName() {
        return this.groupingStrategy != GroupingStrategy.path;
    }

    public void setRelativeContextPath(String relativeContextPath) {
        this.relativeContextPath = relativeContextPath;
    }

    public void setGroupingStrategy(GroupingStrategy groupingStrategy) {
        this.groupingStrategy = groupingStrategy;
    }

    public PathSortStrategy getPathSortStrategy() {
        return this.pathSortStrategy;
    }

    public void setPathSortStrategy(PathSortStrategy pathSortStrategy) {
        this.pathSortStrategy = pathSortStrategy;
    }

    public InterfaceDescriptionFile getWadlFile() {
        return this.wadlFile;
    }

    public void setWadlFile(InterfaceDescriptionFile wadlFile) {
        this.wadlFile = wadlFile;
    }

    public List<ResourceGroup> getResourceGroups() {
        List<ResourceGroup> resourceGroups = this.groupingStrategy == GroupingStrategy.path ? this.getResourceGroupsByPath() : (this.groupingStrategy == GroupingStrategy.annotation ? this.getResourceGroupsByAnnotation() : this.getResourceGroupsByClass());
        Collections.sort(resourceGroups, new Comparator<ResourceGroup>(){

            @Override
            public int compare(ResourceGroup o1, ResourceGroup o2) {
                return o1.getLabel().compareTo(o2.getLabel());
            }
        });
        return resourceGroups;
    }

    public List<ResourceGroup> getResourceGroupsByClass() {
        ArrayList<ResourceGroup> resourceGroups = new ArrayList<ResourceGroup>();
        TreeSet<String> slugs = new TreeSet<String>();
        for (RootResource rootResource : this.rootResources) {
            String slug = rootResource.getSimpleName().toString();
            if (slugs.contains(slug)) {
                slug = "";
                String[] qualifiedNameTokens = rootResource.getQualifiedName().toString().split("\\.");
                for (int i = qualifiedNameTokens.length - 1; i >= 0; --i) {
                    String string = slug = slug.isEmpty() ? qualifiedNameTokens[i] : slug + "_" + qualifiedNameTokens[i];
                    if (!slugs.contains(slug)) break;
                }
            }
            slugs.add(slug);
            ServiceContextRoot context = (ServiceContextRoot)rootResource.getAnnotation(ServiceContextRoot.class);
            for (Resource resource = rootResource.getParent(); context == null && resource != null; resource = resource.getParent()) {
                context = (ServiceContextRoot)resource.getAnnotation(ServiceContextRoot.class);
            }
            String contextPath = context != null ? JaxrsModule.sanitizeContextPath(context.value()) : this.relativeContextPath;
            ResourceClassResourceGroupImpl group = new ResourceClassResourceGroupImpl(rootResource, slug, contextPath);
            if (group.getResources().isEmpty()) continue;
            resourceGroups.add(group);
        }
        Collections.sort(resourceGroups, new ResourceGroupComparator(this.pathSortStrategy));
        return resourceGroups;
    }

    public List<ResourceGroup> getResourceGroupsByPath() {
        HashMap<String, PathBasedResourceGroupImpl> resourcesByPath = new HashMap<String, PathBasedResourceGroupImpl>();
        FacetFilter facetFilter = this.context.getConfiguration().getFacetFilter();
        for (RootResource rootResource : this.rootResources) {
            for (ResourceMethod method : rootResource.getResourceMethods(true)) {
                if (!facetFilter.accept((HasFacets)method)) continue;
                ServiceContextRoot context = (ServiceContextRoot)method.getAnnotation(ServiceContextRoot.class);
                for (Resource resource = method.getParent(); context == null && resource != null; resource = resource.getParent()) {
                    context = (ServiceContextRoot)resource.getAnnotation(ServiceContextRoot.class);
                }
                String path = method.getFullpath();
                PathBasedResourceGroupImpl resourceGroup = (PathBasedResourceGroupImpl)resourcesByPath.get(path);
                if (resourceGroup == null) {
                    String contextPath = context != null ? JaxrsModule.sanitizeContextPath(context.value()) : this.relativeContextPath;
                    resourceGroup = new PathBasedResourceGroupImpl(contextPath, path, new ArrayList<com.webcohesion.enunciate.api.resources.Resource>());
                    resourcesByPath.put(path, resourceGroup);
                }
                resourceGroup.getResources().add(new ResourceImpl(method, resourceGroup));
            }
        }
        ArrayList<ResourceGroup> resourceGroups = new ArrayList<ResourceGroup>(resourcesByPath.values());
        Collections.sort(resourceGroups, new ResourceGroupComparator(this.pathSortStrategy));
        return resourceGroups;
    }

    public List<ResourceGroup> getResourceGroupsByAnnotation() {
        HashMap<String, AnnotationBasedResourceGroupImpl> resourcesByAnnotation = new HashMap<String, AnnotationBasedResourceGroupImpl>();
        FacetFilter facetFilter = this.context.getConfiguration().getFacetFilter();
        for (RootResource rootResource : this.rootResources) {
            for (ResourceMethod method : rootResource.getResourceMethods(true)) {
                Resource resource;
                if (!facetFilter.accept((HasFacets)method)) continue;
                com.webcohesion.enunciate.metadata.rs.ResourceGroup annotation = (com.webcohesion.enunciate.metadata.rs.ResourceGroup)method.getAnnotation(com.webcohesion.enunciate.metadata.rs.ResourceGroup.class);
                for (resource = method.getParent(); annotation == null && resource != null; resource = resource.getParent()) {
                    annotation = (com.webcohesion.enunciate.metadata.rs.ResourceGroup)resource.getAnnotation(com.webcohesion.enunciate.metadata.rs.ResourceGroup.class);
                }
                ServiceContextRoot context = (ServiceContextRoot)method.getAnnotation(ServiceContextRoot.class);
                for (resource = method.getParent(); context == null && resource != null; resource = resource.getParent()) {
                    context = (ServiceContextRoot)resource.getAnnotation(ServiceContextRoot.class);
                }
                String label = annotation == null ? "Other" : annotation.value();
                AnnotationBasedResourceGroupImpl resourceGroup = (AnnotationBasedResourceGroupImpl)resourcesByAnnotation.get(label);
                if (resourceGroup == null) {
                    String contextPath = context != null ? JaxrsModule.sanitizeContextPath(context.value()) : this.relativeContextPath;
                    resourceGroup = new AnnotationBasedResourceGroupImpl(contextPath, label, (List<com.webcohesion.enunciate.api.resources.Resource>)new SortedList((Comparator)new ResourceComparator(this.pathSortStrategy)), this.pathSortStrategy);
                    resourcesByAnnotation.put(label, resourceGroup);
                }
                resourceGroup.getResources().add(new ResourceImpl(method, resourceGroup));
            }
        }
        ArrayList<ResourceGroup> resourceGroups = new ArrayList<ResourceGroup>(resourcesByAnnotation.values());
        Collections.sort(resourceGroups, new ResourceGroupComparator(this.pathSortStrategy));
        return resourceGroups;
    }

    private static class RootResourceComparator
    implements Comparator<RootResource> {
        private RootResourceComparator() {
        }

        @Override
        public int compare(RootResource r1, RootResource r2) {
            String key1 = r1.getPath() + r1.getQualifiedName();
            String key2 = r2.getPath() + r2.getQualifiedName();
            return key1.compareTo(key2);
        }
    }

    public static enum GroupingStrategy {
        path,
        annotation,
        resource_class;

    }
}

