/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs.model;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.EnunciateLogger;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.Annotations;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedExecutableElement;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedDeclaredType;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils;
import com.webcohesion.enunciate.javac.decorations.type.TypeVariableContext;
import com.webcohesion.enunciate.javac.javadoc.DocComment;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.javac.javadoc.ParamDocComment;
import com.webcohesion.enunciate.javac.javadoc.ReturnDocComment;
import com.webcohesion.enunciate.javac.javadoc.StaticDocComment;
import com.webcohesion.enunciate.metadata.rs.JakartaResourceMethodSignature;
import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResourceLabel;
import com.webcohesion.enunciate.metadata.rs.ResourceMethodSignature;
import com.webcohesion.enunciate.metadata.rs.ResponseHeaders;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import com.webcohesion.enunciate.metadata.rs.Warnings;
import com.webcohesion.enunciate.modules.jaxrs.EnunciateJaxrsContext;
import com.webcohesion.enunciate.modules.jaxrs.model.ExplicitResourceParameter;
import com.webcohesion.enunciate.modules.jaxrs.model.PathContext;
import com.webcohesion.enunciate.modules.jaxrs.model.PathSegment;
import com.webcohesion.enunciate.modules.jaxrs.model.Resource;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceEntityParameter;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceParameter;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceParameterType;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceRepresentationMetadata;
import com.webcohesion.enunciate.modules.jaxrs.model.ResponseCode;
import com.webcohesion.enunciate.modules.jaxrs.model.SubResource;
import com.webcohesion.enunciate.modules.jaxrs.model.util.JaxrsUtil;
import com.webcohesion.enunciate.modules.jaxrs.model.util.MediaType;
import com.webcohesion.enunciate.modules.jaxrs.model.util.RSParamDocComment;
import com.webcohesion.enunciate.modules.jaxrs.model.util.ReturnWrappedDocComment;
import com.webcohesion.enunciate.util.AnnotationUtils;
import com.webcohesion.enunciate.util.JAXDocletUtil;
import com.webcohesion.enunciate.util.TypeHintUtils;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.security.RolesAllowed;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.ws.rs.CookieParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

public class ResourceMethod
extends DecoratedExecutableElement
implements HasFacets,
PathContext {
    private static final Pattern CONTEXT_PARAM_PATTERN = Pattern.compile("\\{([^\\}]+)\\}");
    private final EnunciateJaxrsContext context;
    private final String subpath;
    private final String label;
    private final String customParameterName;
    private final Set<String> httpMethods;
    private final Set<MediaType> consumesMediaTypes;
    private final Set<MediaType> producesMediaTypes;
    private final Resource parent;
    private final Set<ResourceParameter> resourceParameters;
    private final ResourceEntityParameter entityParameter;
    private final Map<String, Object> metaData = new HashMap<String, Object>();
    private final List<? extends ResponseCode> statusCodes;
    private final List<? extends ResponseCode> warnings;
    private final Map<String, String> responseHeaders;
    private final ResourceRepresentationMetadata representationMetadata;
    private final Set<Facet> facets = new TreeSet<Facet>();
    private final List<PathSegment> pathComponents;

    public ResourceMethod(ExecutableElement delegate, Resource parent, TypeVariableContext variableContext, EnunciateJaxrsContext context) {
        super(delegate, context.getContext().getProcessingEnvironment());
        DecoratedProcessingEnvironment env;
        Set<Object> resourceParameters;
        ResourceEntityParameter entityParameter;
        this.context = context;
        Set<String> httpMethods = this.loadHttpMethods(delegate);
        if (httpMethods.isEmpty()) {
            throw new IllegalStateException("A resource method must specify an HTTP method by using a request method designator annotation.");
        }
        this.httpMethods = httpMethods;
        this.consumesMediaTypes = this.loadConsumes(delegate, parent);
        this.producesMediaTypes = this.loadProduces(delegate, parent);
        String label = null;
        ResourceLabel resourceLabel = delegate.getAnnotation(ResourceLabel.class);
        if (resourceLabel != null && "##default".equals(label = resourceLabel.value())) {
            label = null;
        }
        String subpath = null;
        Path pathInfo = delegate.getAnnotation(Path.class);
        jakarta.ws.rs.Path pathInfo2 = delegate.getAnnotation(jakarta.ws.rs.Path.class);
        if (pathInfo != null || pathInfo2 != null) {
            subpath = pathInfo != null ? pathInfo.value() : pathInfo2.value();
        }
        List<PathSegment> pathComponents = Resource.extractPathComponents(subpath);
        String customParameterName = null;
        ResourceRepresentationMetadata outputPayload = null;
        ResourceMethodSignature signatureOverride = delegate.getAnnotation(ResourceMethodSignature.class);
        JakartaResourceMethodSignature signatureOverride2 = delegate.getAnnotation(JakartaResourceMethodSignature.class);
        if (signatureOverride == null && signatureOverride2 == null) {
            entityParameter = null;
            resourceParameters = new TreeSet();
            for (VariableElement parameterDeclaration : this.getParameters()) {
                if (AnnotationUtils.isIgnored((Element)parameterDeclaration)) continue;
                if (ResourceParameter.isResourceParameter(parameterDeclaration, context)) {
                    resourceParameters.add(new ResourceParameter(parameterDeclaration, this));
                    continue;
                }
                if (ResourceParameter.isBeanParameter(parameterDeclaration)) {
                    resourceParameters.addAll(ResourceParameter.getFormBeanParameters(parameterDeclaration, this));
                    continue;
                }
                if (ResourceParameter.isSystemParameter(parameterDeclaration, context)) continue;
                entityParameter = new ResourceEntityParameter(this, parameterDeclaration, variableContext, context);
                customParameterName = parameterDeclaration.getSimpleName().toString();
            }
            DecoratedTypeMirror returnType = this.loadReturnType();
            returnType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)variableContext.resolveTypeVariables((TypeMirror)returnType, (ProcessingEnvironment)this.env), (DecoratedProcessingEnvironment)this.env);
            returnType.setDeferredDocComment((DocComment)new ReturnDocComment((DecoratedExecutableElement)this));
            outputPayload = returnType.isVoid() || returnType.isInstanceOf(Void.class) ? null : new ResourceRepresentationMetadata(returnType);
        } else {
            entityParameter = this.loadEntityParameter(signatureOverride, signatureOverride2);
            resourceParameters = this.loadResourceParameters(signatureOverride, signatureOverride2);
            outputPayload = this.loadOutputPayload(signatureOverride, signatureOverride2);
        }
        if (outputPayload == null && this.getJavaDoc().get((Object)"responseExample") != null) {
            env = context.getContext().getProcessingEnvironment();
            outputPayload = new ResourceRepresentationMetadata((TypeMirror)TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)env), (DocComment)new StaticDocComment(""));
        }
        if (entityParameter == null && this.getJavaDoc().get((Object)"requestExample") != null) {
            env = context.getContext().getProcessingEnvironment();
            entityParameter = new ResourceEntityParameter((Element)((Object)this), (TypeMirror)TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)env), env);
        }
        resourceParameters.addAll(this.loadExtraParameters(parent, context));
        this.entityParameter = entityParameter;
        this.resourceParameters = resourceParameters;
        this.subpath = subpath;
        this.label = label;
        this.customParameterName = customParameterName;
        this.parent = parent;
        this.statusCodes = this.loadStatusCodes(parent);
        this.warnings = this.loadWarnings(parent);
        this.representationMetadata = outputPayload;
        this.facets.addAll(Facet.gatherFacets((Element)delegate, (EnunciateContext)context.getContext()));
        this.facets.addAll(parent.getFacets());
        this.pathComponents = pathComponents;
        this.responseHeaders = this.loadResponseHeaders(parent);
    }

    protected Set<String> loadHttpMethods(ExecutableElement delegate) {
        TreeSet<String> httpMethods = new TreeSet<String>();
        List<? extends AnnotationMirror> mirrors = delegate.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirrors) {
            Element annotationDeclaration = annotationMirror.getAnnotationType().asElement();
            HttpMethod httpMethodInfo = annotationDeclaration.getAnnotation(HttpMethod.class);
            jakarta.ws.rs.HttpMethod httpMethodInfo2 = annotationDeclaration.getAnnotation(jakarta.ws.rs.HttpMethod.class);
            if (httpMethodInfo == null && httpMethodInfo2 == null) continue;
            httpMethods.add(httpMethodInfo != null ? httpMethodInfo.value() : httpMethodInfo2.value());
        }
        ApiOperation apiOperation = delegate.getAnnotation(ApiOperation.class);
        if (apiOperation != null && !apiOperation.httpMethod().isEmpty()) {
            httpMethods.clear();
            httpMethods.add(apiOperation.httpMethod());
        }
        return httpMethods;
    }

    public Map<String, String> loadResponseHeaders(Resource parent) {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        ResponseHeaders responseHeaderInfo = (ResponseHeaders)this.getAnnotation(ResponseHeaders.class);
        if (responseHeaderInfo != null) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseHeader responseHeader : responseHeaderInfo.value()) {
                responseHeaders.put(responseHeader.name(), responseHeader.description());
            }
        }
        List inheritedResponseHeaders = AnnotationUtils.getAnnotations(ResponseHeaders.class, (Element)((Object)parent), (boolean)true);
        for (ResponseHeaders inheritedResponseHeader : inheritedResponseHeaders) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseHeader header : inheritedResponseHeader.value()) {
                responseHeaders.put(header.name(), header.description());
            }
        }
        JavaDoc.JavaDocTagList doclets = (JavaDoc.JavaDocTagList)this.getJavaDoc().get((Object)"ResponseHeader");
        if (doclets != null) {
            for (String string : doclets) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)string);
                String header = firstspace > 0 ? string.substring(0, firstspace) : string;
                String doc = firstspace > 0 && firstspace + 1 < string.length() ? string.substring(firstspace + 1) : "";
                responseHeaders.put(header, doc);
            }
        }
        List inheritedDoclets = AnnotationUtils.getJavaDocTags((String)"ResponseHeader", (Element)((Object)parent));
        for (JavaDoc.JavaDocTagList inheritedDoclet : inheritedDoclets) {
            for (String doclet : inheritedDoclet) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)doclet);
                String header = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                responseHeaders.put(header, doc);
            }
        }
        return responseHeaders;
    }

    public ArrayList<ResponseCode> loadWarnings(Resource parent) {
        ArrayList<ResponseCode> warnings = new ArrayList<ResponseCode>();
        Warnings warningInfo = (Warnings)this.getAnnotation(Warnings.class);
        if (warningInfo != null) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseCode responseCode : warningInfo.value()) {
                ResponseCode rc2 = new ResponseCode(this);
                rc2.setCode(responseCode.code());
                rc2.setCondition(responseCode.condition());
                warnings.add(rc2);
            }
        }
        List inheritedWarnings = AnnotationUtils.getAnnotations(Warnings.class, (Element)((Object)parent), (boolean)true);
        for (Warnings inheritedWarning : inheritedWarnings) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseCode code : inheritedWarning.value()) {
                ResponseCode rc = new ResponseCode(this);
                rc.setCode(code.code());
                rc.setCondition(code.condition());
                warnings.add(rc);
            }
        }
        JavaDoc.JavaDocTagList doclets = (JavaDoc.JavaDocTagList)this.getJavaDoc().get((Object)"HTTPWarning");
        if (doclets != null) {
            for (String string : doclets) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)string);
                String code = firstspace > 0 ? string.substring(0, firstspace) : string;
                String doc = firstspace > 0 && firstspace + 1 < string.length() ? string.substring(firstspace + 1) : "";
                try {
                    ResponseCode rc3 = new ResponseCode(this);
                    rc3.setCode(Integer.parseInt(code));
                    rc3.setCondition(doc);
                    warnings.add(rc3);
                }
                catch (NumberFormatException rc3) {}
            }
        }
        List inheritedDoclets = AnnotationUtils.getJavaDocTags((String)"HTTPWarning", (Element)((Object)parent));
        for (JavaDoc.JavaDocTagList inheritedDoclet : inheritedDoclets) {
            for (String doclet : inheritedDoclet) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)doclet);
                String code = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                try {
                    ResponseCode rc4 = new ResponseCode(this);
                    rc4.setCode(Integer.parseInt(code));
                    rc4.setCondition(doc);
                    warnings.add(rc4);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return warnings;
    }

    protected Set<MediaType> loadConsumes(ExecutableElement delegate, Resource parent) {
        javax.ws.rs.Consumes consumesInfo = delegate.getAnnotation(javax.ws.rs.Consumes.class);
        Consumes consumesInfo2 = delegate.getAnnotation(Consumes.class);
        TreeSet<MediaType> consumes = consumesInfo != null || consumesInfo2 != null ? new TreeSet<MediaType>(JaxrsUtil.value(consumesInfo != null ? consumesInfo.value() : consumesInfo2.value())) : new TreeSet<MediaType>(parent.getConsumesMediaTypes());
        ApiOperation apiOperation = delegate.getAnnotation(ApiOperation.class);
        if (apiOperation != null && !apiOperation.consumes().isEmpty()) {
            consumes = new TreeSet();
            for (String mediaType : apiOperation.consumes().split(",")) {
                if ((mediaType = mediaType.trim()).isEmpty()) continue;
                consumes.add(new MediaType(mediaType, 1.0f));
            }
        }
        return consumes;
    }

    protected Set<MediaType> loadProduces(ExecutableElement delegate, Resource parent) {
        Produces producesInfo = delegate.getAnnotation(Produces.class);
        jakarta.ws.rs.Produces producesInfo2 = delegate.getAnnotation(jakarta.ws.rs.Produces.class);
        TreeSet<MediaType> produces = producesInfo != null || producesInfo2 != null ? new TreeSet<MediaType>(JaxrsUtil.value(producesInfo != null ? producesInfo.value() : producesInfo2.value())) : new TreeSet<MediaType>(parent.getProducesMediaTypes());
        ApiOperation apiOperation = delegate.getAnnotation(ApiOperation.class);
        if (apiOperation != null && !apiOperation.produces().isEmpty()) {
            produces = new TreeSet();
            for (String mediaType : apiOperation.produces().split(",")) {
                if ((mediaType = mediaType.trim()).isEmpty()) continue;
                produces.add(new MediaType(mediaType, 1.0f));
            }
        }
        return produces;
    }

    protected DecoratedTypeMirror loadReturnType() {
        DecoratedTypeMirror returnWrapped;
        DecoratedTypeMirror swaggerReturnType;
        DecoratedTypeMirror returnType;
        TypeHint hintInfo = (TypeHint)this.getAnnotation(TypeHint.class);
        if (hintInfo != null) {
            returnType = (DecoratedTypeMirror)TypeHintUtils.getTypeHint((TypeHint)hintInfo, (DecoratedProcessingEnvironment)this.env, (TypeMirror)this.getReturnType());
            returnType.setDeferredDocComment((DocComment)new ReturnDocComment((DecoratedExecutableElement)this));
        } else {
            returnType = (DecoratedTypeMirror)this.getReturnType();
            if (returnType.isClass() && returnType.isInstanceOf("com.sun.jersey.api.JResponse")) {
                DecoratedTypeMirror responseType;
                DecoratedDeclaredType jresponse = (DecoratedDeclaredType)returnType;
                if (!jresponse.getTypeArguments().isEmpty() && (responseType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)((TypeMirror)jresponse.getTypeArguments().get(0)), (DecoratedProcessingEnvironment)this.env)).isDeclared()) {
                    responseType.setDeferredDocComment((DocComment)new ReturnDocComment((DecoratedExecutableElement)this));
                    returnType = responseType;
                }
            } else if (returnType.isInstanceOf(javax.ws.rs.core.Response.class) || returnType.isInstanceOf(Response.class) || returnType.isInstanceOf(InputStream.class)) {
                DecoratedDeclaredType objectType = (DecoratedDeclaredType)TypeMirrorDecorator.decorate((TypeMirror)this.env.getElementUtils().getTypeElement(Object.class.getName()).asType(), (DecoratedProcessingEnvironment)this.env);
                objectType.setDeferredDocComment((DocComment)new ReturnDocComment((DecoratedExecutableElement)this));
                returnType = objectType;
            }
        }
        final ApiOperation apiOperation = (ApiOperation)this.getAnnotation(ApiOperation.class);
        if (apiOperation != null && (swaggerReturnType = Annotations.mirrorOf((Callable)new Callable<Class<?>>(){

            @Override
            public Class<?> call() throws Exception {
                return apiOperation.response();
            }
        }, (DecoratedProcessingEnvironment)this.env, Void.class)) != null) {
            if (!apiOperation.responseContainer().isEmpty()) {
                swaggerReturnType = (DecoratedTypeMirror)this.env.getTypeUtils().getArrayType((TypeMirror)swaggerReturnType);
                swaggerReturnType.setDeferredDocComment((DocComment)new ReturnDocComment((DecoratedExecutableElement)this));
            }
            returnType = swaggerReturnType;
        }
        if ((returnWrapped = JAXDocletUtil.getReturnWrapped((String)this.getDocComment(), (DecoratedProcessingEnvironment)this.env, (EnunciateLogger)this.getContext().getContext().getLogger())) != null) {
            returnWrapped.setDeferredDocComment((DocComment)new ReturnWrappedDocComment(this));
            returnType = returnWrapped;
        }
        return returnType;
    }

    private boolean isNoContentType(String fqn) {
        String noContentClassName = TypeHint.NO_CONTENT.class.getName();
        return fqn.equals(noContentClassName.replace('$', '.'));
    }

    public Set<ResourceParameter> loadExtraParameters(Resource parent, EnunciateJaxrsContext context) {
        TreeSet<ResourceParameter> extraParameters = new TreeSet<ResourceParameter>();
        JavaDoc localDoc = new JavaDoc(this.getDocComment(), null, null, this.env);
        JavaDoc.JavaDocTagList doclets = (JavaDoc.JavaDocTagList)localDoc.get((Object)"RequestHeader");
        if (doclets != null) {
            for (Object doclet : doclets) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)doclet);
                Object header = firstspace > 0 ? ((String)doclet).substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < ((String)doclet).length() ? ((String)doclet).substring(firstspace + 1) : "";
                extraParameters.add(new ExplicitResourceParameter(this, (DocComment)new StaticDocComment(doc), (String)header, ResourceParameterType.HEADER, context));
            }
        }
        List inheritedDoclets = AnnotationUtils.getJavaDocTags((String)"RequestHeader", (Element)((Object)parent));
        for (JavaDoc.JavaDocTagList inheritedDoclet : inheritedDoclets) {
            for (String doclet : inheritedDoclet) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)doclet);
                String header = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                extraParameters.add(new ExplicitResourceParameter(this, (DocComment)new StaticDocComment(doc), header, ResourceParameterType.HEADER, context));
            }
        }
        RequestHeaders requestHeaders = (RequestHeaders)this.getAnnotation(RequestHeaders.class);
        if (requestHeaders != null) {
            for (RequestHeader header : requestHeaders.value()) {
                extraParameters.add(new ExplicitResourceParameter(this, (DocComment)new StaticDocComment(header.description()), header.name(), ResourceParameterType.HEADER, context));
            }
        }
        List inheritedRequestHeaders = AnnotationUtils.getAnnotations(RequestHeaders.class, (Element)((Object)parent), (boolean)true);
        for (RequestHeaders inheritedRequestHeader : inheritedRequestHeaders) {
            for (RequestHeader header : inheritedRequestHeader.value()) {
                extraParameters.add(new ExplicitResourceParameter(this, (DocComment)new StaticDocComment(header.description()), header.name(), ResourceParameterType.HEADER, context));
            }
        }
        ApiImplicitParams swaggerImplicitParams = (ApiImplicitParams)this.getAnnotation(ApiImplicitParams.class);
        if (swaggerImplicitParams != null) {
            for (ApiImplicitParam swaggerImplicitParam : swaggerImplicitParams.value()) {
                ResourceParameterType parameterType;
                try {
                    parameterType = ResourceParameterType.valueOf(swaggerImplicitParam.paramType().toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                extraParameters.add(new ExplicitResourceParameter(this, (DocComment)new StaticDocComment(swaggerImplicitParam.value()), swaggerImplicitParam.name(), parameterType, context));
            }
        }
        return extraParameters;
    }

    public ArrayList<ResponseCode> loadStatusCodes(Resource parent) {
        ArrayList<ResponseCode> statusCodes = new ArrayList<ResponseCode>();
        StatusCodes codes = (StatusCodes)this.getAnnotation(StatusCodes.class);
        if (codes != null) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseCode responseCode : codes.value()) {
                ResponseCode rc = new ResponseCode(this);
                rc.setCode(responseCode.code());
                rc.setCondition(responseCode.condition());
                for (com.webcohesion.enunciate.metadata.rs.ResponseHeader responseHeader : responseCode.additionalHeaders()) {
                    rc.setAdditionalHeader(responseHeader.name(), responseHeader.description());
                }
                rc.setType((DecoratedTypeMirror)TypeHintUtils.getTypeHint((TypeHint)responseCode.type(), (DecoratedProcessingEnvironment)this.env, null));
                statusCodes.add(rc);
            }
        }
        List inheritedStatusCodes = AnnotationUtils.getAnnotations(StatusCodes.class, (Element)((Object)parent), (boolean)true);
        for (StatusCodes inheritedStatusCode : inheritedStatusCodes) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseCode code : inheritedStatusCode.value()) {
                ResponseCode rc = new ResponseCode(this);
                rc.setCode(code.code());
                rc.setCondition(code.condition());
                for (com.webcohesion.enunciate.metadata.rs.ResponseHeader header : code.additionalHeaders()) {
                    rc.setAdditionalHeader(header.name(), header.description());
                }
                rc.setType((DecoratedTypeMirror)TypeHintUtils.getTypeHint((TypeHint)code.type(), (DecoratedProcessingEnvironment)this.env, null));
                statusCodes.add(rc);
            }
        }
        JavaDoc.JavaDocTagList doclets = (JavaDoc.JavaDocTagList)this.getJavaDoc().get((Object)"HTTP");
        if (doclets != null) {
            for (String string : doclets) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)string);
                String code = firstspace > 0 ? string.substring(0, firstspace) : string;
                String doc = firstspace > 0 && firstspace + 1 < string.length() ? string.substring(firstspace + 1) : "";
                try {
                    ResponseCode rc = new ResponseCode(this);
                    rc.setCode(Integer.parseInt(code));
                    rc.setCondition(doc);
                    statusCodes.add(rc);
                }
                catch (NumberFormatException rc) {}
            }
        }
        List inheritedDoclets = AnnotationUtils.getJavaDocTags((String)"HTTP", (Element)((Object)parent));
        for (JavaDoc.JavaDocTagList inheritedDoclet : inheritedDoclets) {
            for (String doclet : inheritedDoclet) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)doclet);
                String string = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                try {
                    ResponseCode rc = new ResponseCode(this);
                    rc.setCode(Integer.parseInt(string));
                    rc.setCondition(doc);
                    statusCodes.add(rc);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        ApiResponses apiResponses = (ApiResponses)this.getAnnotation(ApiResponses.class);
        if (apiResponses != null) {
            for (ApiResponse swaggerResponse : apiResponses.value()) {
                ResponseHeader[] headers;
                ResponseCode responseCode = new ResponseCode(this);
                responseCode.setCode(swaggerResponse.code());
                responseCode.setCondition(swaggerResponse.message());
                for (ResponseHeader header : headers = swaggerResponse.responseHeaders()) {
                    if (header.name().isEmpty()) continue;
                    responseCode.setAdditionalHeader(header.name(), header.description());
                }
                statusCodes.add(responseCode);
            }
        }
        return statusCodes;
    }

    protected ResourceRepresentationMetadata loadOutputPayload(ResourceMethodSignature signatureOverride, JakartaResourceMethodSignature signatureOverride2) {
        DecoratedTypeMirror returnType = (DecoratedTypeMirror)this.getReturnType();
        try {
            Class outputType;
            Class clazz = outputType = signatureOverride != null ? signatureOverride.output() : signatureOverride2.output();
            if (outputType != ResourceMethodSignature.NONE.class) {
                TypeElement type = this.env.getElementUtils().getTypeElement(outputType.getName());
                return new ResourceRepresentationMetadata(this.env.getTypeUtils().getDeclaredType(type, new TypeMirror[0]), returnType.getDeferredDocComment());
            }
        }
        catch (MirroredTypeException e) {
            DecoratedTypeMirror typeMirror = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)e.getTypeMirror(), (DecoratedProcessingEnvironment)this.env);
            if (typeMirror.isInstanceOf(ResourceMethodSignature.class.getName() + ".NONE")) {
                return null;
            }
            return new ResourceRepresentationMetadata((TypeMirror)typeMirror, returnType.getDeferredDocComment());
        }
        return null;
    }

    protected ParamDocComment createParamDocComment(VariableElement param) {
        return new RSParamDocComment(this, param.getSimpleName().toString());
    }

    protected Set<ResourceParameter> loadResourceParameters(ResourceMethodSignature signatureOverride, JakartaResourceMethodSignature signatureOverride2) {
        TreeSet<ResourceParameter> params = new TreeSet<ResourceParameter>();
        if (signatureOverride != null) {
            for (CookieParam cookieParam : signatureOverride.cookieParams()) {
                params.add(new ExplicitResourceParameter(this, (DocComment)new RSParamDocComment(this, cookieParam.value()), cookieParam.value(), ResourceParameterType.COOKIE, this.context));
            }
            for (CookieParam cookieParam : signatureOverride.matrixParams()) {
                params.add(new ExplicitResourceParameter(this, (DocComment)new RSParamDocComment(this, cookieParam.value()), cookieParam.value(), ResourceParameterType.MATRIX, this.context));
            }
            for (CookieParam cookieParam : signatureOverride.queryParams()) {
                params.add(new ExplicitResourceParameter(this, (DocComment)new RSParamDocComment(this, cookieParam.value()), cookieParam.value(), ResourceParameterType.QUERY, this.context));
            }
            for (CookieParam cookieParam : signatureOverride.pathParams()) {
                params.add(new ExplicitResourceParameter(this, (DocComment)new RSParamDocComment(this, cookieParam.value()), cookieParam.value(), ResourceParameterType.PATH, this.context));
            }
            for (CookieParam cookieParam : signatureOverride.headerParams()) {
                params.add(new ExplicitResourceParameter(this, (DocComment)new RSParamDocComment(this, cookieParam.value()), cookieParam.value(), ResourceParameterType.HEADER, this.context));
            }
            for (CookieParam cookieParam : signatureOverride.formParams()) {
                params.add(new ExplicitResourceParameter(this, (DocComment)new RSParamDocComment(this, cookieParam.value()), cookieParam.value(), ResourceParameterType.FORM, this.context));
            }
        } else {
            for (jakarta.ws.rs.CookieParam cookieParam : signatureOverride2.cookieParams()) {
                params.add(new ExplicitResourceParameter(this, (DocComment)new RSParamDocComment(this, cookieParam.value()), cookieParam.value(), ResourceParameterType.COOKIE, this.context));
            }
            for (jakarta.ws.rs.CookieParam cookieParam : signatureOverride2.matrixParams()) {
                params.add(new ExplicitResourceParameter(this, (DocComment)new RSParamDocComment(this, cookieParam.value()), cookieParam.value(), ResourceParameterType.MATRIX, this.context));
            }
            for (jakarta.ws.rs.CookieParam cookieParam : signatureOverride2.queryParams()) {
                params.add(new ExplicitResourceParameter(this, (DocComment)new RSParamDocComment(this, cookieParam.value()), cookieParam.value(), ResourceParameterType.QUERY, this.context));
            }
            for (jakarta.ws.rs.CookieParam cookieParam : signatureOverride2.pathParams()) {
                params.add(new ExplicitResourceParameter(this, (DocComment)new RSParamDocComment(this, cookieParam.value()), cookieParam.value(), ResourceParameterType.PATH, this.context));
            }
            for (jakarta.ws.rs.CookieParam cookieParam : signatureOverride2.headerParams()) {
                params.add(new ExplicitResourceParameter(this, (DocComment)new RSParamDocComment(this, cookieParam.value()), cookieParam.value(), ResourceParameterType.HEADER, this.context));
            }
            for (jakarta.ws.rs.CookieParam cookieParam : signatureOverride2.formParams()) {
                params.add(new ExplicitResourceParameter(this, (DocComment)new RSParamDocComment(this, cookieParam.value()), cookieParam.value(), ResourceParameterType.FORM, this.context));
            }
        }
        return params;
    }

    protected ResourceEntityParameter loadEntityParameter(ResourceMethodSignature signatureOverride, JakartaResourceMethodSignature signatureOverride2) {
        try {
            Class entityType;
            Class clazz = entityType = signatureOverride != null ? signatureOverride.input() : signatureOverride2.input();
            if (entityType != ResourceMethodSignature.NONE.class) {
                TypeElement type = this.env.getElementUtils().getTypeElement(entityType.getName());
                return new ResourceEntityParameter(type, this.env.getTypeUtils().getDeclaredType(type, new TypeMirror[0]), this.context.getContext().getProcessingEnvironment());
            }
        }
        catch (MirroredTypeException e) {
            DecoratedTypeMirror typeMirror = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)e.getTypeMirror(), (DecoratedProcessingEnvironment)this.context.getContext().getProcessingEnvironment());
            if (typeMirror.isDeclared()) {
                if (typeMirror.isInstanceOf(ResourceMethodSignature.class.getName() + ".NONE")) {
                    return null;
                }
                return new ResourceEntityParameter(((DeclaredType)typeMirror).asElement(), (TypeMirror)typeMirror, this.context.getContext().getProcessingEnvironment());
            }
            throw new EnunciateException(this.toString() + ": Illegal input type (must be a declared type): " + typeMirror);
        }
        return null;
    }

    @Override
    public EnunciateJaxrsContext getContext() {
        return this.context;
    }

    public Set<String> getHttpMethods() {
        return this.httpMethods;
    }

    @Override
    public List<PathSegment> getPathComponents() {
        ArrayList<PathSegment> components = new ArrayList<PathSegment>();
        Resource parent = this.getParent();
        if (parent != null) {
            components.addAll(parent.getPathComponents());
        }
        components.addAll(this.pathComponents);
        return components;
    }

    public String getFullpath() {
        StringBuilder builder = new StringBuilder();
        for (PathSegment component : this.getPathComponents()) {
            builder.append('/').append(component.getValue());
        }
        return builder.toString();
    }

    public String getServletPattern() {
        StringBuilder builder = new StringBuilder();
        String fullPath = this.getFullpath();
        Matcher pathParamMatcher = CONTEXT_PARAM_PATTERN.matcher(fullPath);
        if (pathParamMatcher.find()) {
            builder.append(fullPath, 0, pathParamMatcher.start()).append("*");
        } else {
            builder.append(fullPath);
        }
        return builder.toString();
    }

    public String getSubpath() {
        return this.subpath;
    }

    public String getLabel() {
        return this.label;
    }

    public String getSlug() {
        String slug = "";
        Resource parent = this.parent;
        while (parent instanceof SubResource) {
            slug = parent.getSimpleName() + "_" + slug;
            parent = parent.getParent();
        }
        slug = slug + this.getSimpleName();
        return slug;
    }

    public String getCustomParameterName() {
        return this.customParameterName;
    }

    public Resource getParent() {
        return this.parent;
    }

    public Set<MediaType> getConsumesMediaTypes() {
        return this.consumesMediaTypes;
    }

    public Set<MediaType> getProducesMediaTypes() {
        return this.producesMediaTypes;
    }

    public Set<ResourceParameter> getResourceParameters() {
        TreeSet<ResourceParameter> resourceParams = new TreeSet<ResourceParameter>(this.resourceParameters);
        resourceParams.addAll(this.getParent().getResourceParameters());
        return resourceParams;
    }

    public ResourceEntityParameter getEntityParameter() {
        return this.entityParameter;
    }

    public ResourceRepresentationMetadata getRepresentationMetadata() {
        return this.representationMetadata;
    }

    public List<? extends ResponseCode> getStatusCodes() {
        return this.statusCodes;
    }

    public List<? extends ResponseCode> getWarnings() {
        return this.warnings;
    }

    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(this.metaData);
    }

    public void putMetaData(String name, Object data) {
        this.metaData.put(name, data);
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Set<Facet> getFacets() {
        return this.facets;
    }

    public Set<String> getSecurityRoles() {
        Resource parent;
        TreeSet<String> roles = new TreeSet<String>();
        RolesAllowed rolesAllowed = (RolesAllowed)this.getAnnotation(RolesAllowed.class);
        if (rolesAllowed != null) {
            Collections.addAll(roles, rolesAllowed.value());
        }
        if ((parent = this.getParent()) != null) {
            roles.addAll(parent.getSecurityRoles());
        }
        return roles;
    }
}

