/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs;

import com.webcohesion.enunciate.Enunciate;
import com.webcohesion.enunciate.artifacts.BaseArtifact;
import com.webcohesion.enunciate.modules.jaxrs.EnunciateJaxrsContext;
import com.webcohesion.enunciate.modules.jaxrs.model.RootResource;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;

public class JaxrsRootResourceClassListArtifact
extends BaseArtifact {
    private final EnunciateJaxrsContext jaxrsContext;
    private final Date created = new Date();

    public JaxrsRootResourceClassListArtifact(EnunciateJaxrsContext jaxrsContext) {
        super("jaxrs", "jaxrs-resource-classes.list");
        this.jaxrsContext = jaxrsContext;
        this.setBelongsOnServerSideClasspath(true);
    }

    public String getName() {
        return "jaxrs-resource-classes.list";
    }

    public String getDescription() {
        return "A plain text file that contains the list of all JAX-RS root resources in the current project.";
    }

    public boolean isPublic() {
        return false;
    }

    public Date getCreated() {
        return this.created;
    }

    public void exportTo(File fileOrDirectory, Enunciate enunciate) throws IOException {
        FileWriter out = new FileWriter(fileOrDirectory.isDirectory() ? new File(fileOrDirectory, this.getName()) : fileOrDirectory);
        HashSet<String> written = new HashSet<String>();
        for (RootResource resource : this.jaxrsContext.getRootResources()) {
            if (!written.add(resource.getQualifiedName().toString())) continue;
            out.write(resource.getQualifiedName() + "\n");
        }
        out.flush();
        out.close();
    }

    public long getSize() {
        return -1L;
    }
}

