/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb.api.impl;

import com.webcohesion.enunciate.api.datatype.BaseType;
import com.webcohesion.enunciate.api.datatype.DataType;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.datatype.Example;
import com.webcohesion.enunciate.modules.jaxb.api.impl.ComplexDataTypeImpl;
import com.webcohesion.enunciate.modules.jaxb.api.impl.DataTypeImpl;
import com.webcohesion.enunciate.modules.jaxb.api.impl.EnumDataTypeImpl;
import com.webcohesion.enunciate.modules.jaxb.api.impl.ExampleImpl;
import com.webcohesion.enunciate.modules.jaxb.model.ComplexTypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.ElementDeclaration;
import com.webcohesion.enunciate.modules.jaxb.model.EnumTypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.types.KnownXmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlClassType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlType;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Element;
import javax.xml.namespace.QName;

public class DataTypeReferenceImpl
implements DataTypeReference {
    private final XmlType xmlType;
    private final String label;
    private final String slug;
    private final List<DataTypeReference.ContainerType> containers;
    private final DataType dataType;
    private final QName elementQName;

    public DataTypeReferenceImpl(XmlType xmlType, boolean list) {
        DataTypeImpl dataType = null;
        QName elementQName = null;
        if (xmlType instanceof XmlClassType) {
            TypeDefinition typeDef = ((XmlClassType)xmlType).getTypeDefinition();
            if (typeDef instanceof ComplexTypeDefinition) {
                dataType = new ComplexDataTypeImpl((ComplexTypeDefinition)typeDef);
            } else if (typeDef instanceof EnumTypeDefinition) {
                dataType = new EnumDataTypeImpl((EnumTypeDefinition)typeDef);
            }
            ElementDeclaration elementDecl = typeDef.getContext().findElementDeclaration((Element)((Object)typeDef));
            if (elementDecl != null) {
                elementQName = elementDecl.getQname();
            }
        }
        this.xmlType = xmlType;
        this.label = dataType == null ? xmlType.getName() : dataType.getLabel();
        this.slug = dataType == null ? null : dataType.getSlug();
        this.containers = list ? Arrays.asList(DataTypeReference.ContainerType.list) : null;
        this.dataType = dataType;
        this.elementQName = elementQName;
    }

    public XmlType getXmlType() {
        return this.xmlType;
    }

    public BaseType getBaseType() {
        QName qname = this.getXmlType().getQname();
        if (KnownXmlType.BOOLEAN.getQname().equals(qname)) {
            return BaseType.bool;
        }
        if (KnownXmlType.BYTE.getQname().equals(qname)) {
            return BaseType.number;
        }
        if (KnownXmlType.DECIMAL.getQname().equals(qname)) {
            return BaseType.number;
        }
        if (KnownXmlType.DOUBLE.getQname().equals(qname)) {
            return BaseType.number;
        }
        if (KnownXmlType.FLOAT.getQname().equals(qname)) {
            return BaseType.number;
        }
        if (KnownXmlType.INT.getQname().equals(qname)) {
            return BaseType.number;
        }
        if (KnownXmlType.INTEGER.getQname().equals(qname)) {
            return BaseType.number;
        }
        if (KnownXmlType.LONG.getQname().equals(qname)) {
            return BaseType.number;
        }
        if (KnownXmlType.NEGATIVE_INTEGER.getQname().equals(qname)) {
            return BaseType.number;
        }
        if (KnownXmlType.NONNEGATIVE_INTEGER.getQname().equals(qname)) {
            return BaseType.number;
        }
        if (KnownXmlType.NONPOSITIVE_INTEGER.getQname().equals(qname)) {
            return BaseType.number;
        }
        if (KnownXmlType.POSITIVE_INTEGER.getQname().equals(qname)) {
            return BaseType.number;
        }
        if (KnownXmlType.SHORT.getQname().equals(qname)) {
            return BaseType.number;
        }
        if (KnownXmlType.UNSIGNED_BYTE.getQname().equals(qname)) {
            return BaseType.number;
        }
        if (KnownXmlType.UNSIGNED_INT.getQname().equals(qname)) {
            return BaseType.number;
        }
        if (KnownXmlType.UNSIGNED_LONG.getQname().equals(qname)) {
            return BaseType.number;
        }
        if (KnownXmlType.UNSIGNED_SHORT.getQname().equals(qname)) {
            return BaseType.number;
        }
        return this.xmlType.isSimple() ? BaseType.string : BaseType.object;
    }

    public String getLabel() {
        return this.label;
    }

    public String getSlug() {
        return this.slug;
    }

    public List<DataTypeReference.ContainerType> getContainers() {
        return this.containers;
    }

    public DataType getValue() {
        return this.dataType;
    }

    public QName getElementQName() {
        return this.elementQName;
    }

    public Example getExample() {
        ExampleImpl example = null;
        if (this.dataType instanceof ComplexDataTypeImpl) {
            ComplexTypeDefinition typeDefinition = ((ComplexDataTypeImpl)this.dataType).typeDefinition;
            example = typeDefinition == null || typeDefinition.getContext().isDisableExamples() ? null : new ExampleImpl(typeDefinition, this.containers);
        }
        return example;
    }
}

