/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.javac.javadoc;

import com.webcohesion.enunciate.javac.javadoc.JavaDocTagHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaDoc
extends HashMap<String, JavaDocTagList> {
    public static final Pattern INLINE_TAG_PATTERN = Pattern.compile("\\{@([^\\} ]+) ?(.*?)\\}");
    public static final char[] WHITESPACE_CHARS = new char[]{' ', '\t', '\n', '\u000b', '\f', '\r'};
    protected String value;

    public JavaDoc(String docComment, JavaDocTagHandler tagHandler) {
        this.init(docComment, tagHandler);
    }

    protected void init(String docComment, JavaDocTagHandler tagHandler) {
        if (docComment == null) {
            this.value = "";
        } else {
            BufferedReader reader = new BufferedReader(new StringReader(docComment));
            StringWriter currentValue = new StringWriter();
            PrintWriter out = new PrintWriter(currentValue);
            String currentTag = null;
            boolean preformatting = false;
            try {
                String line = reader.readLine();
                while (line != null) {
                    if (!preformatting) {
                        line = line.trim();
                    }
                    if (line.startsWith("@")) {
                        this.pushValue(currentTag, currentValue.toString());
                        int spaceIndex = JavaDoc.indexOfFirstWhitespace(line);
                        currentTag = line.substring(1, spaceIndex);
                        String value = "";
                        if (spaceIndex + 1 < line.length()) {
                            value = line.substring(spaceIndex + 1);
                        }
                        currentValue = new StringWriter();
                        out = new PrintWriter(currentValue);
                        out.println(value);
                    } else {
                        out.println(line);
                    }
                    preformatting = (line.contains("<pre") || preformatting) && !line.contains("</pre");
                    line = reader.readLine();
                }
                this.pushValue(currentTag, currentValue.toString());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.doTagHandling(tagHandler)) {
            this.value = this.handleAllTags(this.value, tagHandler);
            for (Map.Entry entry : this.entrySet()) {
                JavaDocTagList tagValues = (JavaDocTagList)entry.getValue();
                for (int i = 0; i < tagValues.size(); ++i) {
                    String value = (String)tagValues.get(i);
                    tagValues.set(i, this.handleAllTags(value, tagHandler));
                }
            }
        }
    }

    public static int indexOfFirstWhitespace(String line) {
        int result = line.length();
        for (char ws : WHITESPACE_CHARS) {
            int spaceIndex = line.indexOf(ws);
            spaceIndex = spaceIndex == -1 ? result : spaceIndex;
            result = Math.min(spaceIndex, result);
        }
        return result;
    }

    protected boolean doTagHandling(JavaDocTagHandler tagHandler) {
        return tagHandler != null;
    }

    protected String handleAllTags(String value, JavaDocTagHandler handler) {
        StringBuilder builder = new StringBuilder();
        Matcher matcher = INLINE_TAG_PATTERN.matcher(value);
        int lastStart = 0;
        while (matcher.find()) {
            builder.append(value.substring(lastStart, matcher.start()));
            Object replacement = handler.onInlineTag(matcher.group(1), matcher.group(2));
            if (replacement != null) {
                if (replacement instanceof JavaDocTagHandler.TextToBeHandled) {
                    replacement = this.handleAllTags(String.valueOf(replacement), handler);
                }
                builder.append(replacement);
            } else {
                builder.append(value.substring(matcher.start(), matcher.end()));
            }
            lastStart = matcher.end();
        }
        builder.append(value.substring(lastStart, value.length()));
        return builder.toString();
    }

    private void pushValue(String tag, String value) {
        value = value.trim();
        if (tag == null) {
            this.value = value;
        } else {
            JavaDocTagList tagList = (JavaDocTagList)this.get(tag);
            if (tagList == null) {
                tagList = new JavaDocTagList(value);
                this.put(tag, tagList);
            } else {
                tagList.add(value);
            }
        }
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    public static class JavaDocTagList
    extends ArrayList<String> {
        public JavaDocTagList(String firstValue) {
            this.add(firstValue);
        }

        @Override
        public String toString() {
            return (String)this.get(0);
        }
    }
}

