/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.javac.decorations.type;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public class TypeVariableContext {
    private final TypeVariableContext stack;
    private final List<? extends TypeParameterElement> params;
    private final List<? extends TypeMirror> variables;

    public TypeVariableContext() {
        this(null, new ArrayList(), new ArrayList());
    }

    private TypeVariableContext(TypeVariableContext stack, List<? extends TypeParameterElement> params, List<? extends TypeMirror> variables) {
        this.stack = stack;
        this.params = params;
        this.variables = variables;
    }

    public TypeVariableContext push(List<? extends TypeParameterElement> params, List<? extends TypeMirror> variables) {
        return new TypeVariableContext(this, params, variables);
    }

    public TypeMirror resolveTypeVariables(TypeMirror var, ProcessingEnvironment env) {
        TypeMirror resolved = this.resolveTypeVariable(var);
        if (resolved.getKind() == TypeKind.DECLARED) {
            List<? extends TypeMirror> args = ((DeclaredType)resolved).getTypeArguments();
            TypeMirror[] resolvedArgs = new TypeMirror[args.size()];
            for (int i = 0; i < args.size(); ++i) {
                resolvedArgs[i] = this.resolveTypeVariables(args.get(i), env);
            }
            resolved = env.getTypeUtils().getDeclaredType((TypeElement)((DeclaredType)resolved).asElement(), resolvedArgs);
        }
        return resolved;
    }

    public TypeMirror resolveTypeVariable(TypeMirror typeVariable) {
        if (typeVariable.getKind() == TypeKind.TYPEVAR) {
            int argIndex = -1;
            Name name = ((TypeVariable)typeVariable).asElement().getSimpleName();
            for (int i = 0; i < this.params.size(); ++i) {
                TypeParameterElement elementParam = this.params.get(i);
                if (!elementParam.getSimpleName().equals(name)) continue;
                argIndex = i;
                break;
            }
            typeVariable = argIndex < 0 || this.variables.size() != this.params.size() ? ((TypeVariable)typeVariable).getUpperBound() : this.variables.get(argIndex);
        }
        if (typeVariable.getKind() == TypeKind.TYPEVAR) {
            typeVariable = this.stack == null ? ((TypeVariable)typeVariable).getUpperBound() : this.stack.resolveTypeVariable(typeVariable);
        }
        return typeVariable;
    }
}

