/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.javac.decorations.type;

import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedDeclaredType;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import java.util.Collection;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public class TypeMirrorUtils {
    private static final String OBJECT_TYPE_PROPERTY = "com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils#OBJECT_TYPE_PROPERTY";
    private static final String COLLECTION_TYPE_PROPERTY = "com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils#COLLECTION_TYPE_PROPERTY";
    private static final String COLLECTION_TYPE_ERASURE_PROPERTY = "com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils#COLLECTION_TYPE_ERASURE_PROPERTY";
    private static final String LIST_TYPE_PROPERTY = "com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils#LIST_TYPE_PROPERTY";
    private static final String LIST_TYPE_ERASURE_PROPERTY = "com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils#LIST_TYPE_ERASURE_PROPERTY";

    private TypeMirrorUtils() {
    }

    public static DecoratedTypeMirror mirrorOf(Class<?> clazz, ProcessingEnvironment env) {
        if (clazz.isArray()) {
            return (DecoratedTypeMirror)((Object)env.getTypeUtils().getArrayType(TypeMirrorUtils.mirrorOf(clazz.getComponentType(), env)));
        }
        if (clazz.isPrimitive()) {
            return (DecoratedTypeMirror)((Object)env.getTypeUtils().getPrimitiveType(TypeKind.valueOf(clazz.getName().toUpperCase())));
        }
        TypeElement element = env.getElementUtils().getTypeElement(clazz.getCanonicalName());
        if (element == null) {
            throw new IllegalStateException("Unable to find mirror for " + clazz.getCanonicalName());
        }
        return (DecoratedTypeMirror)element.asType();
    }

    public static DecoratedTypeMirror mirrorOf(String typeName, DecoratedProcessingEnvironment env) {
        return TypeMirrorUtils.mirrorOf(typeName, env, false);
    }

    public static DecoratedDeclaredType objectType(DecoratedProcessingEnvironment env) {
        DecoratedDeclaredType objectType = (DecoratedDeclaredType)env.getProperty(OBJECT_TYPE_PROPERTY);
        if (objectType == null) {
            objectType = (DecoratedDeclaredType)env.getElementUtils().getTypeElement(Object.class.getName()).asType();
            env.setProperty(OBJECT_TYPE_PROPERTY, objectType);
        }
        return objectType;
    }

    public static DecoratedDeclaredType collectionType(DecoratedProcessingEnvironment env) {
        DecoratedDeclaredType collectionType = (DecoratedDeclaredType)env.getProperty(COLLECTION_TYPE_PROPERTY);
        if (collectionType == null) {
            collectionType = (DecoratedDeclaredType)env.getElementUtils().getTypeElement(Collection.class.getName()).asType();
            env.setProperty(COLLECTION_TYPE_PROPERTY, collectionType);
        }
        return collectionType;
    }

    public static DecoratedDeclaredType collectionTypeErasure(DecoratedProcessingEnvironment env) {
        DecoratedDeclaredType collectionType = (DecoratedDeclaredType)env.getProperty(COLLECTION_TYPE_ERASURE_PROPERTY);
        if (collectionType == null) {
            collectionType = (DecoratedDeclaredType)env.getTypeUtils().erasure(TypeMirrorUtils.collectionType(env));
            env.setProperty(COLLECTION_TYPE_PROPERTY, collectionType);
        }
        return collectionType;
    }

    public static DecoratedDeclaredType listType(DecoratedProcessingEnvironment env) {
        DecoratedDeclaredType listType = (DecoratedDeclaredType)env.getProperty(LIST_TYPE_PROPERTY);
        if (listType == null) {
            listType = (DecoratedDeclaredType)env.getTypeUtils().erasure(env.getElementUtils().getTypeElement(List.class.getName()).asType());
            env.setProperty(LIST_TYPE_PROPERTY, listType);
        }
        return listType;
    }

    public static DecoratedDeclaredType listTypeErasure(DecoratedProcessingEnvironment env) {
        DecoratedDeclaredType listType = (DecoratedDeclaredType)env.getProperty(LIST_TYPE_ERASURE_PROPERTY);
        if (listType == null) {
            listType = (DecoratedDeclaredType)env.getTypeUtils().erasure(TypeMirrorUtils.listType(env));
            env.setProperty(LIST_TYPE_PROPERTY, listType);
        }
        return listType;
    }

    public static TypeMirror resolveTypeVariable(TypeMirror typeVariable, List<? extends TypeParameterElement> elementParams, List<? extends TypeMirror> elementArgs) {
        if (typeVariable.getKind() == TypeKind.TYPEVAR) {
            int argIndex = -1;
            Name name = ((TypeVariable)typeVariable).asElement().getSimpleName();
            for (int i = 0; i < elementParams.size(); ++i) {
                TypeParameterElement elementParam = elementParams.get(i);
                if (!elementParam.getSimpleName().equals(name)) continue;
                argIndex = i;
                break;
            }
            typeVariable = argIndex < 0 || elementArgs.size() != elementParams.size() ? ((TypeVariable)typeVariable).getUpperBound() : elementArgs.get(argIndex);
        }
        return typeVariable;
    }

    private static DecoratedTypeMirror mirrorOf(String typeName, DecoratedProcessingEnvironment env, boolean inArray) {
        block19: {
            DecoratedTypeMirror cached = (DecoratedTypeMirror)env.getProperty(TypeMirrorUtils.mirrorKey(typeName));
            if (cached != null) {
                return cached;
            }
            if (typeName.startsWith("[")) {
                return (DecoratedTypeMirror)((Object)env.getTypeUtils().getArrayType(TypeMirrorUtils.mirrorOf(typeName.substring(1), env, true)));
            }
            if (typeName.endsWith("[]")) {
                return (DecoratedTypeMirror)((Object)env.getTypeUtils().getArrayType(TypeMirrorUtils.mirrorOf(typeName.substring(0, typeName.length() - 2), env, false)));
            }
            if (inArray) {
                char firstChar = typeName.charAt(0);
                if (firstChar == 'L' && typeName.endsWith(";")) {
                    return TypeMirrorUtils.mirrorOf(typeName.substring(1, typeName.length() - 2), env, false);
                }
                switch (firstChar) {
                    case 'Z': {
                        return (DecoratedTypeMirror)((Object)env.getTypeUtils().getPrimitiveType(TypeKind.BOOLEAN));
                    }
                    case 'B': {
                        return (DecoratedTypeMirror)((Object)env.getTypeUtils().getPrimitiveType(TypeKind.BYTE));
                    }
                    case 'C': {
                        return (DecoratedTypeMirror)((Object)env.getTypeUtils().getPrimitiveType(TypeKind.CHAR));
                    }
                    case 'D': {
                        return (DecoratedTypeMirror)((Object)env.getTypeUtils().getPrimitiveType(TypeKind.DOUBLE));
                    }
                    case 'F': {
                        return (DecoratedTypeMirror)((Object)env.getTypeUtils().getPrimitiveType(TypeKind.FLOAT));
                    }
                    case 'I': {
                        return (DecoratedTypeMirror)((Object)env.getTypeUtils().getPrimitiveType(TypeKind.INT));
                    }
                    case 'L': {
                        return (DecoratedTypeMirror)((Object)env.getTypeUtils().getPrimitiveType(TypeKind.LONG));
                    }
                    case 'S': {
                        return (DecoratedTypeMirror)((Object)env.getTypeUtils().getPrimitiveType(TypeKind.SHORT));
                    }
                }
            } else {
                try {
                    TypeKind kind = TypeKind.valueOf(typeName.toUpperCase());
                    if (kind.isPrimitive()) {
                        return (DecoratedTypeMirror)((Object)env.getTypeUtils().getPrimitiveType(kind));
                    }
                }
                catch (IllegalArgumentException e) {
                    TypeElement element = env.getElementUtils().getTypeElement(typeName);
                    if (element == null) break block19;
                    return (DecoratedTypeMirror)((Object)env.getTypeUtils().getDeclaredType(element, new TypeMirror[0]));
                }
            }
        }
        return null;
    }

    private static String mirrorKey(String typeName) {
        return "com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils#MIRROR_OF_" + typeName;
    }

    public static DecoratedTypeMirror getComponentType(DecoratedTypeMirror typeMirror, DecoratedProcessingEnvironment env) {
        if (typeMirror.isCollection()) {
            List<? extends TypeMirror> itemTypes = ((DeclaredType)((Object)typeMirror)).getTypeArguments();
            if (itemTypes.isEmpty()) {
                return TypeMirrorUtils.objectType(env);
            }
            return (DecoratedTypeMirror)itemTypes.get(0);
        }
        if (typeMirror instanceof ArrayType) {
            return (DecoratedTypeMirror)((ArrayType)((Object)typeMirror)).getComponentType();
        }
        return null;
    }
}

