/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.javac.decorations.element;

import com.webcohesion.enunciate.javac.decorations.AnnotationMirrorDecoration;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;

public class DecoratedAnnotationMirror
implements AnnotationMirror {
    private final AnnotationMirror delegate;
    private final ProcessingEnvironment env;

    public DecoratedAnnotationMirror(AnnotationMirror delegate, DecoratedProcessingEnvironment env) {
        if (delegate == null) {
            throw new NullPointerException("A delegate must be provided.");
        }
        if (env == null) {
            throw new NullPointerException("A processing environment must be provided.");
        }
        while (delegate instanceof DecoratedAnnotationMirror) {
            delegate = ((DecoratedAnnotationMirror)delegate).delegate;
        }
        this.delegate = delegate;
        this.env = env;
        if (env.getAnnotationMirrorDecorations() != null) {
            for (AnnotationMirrorDecoration decoration : env.getAnnotationMirrorDecorations()) {
                decoration.applyTo(this);
            }
        }
    }

    @Override
    public DeclaredType getAnnotationType() {
        return this.delegate.getAnnotationType();
    }

    @Override
    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValues() {
        return this.delegate.getElementValues();
    }

    public Map<? extends ExecutableElement, ? extends AnnotationValue> getAllElementValues() {
        return this.env.getElementUtils().getElementValuesWithDefaults(this.delegate);
    }

    public boolean equals(Object o) {
        if (o instanceof DecoratedAnnotationMirror) {
            o = ((DecoratedAnnotationMirror)o).delegate;
        }
        return this.delegate.equals(o);
    }

    public AnnotationMirror getDelegate() {
        return this.delegate;
    }
}

