/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.javac.javadoc;

import com.webcohesion.enunciate.javac.decorations.element.DecoratedExecutableElement;
import com.webcohesion.enunciate.javac.javadoc.DocComment;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.javac.javadoc.JavaDocTagHandler;
import java.util.HashMap;
import java.util.TreeMap;

public class ParamDocComment
implements DocComment {
    private final DecoratedExecutableElement executableElement;
    private final String paramName;
    private final TreeMap<String, String> values;

    public ParamDocComment(DecoratedExecutableElement executableElement, String paramName) {
        this.executableElement = executableElement;
        this.paramName = paramName;
        this.values = new TreeMap();
    }

    @Override
    public String get(JavaDocTagHandler tagHandler) {
        String value = this.values.get(tagHandler.getTypeId());
        if (value == null) {
            JavaDoc javaDoc = this.executableElement.getJavaDoc(tagHandler);
            HashMap<String, String> paramsComments = this.loadParamsComments(javaDoc);
            String comment = paramsComments.get(this.paramName);
            value = comment != null ? comment : "";
            this.values.put(tagHandler.getTypeId(), value);
        }
        return value;
    }

    protected HashMap<String, String> loadParamsComments(JavaDoc javaDoc) {
        return this.loadParamsComments("param", javaDoc);
    }

    protected HashMap<String, String> loadParamsComments(String tagName, JavaDoc jd) {
        HashMap<String, String> paramComments = new HashMap<String, String>();
        if (jd.get(tagName) != null) {
            for (String paramDoc : (JavaDoc.JavaDocTagList)jd.get(tagName)) {
                paramDoc = paramDoc.trim().replaceFirst("\\s+", " ");
                int spaceIndex = JavaDoc.indexOfFirstWhitespace(paramDoc);
                String param = paramDoc.substring(0, spaceIndex);
                String paramComment = "";
                if (spaceIndex + 1 < paramDoc.length()) {
                    paramComment = paramDoc.substring(spaceIndex + 1);
                }
                paramComments.put(param, paramComment);
            }
        }
        return paramComments;
    }
}

