/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.javac.javadoc;

import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.javadoc.JavaDocTagHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class JavaDoc
extends HashMap<String, JavaDocTagList> {
    public static final JavaDoc EMPTY = new JavaDoc("");
    private static final Pattern INLINE_TAG_PATTERN = Pattern.compile("\\{@([^\\} ]+) ?(.*?)\\}");
    private static final Pattern INHERITDOC_PATTERN = Pattern.compile("\\{@inheritDoc(.*?)\\}");
    private static final char[] WHITESPACE_CHARS = new char[]{' ', '\t', '\n', '\u000b', '\f', '\r'};
    private static final int FIRST_WHITESPACE = 9;
    private static final int WHITESPACE_BITS = 8388639;
    protected String value;

    static boolean isWhitespace(char ch) {
        return ch <= ' ' && ch >= '\t' && (0x80001F & 1 << ch - 9) != 0;
    }

    private JavaDoc(String value) {
        this.value = value;
    }

    public JavaDoc(String docComment, JavaDocTagHandler tagHandler, DecoratedElement context, DecoratedProcessingEnvironment env) {
        this.init(docComment, tagHandler, context, env);
    }

    public static JavaDoc createStaticJavaDoc(String value) {
        return new JavaDoc(value);
    }

    protected void init(String docComment, JavaDocTagHandler tagHandler, DecoratedElement context, DecoratedProcessingEnvironment env) {
        if (docComment == null) {
            this.value = "";
        } else {
            BufferedReader reader = new BufferedReader(new StringReader(docComment));
            StringWriter currentValue = new StringWriter();
            PrintWriter out = new PrintWriter(currentValue);
            String currentTag = null;
            boolean preformatting = false;
            try {
                String line = reader.readLine();
                while (line != null) {
                    if (!preformatting) {
                        line = line.trim();
                    }
                    if (line.startsWith("@")) {
                        this.pushValue(currentTag, currentValue.toString());
                        int spaceIndex = JavaDoc.indexOfFirstWhitespace(line);
                        currentTag = line.substring(1, spaceIndex);
                        String value = "";
                        if (spaceIndex + 1 < line.length()) {
                            value = line.substring(spaceIndex + 1);
                        }
                        currentValue = new StringWriter();
                        out = new PrintWriter(currentValue);
                        out.println(value);
                    } else {
                        out.println(line);
                    }
                    preformatting = (line.contains("<pre") || preformatting) && !line.contains("</pre");
                    line = reader.readLine();
                }
                this.pushValue(currentTag, currentValue.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.assumeInheritedComments(context, env, tagHandler);
        if (tagHandler != null) {
            this.value = this.resolveJavaDocSemantics(null, this.value, tagHandler, context);
            for (Map.Entry entry : this.entrySet()) {
                JavaDocTagList tagValues = (JavaDocTagList)entry.getValue();
                for (int i = 0; i < tagValues.size(); ++i) {
                    String value = (String)tagValues.get(i);
                    tagValues.set(i, this.resolveJavaDocSemantics((String)entry.getKey(), value, tagHandler, context));
                }
            }
        }
    }

    public static int indexOfFirstWhitespace(String line) {
        int result = line.length();
        for (char ws : WHITESPACE_CHARS) {
            int spaceIndex = line.indexOf(ws);
            spaceIndex = spaceIndex == -1 ? result : spaceIndex;
            result = Math.min(spaceIndex, result);
        }
        return result;
    }

    private String resolveJavaDocSemantics(String section, String value, JavaDocTagHandler handler, DecoratedElement context) {
        StringBuilder builder = new StringBuilder();
        Matcher matcher = INLINE_TAG_PATTERN.matcher(value);
        int lastStart = 0;
        while (matcher.find()) {
            builder.append(value.substring(lastStart, matcher.start()));
            String replacement = handler.onInlineTag(matcher.group(1), matcher.group(2), context);
            if (replacement != null) {
                builder.append(replacement);
            } else {
                builder.append(value.substring(matcher.start(), matcher.end()));
            }
            lastStart = matcher.end();
        }
        builder.append(value.substring(lastStart, value.length()));
        return handler.onBlockTag(section, builder.toString(), context);
    }

    private void pushValue(String tag, String value) {
        value = value.trim();
        if (tag == null) {
            this.value = value;
        } else {
            JavaDocTagList tagList = (JavaDocTagList)this.get(tag);
            if (tagList == null) {
                tagList = new JavaDocTagList(value);
                this.put(tag, tagList);
            } else {
                tagList.add(value);
            }
        }
    }

    private void assumeInheritedComments(DecoratedElement context, DecoratedProcessingEnvironment env, JavaDocTagHandler tagHandler) {
        if (context instanceof TypeElement) {
            this.assumeInheritedTypeComments((TypeElement)((Object)context), tagHandler);
        } else if (context instanceof ExecutableElement) {
            this.assumeInheritedExecutableComments((ExecutableElement)((Object)context), env, tagHandler);
        }
    }

    private void assumeInheritedExecutableComments(ExecutableElement context, DecoratedProcessingEnvironment env, JavaDocTagHandler tagHandler) {
        if (this.assumeInheritedExecutableComments(context, EMPTY)) {
            return;
        }
        Element el = context.getEnclosingElement();
        if (el instanceof TypeElement) {
            Element superType;
            TypeElement typeElement = (TypeElement)el;
            ArrayList<TypeMirror> interfaces = new ArrayList<TypeMirror>();
            this.aggregateInterfaces(interfaces, typeElement);
            for (TypeMirror iface : interfaces) {
                Element superType2 = iface instanceof DeclaredType ? ((DeclaredType)iface).asElement() : null;
                if (superType2 == null) continue;
                List<ExecutableElement> methods = ElementFilter.methodsIn(superType2.getEnclosedElements());
                for (ExecutableElement candidate : methods) {
                    JavaDoc inheritedDocs;
                    if (!env.getElementUtils().overrides(context, candidate, typeElement) || !(candidate instanceof DecoratedElement) || !this.assumeInheritedExecutableComments(context, inheritedDocs = ((DecoratedElement)((Object)candidate)).getJavaDoc(tagHandler))) continue;
                    return;
                }
            }
            TypeMirror superclass = typeElement.getSuperclass();
            if (superclass != null && superclass instanceof DeclaredType && (superType = ((DeclaredType)superclass).asElement()) != null) {
                List<ExecutableElement> methods = ElementFilter.methodsIn(superType.getEnclosedElements());
                for (ExecutableElement candidate : methods) {
                    if (!env.getElementUtils().overrides(context, candidate, typeElement) || !(candidate instanceof DecoratedElement)) continue;
                    JavaDoc inheritedDocs = ((DecoratedElement)((Object)candidate)).getJavaDoc(tagHandler);
                    this.assumeInheritedExecutableComments(context, inheritedDocs);
                    return;
                }
            }
        }
    }

    private void aggregateInterfaces(List<TypeMirror> interfaces, TypeElement typeElement) {
        List<? extends TypeMirror> ifaces = typeElement.getInterfaces();
        if (!ifaces.isEmpty()) {
            interfaces.addAll(ifaces);
            for (TypeMirror typeMirror : ifaces) {
                Element element;
                if (!(typeMirror instanceof DeclaredType) || !((element = ((DeclaredType)typeMirror).asElement()) instanceof TypeElement)) continue;
                this.aggregateInterfaces(interfaces, (TypeElement)element);
            }
        }
    }

    private boolean assumeInheritedExecutableComments(ExecutableElement context, JavaDoc inherited) {
        List<? extends VariableElement> parameterNames;
        boolean assumed = true;
        if (this.valueInherits(this.value)) {
            String inheritedValue = inherited.toString();
            if (!inheritedValue.isEmpty()) {
                this.value = this.value.isEmpty() ? inheritedValue : INHERITDOC_PATTERN.matcher(this.value).replaceAll(inheritedValue);
            } else {
                assumed = false;
            }
        }
        if (context.getReturnType() != null && context.getReturnType().getKind() != TypeKind.VOID) {
            String returnValue;
            JavaDocTagList returnTag = (JavaDocTagList)this.get("return");
            String string = returnValue = returnTag == null ? "" : returnTag.toString();
            if (this.valueInherits(returnValue)) {
                String string2;
                JavaDocTagList inheritedTag = (JavaDocTagList)inherited.get("return");
                String string3 = string2 = inheritedTag == null ? "" : inheritedTag.toString();
                if (!string2.isEmpty()) {
                    if (returnValue.isEmpty()) {
                        this.put("return", new JavaDocTagList(string2));
                    } else {
                        returnValue = INHERITDOC_PATTERN.matcher(returnValue).replaceAll(string2);
                        this.put("return", new JavaDocTagList(returnValue));
                    }
                } else {
                    assumed = false;
                }
            }
        }
        if ((parameterNames = context.getParameters()) != null && !parameterNames.isEmpty()) {
            JavaDocTagList paramTags = (JavaDocTagList)this.get("param");
            for (VariableElement variableElement : parameterNames) {
                String paramName = variableElement.getSimpleName().toString();
                String paramValue = "";
                int paramIndex = -1;
                if (paramTags != null) {
                    for (int i = 0; i < paramTags.size(); ++i) {
                        String paramTag = (String)paramTags.get(i);
                        if (!paramName.equals(paramTag.substring(0, JavaDoc.indexOfFirstWhitespace(paramTag)))) continue;
                        paramValue = paramTag;
                        paramIndex = i;
                        break;
                    }
                }
                if (!this.valueInherits(paramValue)) continue;
                JavaDocTagList inheritedTags = (JavaDocTagList)inherited.get("param");
                String inheritedValue = "";
                if (inheritedTags != null) {
                    for (String inheritedTag : inheritedTags) {
                        if (!paramName.equals(inheritedTag.substring(0, JavaDoc.indexOfFirstWhitespace(inheritedTag)))) continue;
                        inheritedValue = inheritedTag;
                        break;
                    }
                }
                if (!inheritedValue.isEmpty()) {
                    if (paramIndex < 0) {
                        this.pushValue("param", inheritedValue);
                        continue;
                    }
                    paramValue = INHERITDOC_PATTERN.matcher(paramValue).replaceAll(inheritedValue);
                    paramTags.set(paramIndex, paramValue);
                    continue;
                }
                assumed = false;
            }
        }
        return assumed;
    }

    private void assumeInheritedTypeComments(TypeElement e, JavaDocTagHandler tagHandler) {
        if (this.valueInherits(this.value)) {
            Element el;
            TypeMirror superclass;
            TypeMirror iface;
            Element el2;
            String inheritedValue = "";
            List<? extends TypeMirror> interfaces = e.getInterfaces();
            Iterator<? extends TypeMirror> iterator = interfaces.iterator();
            while (iterator.hasNext() && (!((el2 = (iface = iterator.next()) instanceof DeclaredType ? ((DeclaredType)iface).asElement() : null) instanceof DecoratedElement) || (inheritedValue = ((DecoratedElement)el2).getJavaDoc(tagHandler).toString()).isEmpty())) {
            }
            if (inheritedValue.isEmpty() && (superclass = e.getSuperclass()) instanceof DeclaredType && (el = ((DeclaredType)superclass).asElement()) instanceof DecoratedElement) {
                inheritedValue = ((DecoratedElement)el).getJavaDoc().toString();
            }
            if (!inheritedValue.isEmpty()) {
                this.value = this.value.isEmpty() ? inheritedValue : INHERITDOC_PATTERN.matcher(this.value).replaceAll(inheritedValue);
            }
        }
    }

    private boolean valueInherits(String value) {
        return value == null || value.isEmpty() || INHERITDOC_PATTERN.matcher(value).find();
    }

    @Override
    public String toString() {
        return this.value;
    }

    public static class JavaDocTagList
    extends ArrayList<String> {
        public JavaDocTagList(String firstValue) {
            this.add(firstValue);
        }

        @Override
        public String toString() {
            return (String)this.get(0);
        }
    }
}

