/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson1.model;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.Annotations;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedExecutableElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedTypeElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.decorations.element.PropertyElement;
import com.webcohesion.enunciate.javac.decorations.element.PropertySpec;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils;
import com.webcohesion.enunciate.metadata.ClientName;
import com.webcohesion.enunciate.modules.jackson1.EnunciateJackson1Context;
import com.webcohesion.enunciate.modules.jackson1.model.Accessor;
import com.webcohesion.enunciate.modules.jackson1.model.AccessorFilter;
import com.webcohesion.enunciate.modules.jackson1.model.Member;
import com.webcohesion.enunciate.modules.jackson1.model.MemberComparator;
import com.webcohesion.enunciate.modules.jackson1.model.Value;
import com.webcohesion.enunciate.modules.jackson1.model.WildcardMember;
import com.webcohesion.enunciate.util.AccessorBag;
import com.webcohesion.enunciate.util.AnnotationUtils;
import com.webcohesion.enunciate.util.SortedList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.jackson.annotate.JsonAnyGetter;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonIgnoreType;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.codehaus.jackson.annotate.JsonSubTypes;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.annotate.JsonTypeName;
import org.codehaus.jackson.annotate.JsonUnwrapped;
import org.codehaus.jackson.annotate.JsonValue;

public abstract class TypeDefinition
extends DecoratedTypeElement
implements HasFacets {
    private final List<Member> members;
    private final Value value;
    private final WildcardMember wildcardMember;
    private final LinkedList<Element> referencedFrom = new LinkedList();
    private final Set<Facet> facets = new TreeSet<Facet>();
    protected final EnunciateJackson1Context context;
    private final String[] propOrder;
    private String typeIdProperty;

    protected TypeDefinition(TypeElement delegate, EnunciateJackson1Context context) {
        super(delegate, context.getContext().getProcessingEnvironment());
        JsonPropertyOrder propOrderInfo;
        XmlType typeInfo;
        this.context = context;
        String[] propOrder = null;
        boolean alphabetical = context.isPropertiesAlphabetical();
        if (context.isHonorJaxb() && (typeInfo = (XmlType)this.getAnnotation(XmlType.class)) != null && (propOrder = typeInfo.propOrder()).length == 1 && "".equals(propOrder[0])) {
            propOrder = null;
        }
        if ((propOrderInfo = (JsonPropertyOrder)this.getAnnotation(JsonPropertyOrder.class)) != null) {
            propOrder = propOrderInfo.value();
            alphabetical = propOrderInfo.alphabetic();
        }
        MemberComparator comparator = new MemberComparator(propOrder, alphabetical, this.env);
        SortedList memberAccessors = new SortedList((Comparator)comparator);
        Value value = null;
        WildcardMember wildcardMember = null;
        JsonIgnoreType ignoreType = (JsonIgnoreType)this.getAnnotation(JsonIgnoreType.class);
        if (ignoreType == null || !ignoreType.value()) {
            AccessorFilter filter = new AccessorFilter(context, (JsonAutoDetect)this.getAnnotation(JsonAutoDetect.class), (JsonIgnoreProperties)this.getAnnotation(JsonIgnoreProperties.class), (XmlAccessorType)this.getAnnotation(XmlAccessorType.class));
            value = null;
            wildcardMember = null;
            AccessorBag accessorBag = this.loadPotentialAccessors(filter);
            this.typeIdProperty = accessorBag.typeIdProperty;
            for (Element accessor : accessorBag.getAccessors()) {
                if (this.isValue(accessor)) {
                    if (value != null) {
                        throw new EnunciateException("Accessor " + accessor.getSimpleName() + " of " + this.getQualifiedName() + ": a type definition cannot have more than one json value.");
                    }
                    value = new Value(accessor, this, context);
                    continue;
                }
                if (this.isWildcardProperty(accessor)) {
                    wildcardMember = new WildcardMember(accessor, this, context);
                    continue;
                }
                if (accessor instanceof PropertyElement && (this.overridesAnother(((PropertyElement)accessor).getGetter(), filter) || this.overridesAnother(((PropertyElement)accessor).getSetter(), filter))) continue;
                memberAccessors.add((Object)new Member(accessor, this, context));
            }
        }
        memberAccessors.removeDuplicates(Comparator.comparing(new Function<Member, String>(){

            @Override
            public String apply(Member member) {
                return member.getName();
            }
        }));
        this.propOrder = propOrder;
        this.members = Collections.unmodifiableList(memberAccessors);
        this.value = value;
        this.wildcardMember = wildcardMember;
        if (delegate instanceof HasFacets) {
            this.facets.addAll(((HasFacets)delegate).getFacets());
        } else {
            this.facets.addAll(Facet.gatherFacets((Element)delegate, (EnunciateContext)context.getContext()));
            this.facets.addAll(Facet.gatherFacets((Element)this.env.getElementUtils().getPackageOf(delegate), (EnunciateContext)context.getContext()));
        }
    }

    protected TypeDefinition(TypeDefinition copy) {
        super((TypeElement)copy.delegate, copy.env);
        this.members = copy.members;
        this.value = copy.value;
        this.wildcardMember = copy.wildcardMember;
        this.facets.addAll(copy.facets);
        this.context = copy.context;
        this.propOrder = copy.propOrder;
        this.typeIdProperty = copy.typeIdProperty;
    }

    public EnunciateJackson1Context getContext() {
        return this.context;
    }

    protected AccessorBag loadPotentialAccessors(AccessorFilter filter) {
        if (this.getKind() == ElementKind.ENUM) {
            return new AccessorBag();
        }
        AccessorBag bag = new AccessorBag();
        this.aggregatePotentialAccessors(bag, this, filter, this.context.isCollapseTypeHierarchy());
        return bag;
    }

    protected void aggregatePotentialAccessors(AccessorBag bag, DecoratedTypeElement clazz, AccessorFilter filter, boolean inlineAccessorsOfSuperclasses) {
        DecoratedTypeElement superDeclaration;
        JsonTypeInfo info;
        String fqn = clazz.getQualifiedName().toString();
        if (Object.class.getName().equals(fqn) || Enum.class.getName().equals(fqn)) {
            return;
        }
        if (bag.typeIdProperty == null && (info = (JsonTypeInfo)this.getAnnotation(JsonTypeInfo.class)) != null && !info.property().isEmpty()) {
            bag.typeIdProperty = info.property();
        }
        DecoratedTypeElement decoratedTypeElement = superDeclaration = clazz.getSuperclass() != null ? (DecoratedTypeElement)this.env.getTypeUtils().asElement(clazz.getSuperclass()) : null;
        if (superDeclaration != null && (this.context.isIgnored((Element)superDeclaration) || inlineAccessorsOfSuperclasses)) {
            inlineAccessorsOfSuperclasses = true;
            this.aggregatePotentialAccessors(bag, superDeclaration, filter, true);
        }
        TypeElement mixin = this.context.lookupMixin((TypeElement)clazz);
        ArrayList<VariableElement> fieldElements = new ArrayList<VariableElement>(ElementFilter.fieldsIn(clazz.getEnclosedElements()));
        if (mixin != null) {
            for (VariableElement variableElement : ElementFilter.fieldsIn(mixin.getEnclosedElements())) {
                int index = this.indexOf(fieldElements, variableElement.getSimpleName().toString());
                if (index >= 0) {
                    fieldElements.set(index, variableElement);
                    continue;
                }
                fieldElements.add(variableElement);
            }
        }
        HashSet<String> propsIgnore = new HashSet<String>();
        for (VariableElement fieldDeclaration : fieldElements) {
            JsonUnwrapped unwrapped = fieldDeclaration.getAnnotation(JsonUnwrapped.class);
            if (unwrapped != null && unwrapped.enabled()) {
                TypeMirror typeMirror = fieldDeclaration.asType();
                if (!(typeMirror instanceof DeclaredType)) {
                    throw new EnunciateException(String.format("%s: %s cannot be JSON unwrapped.", fieldDeclaration, typeMirror));
                }
                this.aggregatePotentialAccessors(bag, (DecoratedTypeElement)((DeclaredType)typeMirror).asElement(), filter, inlineAccessorsOfSuperclasses);
                propsIgnore.add(fieldDeclaration.getSimpleName().toString());
                continue;
            }
            if (!filter.accept((DecoratedElement)fieldDeclaration)) {
                bag.fields.removeByName((Element)fieldDeclaration);
                continue;
            }
            bag.fields.addOrReplace((Element)fieldDeclaration);
        }
        Jackson1PropertySpec jackson1PropertySpec = new Jackson1PropertySpec(this.env);
        ArrayList<PropertyElement> propertyElements = new ArrayList<PropertyElement>(clazz.getProperties((PropertySpec)jackson1PropertySpec));
        if (mixin != null) {
            for (PropertyElement mixinProperty : ((DecoratedTypeElement)mixin).getProperties((PropertySpec)jackson1PropertySpec)) {
                int index = this.indexOf(propertyElements, mixinProperty.getSimpleName().toString());
                if (index >= 0) {
                    propertyElements.set(index, mixinProperty);
                    continue;
                }
                propertyElements.add(mixinProperty);
            }
        }
        for (PropertyElement propertyDeclaration : propertyElements) {
            JsonUnwrapped unwrapped = (JsonUnwrapped)propertyDeclaration.getAnnotation(JsonUnwrapped.class);
            if (unwrapped != null && unwrapped.enabled()) {
                DecoratedTypeElement element;
                TypeMirror typeMirror = propertyDeclaration.asType();
                switch (typeMirror.getKind()) {
                    case DECLARED: {
                        element = (DecoratedTypeElement)((DeclaredType)typeMirror).asElement();
                        break;
                    }
                    case TYPEVAR: {
                        typeMirror = ((TypeVariable)typeMirror).getUpperBound();
                        element = (DecoratedTypeElement)((DeclaredType)typeMirror).asElement();
                        break;
                    }
                    case WILDCARD: {
                        TypeMirror bound = ((WildcardType)typeMirror).getExtendsBound();
                        if (bound == null) {
                            bound = ((WildcardType)typeMirror).getSuperBound();
                        }
                        if (!(bound instanceof DeclaredType)) {
                            bound = TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)this.env);
                        }
                        element = (DecoratedTypeElement)((DeclaredType)bound).asElement();
                        break;
                    }
                    default: {
                        throw new EnunciateException(String.format("%s: %s cannot be JSON unwrapped.", propertyDeclaration, typeMirror));
                    }
                }
                this.aggregatePotentialAccessors(bag, element, filter, inlineAccessorsOfSuperclasses);
                continue;
            }
            if (!filter.accept((DecoratedElement<?>)propertyDeclaration) || this.indexOf((List<? extends Element>)bag.fields, propertyDeclaration.getSimpleName().toString()) >= 0 || propsIgnore.contains(propertyDeclaration.getSimpleName().toString())) {
                bag.properties.removeByName((Element)propertyDeclaration);
                continue;
            }
            bag.properties.addOrReplace((Element)propertyDeclaration);
        }
    }

    protected int indexOf(List<? extends Element> accessors, String name) {
        for (int i = 0; i < accessors.size(); ++i) {
            Element accessor = accessors.get(i);
            if (!accessor.getSimpleName().toString().equals(name)) continue;
            return i;
        }
        return -1;
    }

    private boolean overridesAnother(DecoratedExecutableElement method, AccessorFilter filter) {
        if (method == null) {
            return false;
        }
        if (this.context.isCollapseTypeHierarchy()) {
            return false;
        }
        TypeElement declaringType = (TypeElement)method.getEnclosingElement();
        TypeElement superType = (TypeElement)this.env.getTypeUtils().asElement(declaringType.getSuperclass());
        if (superType != null && !this.context.isIgnored(superType)) {
            while (superType != null && !Object.class.getName().equals(superType.getQualifiedName().toString())) {
                List<ExecutableElement> methods = ElementFilter.methodsIn(superType.getEnclosedElements());
                for (ExecutableElement candidate : methods) {
                    if (!this.env.getElementUtils().overrides((ExecutableElement)method, candidate, declaringType)) continue;
                    return filter.accept((DecoratedElement)candidate);
                }
                superType = (TypeElement)this.env.getTypeUtils().asElement(superType.getSuperclass());
            }
        }
        return false;
    }

    protected boolean isValue(Element declaration) {
        return declaration.getAnnotation(JsonValue.class) != null;
    }

    protected boolean isWildcardProperty(Element declaration) {
        return declaration.getAnnotation(JsonAnyGetter.class) != null;
    }

    public String getClientSimpleName() {
        String clientSimpleName = this.getSimpleName().toString();
        ClientName clientName = (ClientName)this.getAnnotation(ClientName.class);
        if (clientName != null) {
            clientSimpleName = clientName.value();
        }
        return clientSimpleName;
    }

    public WildcardMember getWildcardMember() {
        return this.wildcardMember;
    }

    public List<Member> getMembers() {
        return this.members;
    }

    public Value getValue() {
        return this.value;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    public boolean isBaseObject() {
        return true;
    }

    public LinkedList<Element> getReferencedFrom() {
        return this.referencedFrom;
    }

    public Set<Facet> getFacets() {
        return this.facets;
    }

    public boolean isHasTypeInfo() {
        return this.getAnnotation(JsonTypeInfo.class) != null;
    }

    public JsonTypeInfo.Id getTypeIdType() {
        JsonTypeInfo.Id typeIdType = JsonTypeInfo.Id.CLASS;
        JsonTypeInfo typeInfo = (JsonTypeInfo)this.getAnnotation(JsonTypeInfo.class);
        if (typeInfo != null) {
            typeIdType = typeInfo.use();
        }
        return typeIdType;
    }

    public JsonTypeInfo.As getTypeIdInclusion() {
        JsonTypeInfo.As inclusion = JsonTypeInfo.As.PROPERTY;
        JsonTypeInfo typeInfo = (JsonTypeInfo)this.getAnnotation(JsonTypeInfo.class);
        if (typeInfo != null) {
            inclusion = typeInfo.include();
        }
        return inclusion;
    }

    public String getTypeIdProperty() {
        return this.typeIdProperty;
    }

    public String getTypeIdValue() {
        JsonTypeName typeName;
        List subTypes = AnnotationUtils.getAnnotations(JsonSubTypes.class, (Element)((Object)this), (boolean)false);
        if (!subTypes.isEmpty()) {
            Types typeUtils = this.env.getTypeUtils();
            for (JsonSubTypes.Type type : ((JsonSubTypes)subTypes.get(0)).value()) {
                DecoratedTypeMirror decoratedType = Annotations.mirrorOf(() -> ((JsonSubTypes.Type)type).value(), (DecoratedProcessingEnvironment)this.env);
                if (!typeUtils.isSameType(this.asType(), decoratedType.getDelegate()) || type.name().isEmpty()) continue;
                return type.name();
            }
        }
        if ((typeName = (JsonTypeName)this.getAnnotation(JsonTypeName.class)) != null && !typeName.value().isEmpty()) {
            return typeName.value();
        }
        return this.isAbstract() ? "..." : this.getSimpleName().toString();
    }

    public String[] getPropOrder() {
        return this.propOrder;
    }

    public boolean isHasSubTypes() {
        JsonSubTypes subtypes = (JsonSubTypes)this.getAnnotation(JsonSubTypes.class);
        return subtypes != null && subtypes.value().length > 0;
    }

    public Map<String, DecoratedTypeMirror> getSubTypes() {
        TreeMap<String, DecoratedTypeMirror> subtypes = null;
        JsonSubTypes info = (JsonSubTypes)this.getAnnotation(JsonSubTypes.class);
        if (info != null) {
            subtypes = new TreeMap<String, DecoratedTypeMirror>();
            for (JsonSubTypes.Type type : info.value()) {
                JsonTypeName typeName;
                DecoratedTypeMirror t;
                TypeElement te;
                try {
                    te = this.env.getElementUtils().getTypeElement(type.value().getName());
                    t = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)te.asType(), (DecoratedProcessingEnvironment)this.env);
                }
                catch (MirroredTypeException e) {
                    t = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)e.getTypeMirror(), (DecoratedProcessingEnvironment)this.env);
                    Element el = t instanceof DeclaredType ? ((DeclaredType)t).asElement() : null;
                    te = el instanceof TypeElement ? (TypeElement)el : null;
                }
                String name = type.name();
                if (name.isEmpty() && te != null && (typeName = te.getAnnotation(JsonTypeName.class)) != null) {
                    name = typeName.value();
                }
                if (name.isEmpty() && te != null) {
                    name = te.getSimpleName().toString();
                }
                if (name.isEmpty()) continue;
                subtypes.put(name, t);
            }
        }
        return subtypes;
    }

    public List<Accessor> getAllAccessors() {
        ArrayList<Accessor> accessors = new ArrayList<Accessor>();
        Value value = this.getValue();
        if (value != null) {
            accessors.add(value);
        }
        accessors.addAll(this.getMembers());
        return accessors;
    }

    public static class Jackson1PropertySpec
    extends ElementUtils.DefaultPropertySpec {
        public Jackson1PropertySpec(DecoratedProcessingEnvironment env) {
            super(env);
        }

        public boolean isGetter(DecoratedExecutableElement executable) {
            return executable.isGetter() || executable.getParameters().isEmpty() && (executable.getAnnotation(JsonProperty.class) != null || executable.getAnnotation(JsonValue.class) != null);
        }

        public boolean isSetter(DecoratedExecutableElement executable) {
            return executable.isSetter() || executable.getParameters().size() == 1 && (executable.getAnnotation(JsonProperty.class) != null || executable.getAnnotation(JsonValue.class) != null);
        }

        public String getPropertyName(DecoratedExecutableElement method) {
            String propertyName;
            JsonProperty jsonProperty = (JsonProperty)method.getAnnotation(JsonProperty.class);
            if (jsonProperty != null && !(propertyName = jsonProperty.value()).isEmpty()) {
                return propertyName;
            }
            return this.getSimpleName(method);
        }

        public String getSimpleName(DecoratedExecutableElement method) {
            if (method.isGetter() || method.isSetter()) {
                return method.getPropertyName();
            }
            return method.getSimpleName().toString();
        }
    }
}

