/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.model.types;

import com.webcohesion.enunciate.modules.jackson.model.SimpleTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonType;

public class JsonClassType
implements JsonType {
    private final TypeDefinition typeDef;

    public JsonClassType(TypeDefinition typeDef) {
        if (typeDef == null) {
            throw new IllegalArgumentException("A type definition must be supplied.");
        }
        this.typeDef = typeDef;
    }

    @Override
    public boolean isObject() {
        return !(this.typeDef instanceof SimpleTypeDefinition);
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isString() {
        return !this.isObject() && ((SimpleTypeDefinition)this.typeDef).getBaseType().isString();
    }

    @Override
    public boolean isNumber() {
        return !this.isObject() && ((SimpleTypeDefinition)this.typeDef).getBaseType().isNumber();
    }

    @Override
    public boolean isWholeNumber() {
        return this.isNumber() && ((SimpleTypeDefinition)this.typeDef).getBaseType().isWholeNumber();
    }

    @Override
    public boolean isBoolean() {
        return !this.isObject() && ((SimpleTypeDefinition)this.typeDef).getBaseType().isBoolean();
    }

    public TypeDefinition getTypeDefinition() {
        return this.typeDef;
    }
}

