/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedExecutableElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedTypeElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.decorations.element.PropertyElement;
import com.webcohesion.enunciate.javac.decorations.element.PropertySpec;
import com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils;
import com.webcohesion.enunciate.metadata.ClientName;
import com.webcohesion.enunciate.modules.jackson.EnunciateJacksonContext;
import com.webcohesion.enunciate.modules.jackson.model.Accessor;
import com.webcohesion.enunciate.modules.jackson.model.AccessorFilter;
import com.webcohesion.enunciate.modules.jackson.model.Member;
import com.webcohesion.enunciate.modules.jackson.model.MemberComparator;
import com.webcohesion.enunciate.modules.jackson.model.Value;
import com.webcohesion.enunciate.modules.jackson.model.WildcardMember;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

public abstract class TypeDefinition
extends DecoratedTypeElement
implements HasFacets {
    private final SortedSet<Member> members;
    private final Value value;
    private final WildcardMember wildcardMember;
    private final LinkedList<Element> referencedFrom = new LinkedList();
    private final Set<Facet> facets = new TreeSet<Facet>();
    protected final EnunciateJacksonContext context;
    private final String[] propOrder;

    protected TypeDefinition(TypeElement delegate, EnunciateJacksonContext context) {
        super(delegate, context.getContext().getProcessingEnvironment());
        JsonPropertyOrder propOrderInfo;
        XmlType typeInfo;
        this.context = context;
        String[] propOrder = null;
        boolean alphabetical = false;
        if (context.isHonorJaxb() && (typeInfo = (XmlType)this.getAnnotation(XmlType.class)) != null && (propOrder = typeInfo.propOrder()).length == 1 && "".equals(propOrder[0])) {
            propOrder = null;
        }
        if ((propOrderInfo = (JsonPropertyOrder)this.getAnnotation(JsonPropertyOrder.class)) != null) {
            propOrder = propOrderInfo.value();
            alphabetical = propOrderInfo.alphabetic();
        }
        MemberComparator comparator = new MemberComparator(propOrder, alphabetical, this.env);
        TreeSet<Member> memberAccessors = new TreeSet<Member>(comparator);
        Value value = null;
        WildcardMember wildcardMember = null;
        JsonIgnoreType ignoreType = (JsonIgnoreType)this.getAnnotation(JsonIgnoreType.class);
        if (ignoreType == null || !ignoreType.value()) {
            AccessorFilter filter = new AccessorFilter((JsonAutoDetect)this.getAnnotation(JsonAutoDetect.class), (JsonIgnoreProperties)this.getAnnotation(JsonIgnoreProperties.class), context.isHonorJaxb(), (XmlAccessorType)this.getAnnotation(XmlAccessorType.class));
            value = null;
            wildcardMember = null;
            for (Element accessor : this.loadPotentialAccessors(filter)) {
                if (this.isValue(accessor)) {
                    if (value != null) {
                        throw new EnunciateException("Accessor " + accessor.getSimpleName() + " of " + this.getQualifiedName() + ": a type definition cannot have more than one json value.");
                    }
                    value = new Value(accessor, this, context);
                    continue;
                }
                if (this.isWildcardProperty(accessor)) {
                    wildcardMember = new WildcardMember(accessor, this, context);
                    continue;
                }
                if (accessor instanceof PropertyElement && (this.overridesAnother(((PropertyElement)accessor).getGetter()) || this.overridesAnother(((PropertyElement)accessor).getSetter()))) continue;
                memberAccessors.add(new Member(accessor, this, context));
            }
        }
        this.propOrder = propOrder;
        this.members = Collections.unmodifiableSortedSet(memberAccessors);
        this.value = value;
        this.wildcardMember = wildcardMember;
        this.facets.addAll(Facet.gatherFacets((Element)delegate, (EnunciateContext)context.getContext()));
        this.facets.addAll(Facet.gatherFacets((Element)this.env.getElementUtils().getPackageOf(delegate), (EnunciateContext)context.getContext()));
    }

    protected TypeDefinition(TypeDefinition copy) {
        super((TypeElement)copy.delegate, copy.env);
        this.members = copy.members;
        this.value = copy.value;
        this.wildcardMember = copy.wildcardMember;
        this.facets.addAll(copy.facets);
        this.context = copy.context;
        this.propOrder = copy.propOrder;
    }

    public EnunciateJacksonContext getContext() {
        return this.context;
    }

    protected List<Element> loadPotentialAccessors(AccessorFilter filter) {
        ArrayList<VariableElement> potentialFields = new ArrayList<VariableElement>();
        ArrayList<PropertyElement> potentialProperties = new ArrayList<PropertyElement>();
        this.aggregatePotentialAccessors(potentialFields, potentialProperties, this, filter, this.context.isCollapseTypeHierarchy());
        ArrayList<Element> accessors = new ArrayList<Element>();
        accessors.addAll(potentialFields);
        accessors.addAll(potentialProperties);
        return accessors;
    }

    protected void aggregatePotentialAccessors(List<VariableElement> fields, List<PropertyElement> properties, DecoratedTypeElement clazz, AccessorFilter filter, boolean inlineAccessorsOfSuperclasses) {
        DecoratedTypeElement superDeclaration;
        String fqn = clazz.getQualifiedName().toString();
        if (Object.class.getName().equals(fqn) || Enum.class.getName().equals(fqn)) {
            return;
        }
        DecoratedTypeElement decoratedTypeElement = superDeclaration = clazz.getSuperclass() != null ? (DecoratedTypeElement)this.env.getTypeUtils().asElement(clazz.getSuperclass()) : null;
        if (superDeclaration != null && (this.context.isIgnored((Element)superDeclaration) || inlineAccessorsOfSuperclasses)) {
            inlineAccessorsOfSuperclasses = true;
            this.aggregatePotentialAccessors(fields, properties, superDeclaration, filter, true);
        }
        TypeElement mixin = this.context.lookupMixin((TypeElement)clazz);
        ArrayList<VariableElement> fieldElements = new ArrayList<VariableElement>(ElementFilter.fieldsIn(clazz.getEnclosedElements()));
        if (mixin != null) {
            for (VariableElement mixinField : ElementFilter.fieldsIn(mixin.getEnclosedElements())) {
                int index = this.indexOf(fieldElements, mixinField.getSimpleName().toString());
                if (index >= 0) {
                    fieldElements.set(index, mixinField);
                    continue;
                }
                fieldElements.add(mixinField);
            }
        }
        for (VariableElement fieldDeclaration : fieldElements) {
            JsonUnwrapped unwrapped = fieldDeclaration.getAnnotation(JsonUnwrapped.class);
            if (unwrapped != null && unwrapped.enabled()) {
                DecoratedTypeElement element;
                TypeMirror typeMirror = fieldDeclaration.asType();
                switch (typeMirror.getKind()) {
                    case DECLARED: {
                        element = (DecoratedTypeElement)((DeclaredType)typeMirror).asElement();
                        break;
                    }
                    case TYPEVAR: {
                        typeMirror = ((TypeVariable)typeMirror).getUpperBound();
                        element = (DecoratedTypeElement)((DeclaredType)typeMirror).asElement();
                        break;
                    }
                    case WILDCARD: {
                        TypeMirror bound = ((WildcardType)typeMirror).getExtendsBound();
                        if (bound == null) {
                            bound = ((WildcardType)typeMirror).getSuperBound();
                        }
                        if (!(bound instanceof DeclaredType)) {
                            bound = TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)this.env);
                        }
                        element = (DecoratedTypeElement)((DeclaredType)bound).asElement();
                        break;
                    }
                    default: {
                        throw new EnunciateException(String.format("%s: %s cannot be JSON unwrapped.", fieldDeclaration, typeMirror));
                    }
                }
                this.aggregatePotentialAccessors(fields, properties, element, filter, inlineAccessorsOfSuperclasses);
                continue;
            }
            if (!filter.accept((DecoratedElement)fieldDeclaration)) {
                this.remove(fieldDeclaration, fields);
                continue;
            }
            this.addOrReplace(fieldDeclaration, fields);
        }
        JacksonPropertySpec propertySpec = new JacksonPropertySpec(this.env);
        ArrayList<PropertyElement> propertyElements = new ArrayList<PropertyElement>(clazz.getProperties((PropertySpec)propertySpec));
        if (mixin != null) {
            for (PropertyElement mixinProperty : ((DecoratedTypeElement)mixin).getProperties((PropertySpec)propertySpec)) {
                int index = this.indexOf(propertyElements, mixinProperty.getSimpleName().toString());
                if (index >= 0) {
                    propertyElements.set(index, mixinProperty);
                    continue;
                }
                propertyElements.add(mixinProperty);
            }
        }
        for (PropertyElement propertyDeclaration : propertyElements) {
            JsonUnwrapped unwrapped = (JsonUnwrapped)propertyDeclaration.getAnnotation(JsonUnwrapped.class);
            if (unwrapped != null && unwrapped.enabled()) {
                DecoratedTypeElement element;
                TypeMirror typeMirror = propertyDeclaration.asType();
                switch (typeMirror.getKind()) {
                    case DECLARED: {
                        element = (DecoratedTypeElement)((DeclaredType)typeMirror).asElement();
                        break;
                    }
                    case TYPEVAR: {
                        typeMirror = ((TypeVariable)typeMirror).getUpperBound();
                        element = (DecoratedTypeElement)((DeclaredType)typeMirror).asElement();
                        break;
                    }
                    case WILDCARD: {
                        TypeMirror bound = ((WildcardType)typeMirror).getExtendsBound();
                        if (bound == null) {
                            bound = ((WildcardType)typeMirror).getSuperBound();
                        }
                        if (!(bound instanceof DeclaredType)) {
                            bound = TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)this.env);
                        }
                        element = (DecoratedTypeElement)((DeclaredType)bound).asElement();
                        break;
                    }
                    default: {
                        throw new EnunciateException(String.format("%s: %s cannot be JSON unwrapped.", propertyDeclaration, typeMirror));
                    }
                }
                this.aggregatePotentialAccessors(fields, properties, element, filter, inlineAccessorsOfSuperclasses);
                continue;
            }
            if (!filter.accept((DecoratedElement<?>)propertyDeclaration) || this.indexOf(fields, propertyDeclaration.getSimpleName().toString()) >= 0) {
                this.remove(propertyDeclaration, properties);
                continue;
            }
            this.addOrReplace(propertyDeclaration, properties);
        }
    }

    protected int indexOf(List<? extends Element> accessors, String name) {
        for (int i = 0; i < accessors.size(); ++i) {
            Element accessor = accessors.get(i);
            if (!accessor.getSimpleName().toString().equals(name)) continue;
            return i;
        }
        return -1;
    }

    protected boolean overridesAnother(DecoratedExecutableElement method) {
        if (method == null) {
            return false;
        }
        if (this.context.isCollapseTypeHierarchy()) {
            return false;
        }
        TypeElement declaringType = (TypeElement)method.getEnclosingElement();
        TypeElement superType = (TypeElement)this.env.getTypeUtils().asElement(declaringType.getSuperclass());
        if (!this.context.isIgnored(superType)) {
            while (superType != null && !Object.class.getName().equals(superType.getQualifiedName().toString())) {
                List<ExecutableElement> methods = ElementFilter.methodsIn(superType.getEnclosedElements());
                for (ExecutableElement candidate : methods) {
                    if (!this.env.getElementUtils().overrides((ExecutableElement)method, candidate, declaringType)) continue;
                    return true;
                }
                superType = (TypeElement)this.env.getTypeUtils().asElement(superType.getSuperclass());
            }
        }
        return false;
    }

    protected <M extends Element> void addOrReplace(M memberDeclaration, List<M> memberDeclarations) {
        this.remove(memberDeclaration, memberDeclarations);
        memberDeclarations.add(memberDeclaration);
    }

    protected <M extends Element> void remove(M memberDeclaration, List<M> memberDeclarations) {
        Iterator<M> it = memberDeclarations.iterator();
        while (it.hasNext()) {
            Element candidate = (Element)it.next();
            if (!candidate.getSimpleName().equals(memberDeclaration.getSimpleName())) continue;
            it.remove();
        }
    }

    protected boolean isValue(Element declaration) {
        return declaration.getAnnotation(JsonValue.class) != null;
    }

    protected boolean isWildcardProperty(Element declaration) {
        return declaration.getAnnotation(JsonAnyGetter.class) != null;
    }

    public String getClientSimpleName() {
        String clientSimpleName = this.getSimpleName().toString();
        ClientName clientName = (ClientName)this.getAnnotation(ClientName.class);
        if (clientName != null) {
            clientSimpleName = clientName.value();
        }
        return clientSimpleName;
    }

    public WildcardMember getWildcardMember() {
        return this.wildcardMember;
    }

    public SortedSet<Member> getMembers() {
        return this.members;
    }

    public Value getValue() {
        return this.value;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    public boolean isBaseObject() {
        return true;
    }

    public LinkedList<Element> getReferencedFrom() {
        return this.referencedFrom;
    }

    public Set<Facet> getFacets() {
        return this.facets;
    }

    public boolean isHasTypeInfo() {
        return this.getAnnotation(JsonTypeInfo.class) != null;
    }

    public JsonTypeInfo.Id getTypeIdType() {
        JsonTypeInfo.Id typeIdType = JsonTypeInfo.Id.CLASS;
        JsonTypeInfo typeInfo = (JsonTypeInfo)this.getAnnotation(JsonTypeInfo.class);
        if (typeInfo != null) {
            typeIdType = typeInfo.use();
        }
        return typeIdType;
    }

    public JsonTypeInfo.As getTypeIdInclusion() {
        JsonTypeInfo.As inclusion = JsonTypeInfo.As.PROPERTY;
        JsonTypeInfo typeInfo = (JsonTypeInfo)this.getAnnotation(JsonTypeInfo.class);
        if (typeInfo != null) {
            inclusion = typeInfo.include();
        }
        return inclusion;
    }

    public String getTypeIdProperty() {
        String property = null;
        JsonTypeInfo typeInfo = (JsonTypeInfo)this.getAnnotation(JsonTypeInfo.class);
        if (typeInfo != null && "".equals(property = typeInfo.property())) {
            property = null;
        }
        return property;
    }

    public String[] getPropertyOrder() {
        return this.propOrder;
    }

    public List<Accessor> getAllAccessors() {
        ArrayList<Accessor> accessors = new ArrayList<Accessor>();
        Value value = this.getValue();
        if (value != null) {
            accessors.add(value);
        }
        accessors.addAll(this.getMembers());
        return accessors;
    }

    public static class JacksonPropertySpec
    extends ElementUtils.DefaultPropertySpec {
        public JacksonPropertySpec(DecoratedProcessingEnvironment env) {
            super(env);
        }

        public boolean isGetter(DecoratedExecutableElement executable) {
            return executable.isGetter() || executable.getParameters().isEmpty() && (executable.getAnnotation(JsonProperty.class) != null || executable.getAnnotation(JsonValue.class) != null);
        }

        public boolean isSetter(DecoratedExecutableElement executable) {
            return executable.isSetter() || executable.getParameters().size() == 1 && (executable.getAnnotation(JsonProperty.class) != null || executable.getAnnotation(JsonValue.class) != null);
        }

        public String getPropertyName(DecoratedExecutableElement method) {
            String propertyName;
            JsonProperty jsonProperty = (JsonProperty)method.getAnnotation(JsonProperty.class);
            if (jsonProperty != null && !(propertyName = jsonProperty.value()).isEmpty()) {
                return propertyName;
            }
            if (method.isGetter() || method.isSetter()) {
                return method.getPropertyName();
            }
            return method.getSimpleName().toString();
        }
    }
}

