/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.api.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.webcohesion.enunciate.api.datatype.BaseType;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.datatype.Example;
import com.webcohesion.enunciate.api.datatype.Property;
import com.webcohesion.enunciate.api.datatype.Value;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.modules.jackson.api.impl.DataTypeImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.DataTypeReferenceImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.ExampleImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.PropertyImpl;
import com.webcohesion.enunciate.modules.jackson.model.Member;
import com.webcohesion.enunciate.modules.jackson.model.ObjectTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonClassType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonTypeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import javax.lang.model.element.Element;

public class ObjectDataTypeImpl
extends DataTypeImpl {
    final ObjectTypeDefinition typeDefinition;

    public ObjectDataTypeImpl(ObjectTypeDefinition typeDefinition) {
        super(typeDefinition);
        this.typeDefinition = typeDefinition;
    }

    public BaseType getBaseType() {
        return BaseType.object;
    }

    public List<? extends Value> getValues() {
        return null;
    }

    public List<? extends Property> getProperties() {
        SortedSet<Member> members = this.typeDefinition.getMembers();
        ArrayList<PropertyImpl> properties = new ArrayList<PropertyImpl>(members.size());
        FacetFilter facetFilter = this.typeDefinition.getContext().getContext().getConfiguration().getFacetFilter();
        for (Member member : members) {
            if (!facetFilter.accept((HasFacets)member)) continue;
            if (member.getChoices().size() > 1) {
                JsonTypeInfo.As inclusion = member.getSubtypeIdInclusion();
                if (inclusion == JsonTypeInfo.As.WRAPPER_ARRAY || inclusion == JsonTypeInfo.As.WRAPPER_OBJECT) {
                    for (Member member2 : member.getChoices()) {
                        properties.add(new PropertyImpl(member2));
                    }
                    continue;
                }
                properties.add(new PropertyImpl(member));
                continue;
            }
            properties.add(new PropertyImpl(member));
        }
        return properties;
    }

    public List<? extends Property> getRequiredProperties() {
        ArrayList<Property> requiredProperties = new ArrayList<Property>();
        for (Property property : this.getProperties()) {
            if (!property.isRequired()) continue;
            requiredProperties.add(property);
        }
        return requiredProperties;
    }

    @Override
    public List<DataTypeReference> getSupertypes() {
        ArrayList<DataTypeReferenceImpl> supertypes = null;
        JsonType supertype = this.typeDefinition.getSupertype();
        while (supertype != null) {
            if (supertypes == null) {
                supertypes = new ArrayList<DataTypeReferenceImpl>();
            }
            supertypes.add(new DataTypeReferenceImpl(supertype));
            supertype = supertype instanceof JsonClassType ? (((JsonClassType)supertype).getTypeDefinition() instanceof ObjectTypeDefinition ? ((ObjectTypeDefinition)((JsonClassType)supertype).getTypeDefinition()).getSupertype() : null) : null;
        }
        return supertypes;
    }

    @Override
    public List<DataTypeReference> getSubtypes() {
        ArrayList<DataTypeReference> subtypes = new ArrayList<DataTypeReference>();
        for (TypeDefinition td : this.typeDefinition.getContext().getTypeDefinitions()) {
            if (!(td instanceof ObjectTypeDefinition) || td.getQualifiedName().contentEquals(this.typeDefinition.getQualifiedName()) || !((DecoratedTypeMirror)td.asType()).isInstanceOf((Element)((Object)this.typeDefinition))) continue;
            subtypes.add(new DataTypeReferenceImpl(JsonTypeFactory.getJsonType(td.asType(), this.typeDefinition.getContext())));
        }
        return subtypes.isEmpty() ? null : subtypes;
    }

    @Override
    public Example getExample() {
        return this.typeDefinition.getContext().isDisableExamples() ? null : new ExampleImpl(this.typeDefinition);
    }
}

