/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.api.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.datatype.Example;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.metadata.DocumentationExample;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import com.webcohesion.enunciate.modules.jackson.model.EnumTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.EnumValue;
import com.webcohesion.enunciate.modules.jackson.model.Member;
import com.webcohesion.enunciate.modules.jackson.model.ObjectTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.SimpleTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonArrayType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonClassType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonMapType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonTypeFactory;
import com.webcohesion.enunciate.util.TypeHintUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class ExampleImpl
implements Example {
    private final ObjectTypeDefinition type;
    private final List<DataTypeReference.ContainerType> containers;

    public ExampleImpl(ObjectTypeDefinition type) {
        this(type, null);
    }

    public ExampleImpl(ObjectTypeDefinition typeDefinition, List<DataTypeReference.ContainerType> containers) {
        this.type = typeDefinition;
        this.containers = containers == null ? Collections.emptyList() : containers;
    }

    public String getLang() {
        return "js";
    }

    public String getBody() {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        Context context = new Context();
        context.stack = new LinkedList();
        this.build(node, this.type, context);
        ObjectNode outer = node;
        for (DataTypeReference.ContainerType container : this.containers) {
            switch (container) {
                case array: 
                case collection: 
                case list: {
                    ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
                    arrayNode.add((JsonNode)outer);
                    outer = arrayNode;
                    break;
                }
                case map: {
                    ObjectNode mapNode = JsonNodeFactory.instance.objectNode();
                    mapNode.put("...", (JsonNode)outer);
                    outer = mapNode;
                }
            }
        }
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        try {
            return mapper.writeValueAsString((Object)outer);
        }
        catch (JsonProcessingException e) {
            throw new EnunciateException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void build(ObjectNode node, ObjectTypeDefinition type, Context context) {
        if (context.stack.size() > 2) {
            return;
        }
        if (type.getTypeIdInclusion() == JsonTypeInfo.As.PROPERTY && type.getTypeIdProperty() != null) {
            node.put(type.getTypeIdProperty(), "...");
        }
        FacetFilter facetFilter = type.getContext().getContext().getConfiguration().getFacetFilter();
        for (Member member : type.getMembers()) {
            DocumentationExample documentationExample;
            String tag;
            if (!facetFilter.accept((HasFacets)member) || ElementUtils.findDeprecationMessage((DecoratedElement)member) != null) continue;
            String example = null;
            String example2 = null;
            JsonType exampleType = null;
            JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)member.getJavaDoc().get((Object)"documentationExample");
            if (tags != null && tags.size() > 0) {
                tag = ((String)tags.get(0)).trim();
                example2 = example = tag.isEmpty() ? null : tag;
                if (tags.size() > 1) {
                    tag = ((String)tags.get(1)).trim();
                    String string = example2 = tag.isEmpty() ? null : tag;
                }
            }
            if ((tags = (JavaDoc.JavaDocTagList)member.getJavaDoc().get((Object)"documentationType")) != null && tags.size() > 0 && !(tag = ((String)tags.get(0)).trim()).isEmpty()) {
                TypeElement typeElement = type.getContext().getContext().getProcessingEnvironment().getElementUtils().getTypeElement(tag);
                if (typeElement != null) {
                    exampleType = JsonTypeFactory.getJsonType(typeElement.asType(), type.getContext());
                } else {
                    type.getContext().getContext().getLogger().warn("Invalid documentation type %s.", new Object[]{tag});
                }
            }
            if ((documentationExample = (DocumentationExample)member.getAnnotation(DocumentationExample.class)) != null) {
                if (documentationExample.exclude()) continue;
                example = documentationExample.value();
                example = "##default".equals(example) ? null : example;
                example2 = documentationExample.value2();
                example2 = "##default".equals(example2) ? null : example2;
                TypeMirror typeHint = TypeHintUtils.getTypeHint((TypeHint)documentationExample.type(), (DecoratedProcessingEnvironment)type.getContext().getContext().getProcessingEnvironment(), null);
                if (typeHint != null) {
                    exampleType = JsonTypeFactory.getJsonType(typeHint, type.getContext());
                }
            }
            if (context.currentIndex % 2 > 0) {
                String placeholder = example2;
                example2 = example;
                example = placeholder;
            }
            if (member.getChoices().size() > 1) {
                ArrayNode wrapperNode;
                String choiceName;
                JsonType jsonType;
                if (member.isCollectionType()) {
                    ArrayNode exampleNode = JsonNodeFactory.instance.arrayNode();
                    for (Member member2 : member.getChoices()) {
                        jsonType = exampleType == null ? member2.getJsonType() : exampleType;
                        choiceName = member2.getName();
                        if ("".equals(choiceName)) {
                            choiceName = "...";
                        }
                        if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.WRAPPER_ARRAY) {
                            wrapperNode = JsonNodeFactory.instance.arrayNode();
                            wrapperNode.add(choiceName);
                            wrapperNode.add(this.exampleNode(jsonType, example, example2, context));
                            exampleNode.add((JsonNode)wrapperNode);
                            continue;
                        }
                        if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.WRAPPER_OBJECT) {
                            wrapperNode = JsonNodeFactory.instance.objectNode();
                            wrapperNode.set(choiceName, this.exampleNode(jsonType, example, example2, context));
                            exampleNode.add((JsonNode)wrapperNode);
                            continue;
                        }
                        JsonNode itemNode = this.exampleNode(jsonType, example, example2, context);
                        if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.PROPERTY) {
                            if (member.getSubtypeIdProperty() != null && itemNode instanceof ObjectNode) {
                                ((ObjectNode)itemNode).put(member.getSubtypeIdProperty(), "...");
                            }
                        } else if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.EXTERNAL_PROPERTY && member.getSubtypeIdProperty() != null) {
                            node.put(member.getSubtypeIdProperty(), "...");
                        }
                        exampleNode.add(itemNode);
                    }
                    node.set(member.getName(), (JsonNode)exampleNode);
                    continue;
                }
                for (Member member3 : member.getChoices()) {
                    void var14_21;
                    jsonType = exampleType == null ? member3.getJsonType() : exampleType;
                    choiceName = member3.getName();
                    if ("".equals(choiceName)) {
                        choiceName = "...";
                    }
                    if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.WRAPPER_ARRAY) {
                        wrapperNode = JsonNodeFactory.instance.arrayNode();
                        wrapperNode.add(choiceName);
                        wrapperNode.add(this.exampleNode(jsonType, example, example2, context));
                        ArrayNode arrayNode = wrapperNode;
                    } else if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.WRAPPER_OBJECT) {
                        wrapperNode = JsonNodeFactory.instance.objectNode();
                        wrapperNode.set(choiceName, this.exampleNode(jsonType, example, example2, context));
                        ArrayNode arrayNode = wrapperNode;
                    } else {
                        JsonNode jsonNode = this.exampleNode(jsonType, example, example2, context);
                        if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.PROPERTY) {
                            if (member.getSubtypeIdProperty() != null && jsonNode instanceof ObjectNode) {
                                ((ObjectNode)jsonNode).put(member.getSubtypeIdProperty(), "...");
                            }
                        } else if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.EXTERNAL_PROPERTY && member.getSubtypeIdProperty() != null) {
                            node.put(member.getSubtypeIdProperty(), "...");
                        }
                    }
                    node.set(member.getName(), (JsonNode)var14_21);
                }
                continue;
            }
            JsonType jsonType = exampleType == null ? member.getJsonType() : exampleType;
            node.set(member.getName(), this.exampleNode(jsonType, example, example2, context));
        }
        JsonType supertype = type.getSupertype();
        if (supertype instanceof JsonClassType && ((JsonClassType)supertype).getTypeDefinition() instanceof ObjectTypeDefinition) {
            this.build(node, (ObjectTypeDefinition)((JsonClassType)supertype).getTypeDefinition(), context);
        }
        if (type.getWildcardMember() != null && ElementUtils.findDeprecationMessage((DecoratedElement)type.getWildcardMember()) == null) {
            node.put("extension1", "...");
            node.put("extension2", "...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode exampleNode(JsonType jsonType, String specifiedExample, String specifiedExample2, Context context) {
        if (jsonType instanceof JsonClassType) {
            TypeDefinition typeDefinition = ((JsonClassType)jsonType).getTypeDefinition();
            if (typeDefinition instanceof ObjectTypeDefinition) {
                ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
                if (!context.stack.contains(typeDefinition.getQualifiedName().toString())) {
                    context.stack.push(typeDefinition.getQualifiedName().toString());
                    try {
                        this.build(objectNode, (ObjectTypeDefinition)typeDefinition, context);
                    }
                    finally {
                        context.stack.pop();
                    }
                }
                return objectNode;
            }
            if (typeDefinition instanceof EnumTypeDefinition) {
                String example = "???";
                if (specifiedExample != null) {
                    example = specifiedExample;
                } else {
                    List<EnumValue> enumValues = ((EnumTypeDefinition)typeDefinition).getEnumValues();
                    if (enumValues.size() > 0) {
                        int index = new Random().nextInt(enumValues.size());
                        example = enumValues.get(index).getValue();
                    }
                }
                return JsonNodeFactory.instance.textNode(example);
            }
            return this.exampleNode(((SimpleTypeDefinition)typeDefinition).getBaseType(), specifiedExample, specifiedExample2, context);
        }
        if (jsonType instanceof JsonMapType) {
            ObjectNode mapNode = JsonNodeFactory.instance.objectNode();
            JsonType valueType = ((JsonMapType)jsonType).getValueType();
            mapNode.set("property1", this.exampleNode(valueType, specifiedExample, specifiedExample2, context));
            Context context2 = new Context();
            context2.stack = context.stack;
            context2.currentIndex = 1;
            mapNode.set("property2", this.exampleNode(valueType, specifiedExample, specifiedExample2, context2));
            return mapNode;
        }
        if (jsonType.isArray()) {
            ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
            if (jsonType instanceof JsonArrayType) {
                JsonNode componentNode = this.exampleNode(((JsonArrayType)jsonType).getComponentType(), specifiedExample, specifiedExample2, context);
                arrayNode.add(componentNode);
                Context context2 = new Context();
                context2.stack = context.stack;
                context2.currentIndex = 1;
                JsonNode componentNode2 = this.exampleNode(((JsonArrayType)jsonType).getComponentType(), specifiedExample2, specifiedExample, context2);
                arrayNode.add(componentNode2);
            }
            return arrayNode;
        }
        if (jsonType.isWholeNumber()) {
            Long example = 12345L;
            if (specifiedExample != null) {
                try {
                    example = Long.parseLong(specifiedExample);
                }
                catch (NumberFormatException e) {
                    this.type.getContext().getContext().getLogger().warn("\"%s\" was provided as a documentation example, but it is not a valid JSON whole number, so it will be ignored.", new Object[]{specifiedExample});
                }
            }
            return JsonNodeFactory.instance.numberNode(example);
        }
        if (jsonType.isNumber()) {
            Double example = 12345.0;
            if (specifiedExample != null) {
                try {
                    example = Double.parseDouble(specifiedExample);
                }
                catch (NumberFormatException e) {
                    this.type.getContext().getContext().getLogger().warn("\"%s\" was provided as a documentation example, but it is not a valid JSON number, so it will be ignored.", new Object[]{specifiedExample});
                }
            }
            return JsonNodeFactory.instance.numberNode(example);
        }
        if (jsonType.isBoolean()) {
            boolean example = !"false".equals(specifiedExample);
            return JsonNodeFactory.instance.booleanNode(example);
        }
        if (jsonType.isString()) {
            String example = specifiedExample;
            if (example == null) {
                example = "...";
            }
            return JsonNodeFactory.instance.textNode(example);
        }
        return JsonNodeFactory.instance.objectNode();
    }

    private static class Context {
        LinkedList<String> stack;
        int currentIndex = 0;

        private Context() {
        }
    }
}

