/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.api.impl;

import com.webcohesion.enunciate.api.Styles;
import com.webcohesion.enunciate.api.datatype.BaseType;
import com.webcohesion.enunciate.api.datatype.Property;
import com.webcohesion.enunciate.api.datatype.Value;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.modules.jackson.api.impl.DataTypeImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.ValueImpl;
import com.webcohesion.enunciate.modules.jackson.model.EnumTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.EnumValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;

public class EnumDataTypeImpl
extends DataTypeImpl {
    private final EnumTypeDefinition typeDefinition;

    public EnumDataTypeImpl(EnumTypeDefinition typeDefinition) {
        super(typeDefinition);
        this.typeDefinition = typeDefinition;
    }

    public BaseType getBaseType() {
        return BaseType.string;
    }

    public List<? extends Value> getValues() {
        FacetFilter facetFilter = this.typeDefinition.getContext().getContext().getConfiguration().getFacetFilter();
        List<EnumValue> enumValues = this.typeDefinition.getEnumValues();
        ArrayList<ValueImpl> values = new ArrayList<ValueImpl>(enumValues.size());
        for (EnumValue enumValue : enumValues) {
            if (enumValue.getValue() == null || !facetFilter.accept((HasFacets)enumValue)) continue;
            values.add(new ValueImpl(enumValue.getValue(), enumValue.getJavaDoc().toString(), Styles.gatherStyles((Element)((Object)enumValue), (Map)this.typeDefinition.getContext().getContext().getConfiguration().getAnnotationStyles()), enumValue.getFacets()));
        }
        return values;
    }

    public List<? extends Property> getProperties() {
        return null;
    }
}

