/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.idl;

import com.webcohesion.enunciate.api.InterfaceDescriptionFile;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.modules.idl.IDLObjectWrapper;
import com.webcohesion.enunciate.modules.jaxb.util.PrefixMethod;
import com.webcohesion.enunciate.util.freemarker.IsFacetExcludedMethod;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseXMLInterfaceDescriptionFile
implements InterfaceDescriptionFile {
    protected final FacetFilter facetFilter;
    protected final Map<String, String> namespacePrefixes;
    protected final String filename;
    private String contents;

    public BaseXMLInterfaceDescriptionFile(String filename, Map<String, String> namespacePrefixes, FacetFilter facetFilter) {
        this.namespacePrefixes = namespacePrefixes;
        this.facetFilter = facetFilter;
        this.filename = filename;
    }

    public String getHref() {
        if (this.contents == null) {
            throw new IllegalStateException(String.format("%s hasn't been written yet.", this.filename));
        }
        return this.filename;
    }

    public void writeTo(File directory) throws IOException {
        FileWriter writer = new FileWriter(new File(directory, this.filename));
        this.writeTo(writer);
        writer.flush();
        writer.close();
    }

    protected void writeTo(Writer writer) throws IOException {
        if (this.contents != null) {
            writer.write(this.contents);
        } else {
            Map<String, Object> model = this.createModel();
            URL template = this.getTemplateURL();
            String idl = this.processTemplate(template, model);
            writer.write(idl);
        }
    }

    protected Map<String, Object> createModel() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("prefix", new PrefixMethod(this.namespacePrefixes));
        model.put("isFacetExcluded", new IsFacetExcludedMethod(this.facetFilter));
        return model;
    }

    protected abstract URL getTemplateURL();

    protected String processTemplate(URL templateURL, Map<String, Object> model) throws IOException {
        String idl;
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_22);
        configuration.setTemplateLoader((TemplateLoader)new URLTemplateLoader(){

            protected URL getURL(String name) {
                try {
                    return new URL(name);
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        });
        configuration.setTemplateExceptionHandler(new TemplateExceptionHandler(){

            public void handleTemplateException(TemplateException templateException, Environment environment, Writer writer) throws TemplateException {
                throw templateException;
            }
        });
        configuration.setLocalizedLookup(false);
        configuration.setDefaultEncoding("UTF-8");
        configuration.setObjectWrapper((ObjectWrapper)new IDLObjectWrapper(this.namespacePrefixes));
        Template template = configuration.getTemplate(templateURL.toString());
        StringWriter output = new StringWriter();
        try {
            template.process(model, (Writer)output);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
        this.contents = idl = output.toString();
        return idl;
    }
}

