/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.idl;

import com.webcohesion.enunciate.Enunciate;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.modules.idl.BaseXMLInterfaceDescriptionFile;
import com.webcohesion.enunciate.modules.idl.IDLModule;
import com.webcohesion.enunciate.modules.idl.IsDefinedGloballyMethod;
import com.webcohesion.enunciate.modules.idl.QNameForTypeMethod;
import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.model.SchemaInfo;
import com.webcohesion.enunciate.modules.jaxb.util.AccessorOverridesAnotherMethod;
import com.webcohesion.enunciate.modules.jaxws.WsdlInfo;
import java.net.URL;
import java.util.Map;

public class JaxwsWsdlFile
extends BaseXMLInterfaceDescriptionFile {
    private final WsdlInfo wsdlInfo;
    private final String baseUri;
    private final EnunciateJaxbContext context;

    public JaxwsWsdlFile(Enunciate enunciate, String artifactId, WsdlInfo wsdlInfo, EnunciateJaxbContext context, String baseUri, Map<String, String> namespacePrefixes, FacetFilter facetFilter) {
        super(enunciate, artifactId, wsdlInfo.getFilename(), namespacePrefixes, facetFilter);
        this.wsdlInfo = wsdlInfo;
        this.baseUri = baseUri;
        this.context = context;
    }

    @Override
    protected Map<String, Object> createModel() {
        Map<String, Object> model = super.createModel();
        model.put("wsdl", this.wsdlInfo);
        String baseUri = this.baseUri;
        if (baseUri == null) {
            baseUri = "http://localhost:8080/";
        }
        model.put("baseUri", baseUri);
        SchemaInfo schema = (SchemaInfo)this.context.getSchemas().get(this.wsdlInfo.getTargetNamespace());
        if (schema != null) {
            model.put("isDefinedGlobally", new IsDefinedGloballyMethod(schema));
        }
        model.put("accessorOverridesAnother", new AccessorOverridesAnotherMethod());
        model.put("qnameForType", new QNameForTypeMethod(this.context));
        return model;
    }

    @Override
    protected URL getTemplateURL() {
        return IDLModule.class.getResource("wsdl.fmt");
    }
}

