/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.CollectionUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;

public class RegistrationRequest
implements Serializable {
    private final byte[] attestationObject;
    private final byte[] clientDataJSON;
    private final String clientExtensionsJSON;
    private final Set<String> transports;

    public RegistrationRequest(byte[] attestationObject, byte[] clientDataJSON, String clientExtensionsJSON, Set<String> transports) {
        this.attestationObject = ArrayUtil.clone((byte[])attestationObject);
        this.clientDataJSON = ArrayUtil.clone((byte[])clientDataJSON);
        this.clientExtensionsJSON = clientExtensionsJSON;
        this.transports = CollectionUtil.unmodifiableSet(transports);
    }

    public RegistrationRequest(byte[] attestationObject, byte[] clientDataJSON, String clientExtensionsJSON) {
        this(attestationObject, clientDataJSON, clientExtensionsJSON, null);
    }

    public RegistrationRequest(byte[] attestationObject, byte[] clientDataJSON, Set<String> transports) {
        this(attestationObject, clientDataJSON, null, transports);
    }

    public RegistrationRequest(byte[] attestationObject, byte[] clientDataJSON) {
        this(attestationObject, clientDataJSON, null, null);
    }

    public byte[] getAttestationObject() {
        return ArrayUtil.clone((byte[])this.attestationObject);
    }

    public byte[] getClientDataJSON() {
        return ArrayUtil.clone((byte[])this.clientDataJSON);
    }

    public String getClientExtensionsJSON() {
        return this.clientExtensionsJSON;
    }

    public Set<String> getTransports() {
        return this.transports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistrationRequest that = (RegistrationRequest)o;
        return Arrays.equals(this.attestationObject, that.attestationObject) && Arrays.equals(this.clientDataJSON, that.clientDataJSON) && Objects.equals(this.clientExtensionsJSON, that.clientExtensionsJSON) && Objects.equals(this.transports, that.transports);
    }

    public int hashCode() {
        int result = Objects.hash(this.clientExtensionsJSON, this.transports);
        result = 31 * result + Arrays.hashCode(this.attestationObject);
        result = 31 * result + Arrays.hashCode(this.clientDataJSON);
        return result;
    }
}

