/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.CollectionUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;

public class RegistrationData
implements Serializable {
    private final AttestationObject attestationObject;
    private final byte[] attestationObjectBytes;
    private final CollectedClientData collectedClientData;
    private final byte[] collectedClientDataBytes;
    private final AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput<?>> clientExtensions;
    private final Set<AuthenticatorTransport> transports;

    public RegistrationData(AttestationObject attestationObject, byte[] attestationObjectBytes, CollectedClientData collectedClientData, byte[] collectedClientDataBytes, AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput<?>> clientExtensions, Set<AuthenticatorTransport> transports) {
        this.attestationObject = attestationObject;
        this.attestationObjectBytes = ArrayUtil.clone((byte[])attestationObjectBytes);
        this.collectedClientData = collectedClientData;
        this.collectedClientDataBytes = ArrayUtil.clone((byte[])collectedClientDataBytes);
        this.clientExtensions = clientExtensions;
        this.transports = CollectionUtil.unmodifiableSet(transports);
    }

    public AttestationObject getAttestationObject() {
        return this.attestationObject;
    }

    public byte[] getAttestationObjectBytes() {
        return ArrayUtil.clone((byte[])this.attestationObjectBytes);
    }

    public CollectedClientData getCollectedClientData() {
        return this.collectedClientData;
    }

    public byte[] getCollectedClientDataBytes() {
        return ArrayUtil.clone((byte[])this.collectedClientDataBytes);
    }

    public AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput<?>> getClientExtensions() {
        return this.clientExtensions;
    }

    public Set<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistrationData that = (RegistrationData)o;
        return Objects.equals(this.attestationObject, that.attestationObject) && Arrays.equals(this.attestationObjectBytes, that.attestationObjectBytes) && Objects.equals(this.collectedClientData, that.collectedClientData) && Arrays.equals(this.collectedClientDataBytes, that.collectedClientDataBytes) && Objects.equals(this.clientExtensions, that.clientExtensions) && Objects.equals(this.transports, that.transports);
    }

    public int hashCode() {
        int result = Objects.hash(this.attestationObject, this.collectedClientData, this.clientExtensions, this.transports);
        result = 31 * result + Arrays.hashCode(this.attestationObjectBytes);
        result = 31 * result + Arrays.hashCode(this.collectedClientDataBytes);
        return result;
    }
}

