/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.webauthn4j.converter.jackson.deserializer.COSEKeyEnvelope;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import java.io.IOException;

public class COSEKeyEnvelopeDeserializer
extends StdDeserializer<COSEKeyEnvelope> {
    public COSEKeyEnvelopeDeserializer() {
        super(COSEKeyEnvelope.class);
    }

    public COSEKeyEnvelope deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        COSEKey coseKey = (COSEKey)ctxt.readValue(p, COSEKey.class);
        int length = (int)p.getCurrentLocation().getByteOffset();
        return new COSEKeyEnvelope(coseKey, length);
    }
}

