/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientInput;
import com.webauthn4j.data.extension.client.UnknownExtensionClientInput;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationExtensionClientInputDeserializer
extends StdDeserializer<AuthenticationExtensionClientInput<?>> {
    private final transient Logger logger = LoggerFactory.getLogger(AuthenticationExtensionClientInputDeserializer.class);

    public AuthenticationExtensionClientInputDeserializer() {
        super(AuthenticationExtensionClientInput.class);
    }

    public AuthenticationExtensionClientInput<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String name = p.getParsingContext().getCurrentName();
        if (name == null) {
            name = p.getParsingContext().getParent().getCurrentName();
        }
        DeserializationConfig config = ctxt.getConfig();
        AnnotatedClass annotatedClass = AnnotatedClassResolver.resolveWithoutSuperTypes((MapperConfig)config, AuthenticationExtensionClientInput.class);
        Collection namedTypes = config.getSubtypeResolver().collectAndResolveSubtypesByClass((MapperConfig)config, annotatedClass);
        for (NamedType namedType : namedTypes) {
            if (!Objects.equals(namedType.getName(), name)) continue;
            return (AuthenticationExtensionClientInput)ctxt.readValue(p, namedType.getType());
        }
        this.logger.warn("Unknown extension '{}' is contained.", (Object)name);
        return (AuthenticationExtensionClientInput)ctxt.readValue(p, UnknownExtensionClientInput.class);
    }
}

