/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.model.tokenization;

import java.util.List;

public class TokenizationRequest {
    String model;
    List<String> text;
    String user;

    public TokenizationRequest(String model, List<String> text) {
        this.model = model;
        this.text = text;
    }

    public TokenizationRequest(String model, List<String> text, String user) {
        this.model = model;
        this.text = text;
        this.user = user;
    }

    public TokenizationRequest() {
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public List<String> getText() {
        return this.text;
    }

    public void setText(List<String> text) {
        this.text = text;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String toString() {
        return "TokenizationRequest{model='" + this.model + '\'' + ", text=" + this.text + ", user='" + this.user + '\'' + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String model;
        private List<String> text;
        private String user;

        private Builder() {
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder text(List<String> text) {
            this.text = text;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public TokenizationRequest build() {
            TokenizationRequest tokenizationRequest = new TokenizationRequest();
            tokenizationRequest.setModel(this.model);
            tokenizationRequest.setText(this.text);
            tokenizationRequest.setUser(this.user);
            return tokenizationRequest;
        }
    }
}

