/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.model.responses.tool.mcp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.volcengine.ark.runtime.model.responses.tool.mcp.MCPToolApprovalFilter;
import java.io.IOException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(using=MCPRequireApprovalSerializer.class)
@JsonDeserialize(using=MCPRequireApprovalDeserializer.class)
public class MCPRequireApproval {
    private String mode;
    private MCPToolApprovalFilter filter;

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public MCPToolApprovalFilter getFilter() {
        return this.filter;
    }

    public void setFilter(MCPToolApprovalFilter filter) {
        this.filter = filter;
    }

    public String toString() {
        return "MCPRequireApproval{mode='" + this.mode + '\'' + ", filter=" + this.filter + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String mode;
        private MCPToolApprovalFilter filter;

        private Builder() {
        }

        public Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Builder filter(MCPToolApprovalFilter filter) {
            this.filter = filter;
            return this;
        }

        public MCPRequireApproval build() {
            MCPRequireApproval mCPRequireApproval = new MCPRequireApproval();
            mCPRequireApproval.setMode(this.mode);
            mCPRequireApproval.setFilter(this.filter);
            return mCPRequireApproval;
        }
    }

    static class MCPRequireApprovalDeserializer
    extends JsonDeserializer<MCPRequireApproval> {
        MCPRequireApprovalDeserializer() {
        }

        public MCPRequireApproval deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            if (node.isObject()) {
                MCPToolApprovalFilter toolFilter = (MCPToolApprovalFilter)p.getCodec().treeToValue((TreeNode)node, MCPToolApprovalFilter.class);
                return MCPRequireApproval.builder().filter(toolFilter).build();
            }
            if (node.isTextual()) {
                return MCPRequireApproval.builder().mode(node.asText()).build();
            }
            throw new IOException("Unexpected JSON type for MCPRequireApproval");
        }
    }

    static class MCPRequireApprovalSerializer
    extends JsonSerializer<MCPRequireApproval> {
        MCPRequireApprovalSerializer() {
        }

        public void serialize(MCPRequireApproval value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value.mode != null) {
                gen.writeString(value.mode);
            } else if (value.filter != null) {
                gen.writeObject((Object)value.filter);
            } else {
                gen.writeNull();
            }
        }
    }
}

