/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.model.responses.tool;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.volcengine.ark.runtime.model.responses.tool.FunctionToolChoice;
import java.io.IOException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(using=ResponsesToolChoiceSerializer.class)
@JsonDeserialize(using=ResponsesToolChoiceDeserializer.class)
public class ResponsesToolChoice {
    private String mode;
    private FunctionToolChoice functionToolChoice;

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public FunctionToolChoice getFunctionToolChoice() {
        return this.functionToolChoice;
    }

    public void setFunctionToolChoice(FunctionToolChoice functionToolChoice) {
        this.functionToolChoice = functionToolChoice;
    }

    public String toString() {
        return "ResponsesToolChoice{mode='" + this.mode + '\'' + ", functionToolChoice=" + this.functionToolChoice + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String mode;
        private FunctionToolChoice functionToolChoice;

        public Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Builder functionToolChoice(FunctionToolChoice functionToolChoice) {
            this.functionToolChoice = functionToolChoice;
            return this;
        }

        public ResponsesToolChoice build() {
            ResponsesToolChoice responsesToolChoice = new ResponsesToolChoice();
            responsesToolChoice.setMode(this.mode);
            responsesToolChoice.setFunctionToolChoice(this.functionToolChoice);
            return responsesToolChoice;
        }
    }

    public static class ResponsesToolChoiceDeserializer
    extends JsonDeserializer<ResponsesToolChoice> {
        public ResponsesToolChoice deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            if (node.isTextual()) {
                return ResponsesToolChoice.builder().mode(node.asText()).build();
            }
            if (node.isObject()) {
                FunctionToolChoice functionToolChoice = (FunctionToolChoice)p.getCodec().treeToValue((TreeNode)node, FunctionToolChoice.class);
                return ResponsesToolChoice.builder().functionToolChoice(functionToolChoice).build();
            }
            return null;
        }
    }

    public static class ResponsesToolChoiceSerializer
    extends JsonSerializer<ResponsesToolChoice> {
        public void serialize(ResponsesToolChoice value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value.mode != null) {
                gen.writeString(value.mode);
            } else if (value.functionToolChoice != null) {
                gen.writeObject((Object)value.functionToolChoice);
            } else {
                gen.writeNull();
            }
        }
    }
}

