/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.ast.BlockContent;
import com.vladsch.flexmark.ast.Content;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.SegmentedSequence;
import java.util.ArrayList;
import java.util.List;

public abstract class ContentNode
extends Node
implements Content {
    protected List<BasedSequence> lineSegments = BasedSequence.EMPTY_LIST;

    public ContentNode() {
    }

    public ContentNode(BasedSequence chars) {
        super(chars);
    }

    public ContentNode(BasedSequence chars, List<BasedSequence> lineSegments) {
        super(chars);
        this.lineSegments = lineSegments;
    }

    public ContentNode(List<BasedSequence> lineSegments) {
        this(ContentNode.getSpanningChars(lineSegments), lineSegments);
    }

    public ContentNode(BlockContent blockContent) {
        this(blockContent.getSpanningChars(), blockContent.getLines());
    }

    public void setContent(BasedSequence chars, List<BasedSequence> lineSegments) {
        this.setChars(chars);
        this.lineSegments = lineSegments;
    }

    public void setContent(List<BasedSequence> lineSegments) {
        this.lineSegments = lineSegments;
        this.setChars(this.getSpanningChars());
    }

    public void setContent(BlockContent blockContent) {
        this.setChars(blockContent.getSpanningChars());
        this.lineSegments = blockContent.getLines();
    }

    @Override
    public BasedSequence getSpanningChars() {
        return ContentNode.getSpanningChars(this.lineSegments);
    }

    private static BasedSequence getSpanningChars(List<BasedSequence> lineSegments) {
        return lineSegments.isEmpty() ? BasedSequence.NULL : lineSegments.get(0).baseSubSequence(lineSegments.get(0).getStartOffset(), lineSegments.get(lineSegments.size() - 1).getEndOffset());
    }

    @Override
    public int getLineCount() {
        return this.lineSegments.size();
    }

    @Override
    public BasedSequence getLineChars(int index) {
        return this.lineSegments.get(index);
    }

    @Override
    public List<BasedSequence> getContentLines() {
        return this.lineSegments;
    }

    @Override
    public List<BasedSequence> getContentLines(int startLine, int endLine) {
        return this.lineSegments.subList(startLine, endLine);
    }

    @Override
    public BasedSequence getContentChars() {
        return SegmentedSequence.of(this.lineSegments);
    }

    @Override
    public BasedSequence getContentChars(int startLine, int endLine) {
        return SegmentedSequence.of(this.getContentLines(startLine, endLine));
    }

    public void setContentLines(List<BasedSequence> contentLines) {
        this.lineSegments = contentLines;
    }

    public void setContentLine(int lineIndex, BasedSequence contentLine) {
        ArrayList<BasedSequence> lines = new ArrayList<BasedSequence>(this.lineSegments);
        lines.set(lineIndex, contentLine);
        this.lineSegments = lines;
        this.setCharsFromContent();
    }
}

