/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html2md.converter;

import com.vladsch.flexmark.html2md.converter.HtmlMarkdownWriter;
import com.vladsch.flexmark.html2md.converter.HtmlNodeConverterContext;
import com.vladsch.flexmark.html2md.converter.NodeRenderingHandlerWrapper;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Node;

public abstract class HtmlNodeConverterSubContext
implements HtmlNodeConverterContext {
    protected final HtmlMarkdownWriter markdown;
    NodeRenderingHandlerWrapper<?> renderingHandlerWrapper;
    @Nullable
    Node myRenderingNode;

    public HtmlNodeConverterSubContext(@NotNull HtmlMarkdownWriter markdown) {
        this.markdown = markdown;
        this.myRenderingNode = null;
        this.markdown.setContext(this);
    }

    @Nullable
    public Node getRenderingNode() {
        return this.myRenderingNode;
    }

    public void setRenderingNode(@Nullable Node renderingNode) {
        this.myRenderingNode = renderingNode;
    }

    @Override
    @NotNull
    public HtmlMarkdownWriter getMarkdown() {
        return this.markdown;
    }

    public void flushTo(@NotNull Appendable out, int maxTrailingBlankLines) {
        this.flushTo(out, this.getHtmlConverterOptions().maxBlankLines, maxTrailingBlankLines);
    }

    public void flushTo(@NotNull Appendable out, int maxBlankLines, int maxTrailingBlankLines) {
        this.markdown.line();
        try {
            this.markdown.appendTo(out, maxBlankLines, maxTrailingBlankLines);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

