/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.youtube.embedded.internal;

import com.vladsch.flexmark.ext.youtube.embedded.YouTubeLink;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.options.DataHolder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class YouTubeLinkNodeRenderer
implements NodeRenderer {
    public YouTubeLinkNodeRenderer(DataHolder options) {
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        final YouTubeLinkNodeRenderer self = this;
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(YouTubeLink.class, (CustomNodeRenderer)new CustomNodeRenderer<YouTubeLink>(){

            public void render(YouTubeLink node, NodeRendererContext context, HtmlWriter html) {
                self.render(node, context, html);
            }
        }));
        return set;
    }

    private void render(YouTubeLink node, NodeRendererContext context, HtmlWriter html) {
        if (context.isDoNotRenderLinks()) {
            context.renderChildren((Node)node);
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, (CharSequence)node.getUrl().unescape(), null);
            URL url = null;
            try {
                url = new URL(resolvedLink.getUrl());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (url != null && "youtu.be".equalsIgnoreCase(url.getHost())) {
                html.attr((CharSequence)"src", (CharSequence)("https://www.youtube-nocookie.com/embed" + url.getFile().replace("?t=", "?start=")));
                html.attr((CharSequence)"width", (CharSequence)"560");
                html.attr((CharSequence)"height", (CharSequence)"315");
                html.attr((CharSequence)"class", (CharSequence)"youtube-embedded");
                html.attr((CharSequence)"allowfullscreen", (CharSequence)"true");
                html.attr((CharSequence)"frameborder", (CharSequence)"0");
                html.attr((CharSequence)"allow", (CharSequence)"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture");
                html.srcPos(node.getChars()).withAttr(resolvedLink).tag((CharSequence)"iframe");
                html.tag((CharSequence)"/iframe");
            } else if (resolvedLink.getUrl().contains("www.youtube.com/watch")) {
                html.attr((CharSequence)"src", (CharSequence)resolvedLink.getUrl().replace("watch?v=".toLowerCase(), "embed/"));
                html.attr((CharSequence)"width", (CharSequence)"420");
                html.attr((CharSequence)"height", (CharSequence)"315");
                html.attr((CharSequence)"class", (CharSequence)"youtube-embedded");
                html.attr((CharSequence)"allowfullscreen", (CharSequence)"true");
                html.attr((CharSequence)"frameborder", (CharSequence)"0");
                html.srcPos(node.getChars()).withAttr(resolvedLink).tag((CharSequence)"iframe");
                html.tag((CharSequence)"/iframe");
            } else {
                html.attr((CharSequence)"href", (CharSequence)resolvedLink.getUrl());
                if (node.getTitle().isNotNull()) {
                    html.attr((CharSequence)"title", (CharSequence)node.getTitle().unescape());
                }
                html.srcPos(node.getChars()).withAttr(resolvedLink).tag((CharSequence)"a");
                context.renderChildren((Node)node);
                html.tag((CharSequence)"/a");
            }
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer create(DataHolder options) {
            return new YouTubeLinkNodeRenderer(options);
        }
    }
}

