/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.resizable.image.internal;

import com.vladsch.flexmark.ext.resizable.image.ResizableImage;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.InlineParserExtension;
import com.vladsch.flexmark.parser.InlineParserExtensionFactory;
import com.vladsch.flexmark.parser.LightInlineParser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResizableImageInlineParserExtension
implements InlineParserExtension {
    public static final Pattern IMAGE_PATTERN = Pattern.compile("\\!\\[([^\\s\\]]*)]\\(([^\\s\\]]+)\\s*=*(\\d*)x*(\\d*)\\)", 2);

    public ResizableImageInlineParserExtension(LightInlineParser inlineParser) {
    }

    public void finalizeDocument(@NotNull InlineParser inlineParser) {
    }

    public void finalizeBlock(@NotNull InlineParser inlineParser) {
    }

    public boolean parse(@NotNull LightInlineParser inlineParser) {
        BasedSequence[] matches;
        int index = inlineParser.getIndex();
        char c = inlineParser.getInput().safeCharAt(index + 1);
        if (c == '[' && (matches = inlineParser.matchWithGroups(IMAGE_PATTERN)) != null) {
            inlineParser.flushTextNode();
            BasedSequence text = matches[1];
            BasedSequence source = matches[2];
            BasedSequence width = matches[3];
            BasedSequence height = matches[4];
            ResizableImage image = new ResizableImage(text, source, width, height);
            inlineParser.getBlock().appendChild((Node)image);
            return true;
        }
        return false;
    }

    public static class Factory
    implements InlineParserExtensionFactory {
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @NotNull
        public CharSequence getCharacters() {
            return "!";
        }

        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        @NotNull
        public InlineParserExtension apply(@NotNull LightInlineParser lightInlineParser) {
            return new ResizableImageInlineParserExtension(lightInlineParser);
        }

        public boolean affectsGlobalScope() {
            return false;
        }
    }
}

