/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.macros.internal;

import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.NodeVisitor;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.VisitHandler;
import com.vladsch.flexmark.ast.Visitor;
import com.vladsch.flexmark.ext.macros.MacroDefinitionBlock;
import com.vladsch.flexmark.ext.macros.MacroReference;
import com.vladsch.flexmark.ext.macros.MacrosExtension;
import com.vladsch.flexmark.ext.macros.internal.MacroDefinitionRepository;
import com.vladsch.flexmark.ext.macros.internal.MacrosOptions;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.PhasedNodeRenderer;
import com.vladsch.flexmark.html.renderer.RenderingPhase;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashSet;
import java.util.Set;

public class MacrosNodeRenderer
implements PhasedNodeRenderer {
    private final MacrosOptions options;
    final MacroDefinitionRepository repository;
    private boolean recheckUndefinedReferences;

    public MacrosNodeRenderer(DataHolder options) {
        this.options = new MacrosOptions(options);
        this.repository = (MacroDefinitionRepository)((Object)options.get(MacrosExtension.MACRO_DEFINITIONS));
        this.recheckUndefinedReferences = (Boolean)HtmlRenderer.RECHECK_UNDEFINED_REFERENCES.getFrom(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(MacroReference.class, (CustomNodeRenderer)new CustomNodeRenderer<MacroReference>(){

            public void render(MacroReference node, NodeRendererContext context, HtmlWriter html) {
                MacrosNodeRenderer.this.render(node, context, html);
            }
        }));
        set.add(new NodeRenderingHandler(MacroDefinitionBlock.class, (CustomNodeRenderer)new CustomNodeRenderer<MacroDefinitionBlock>(){

            public void render(MacroDefinitionBlock node, NodeRendererContext context, HtmlWriter html) {
                MacrosNodeRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    public Set<RenderingPhase> getRenderingPhases() {
        HashSet<RenderingPhase> set = new HashSet<RenderingPhase>();
        set.add(RenderingPhase.BODY_TOP);
        return set;
    }

    public void renderDocument(NodeRendererContext context, HtmlWriter html, Document document, RenderingPhase phase) {
        if (phase == RenderingPhase.BODY_TOP && this.recheckUndefinedReferences) {
            final boolean[] hadNewFootnotes = new boolean[]{false};
            NodeVisitor visitor = new NodeVisitor(new VisitHandler[]{new VisitHandler(MacroReference.class, (Visitor)new Visitor<MacroReference>(){

                public void visit(MacroReference node) {
                    MacroDefinitionBlock macroDefinitionBlock;
                    if (!node.isDefined() && (macroDefinitionBlock = node.getMacroDefinitionBlock(MacrosNodeRenderer.this.repository)) != null) {
                        MacrosNodeRenderer.this.repository.addMacrosReference(macroDefinitionBlock, node);
                        node.setMacroDefinitionBlock(macroDefinitionBlock);
                        hadNewFootnotes[0] = true;
                    }
                }
            })});
            visitor.visit((Node)document);
            if (hadNewFootnotes[0]) {
                this.repository.resolveMacrosOrdinals();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void render(MacroReference node, NodeRendererContext context, HtmlWriter html) {
        MacroDefinitionBlock macroDefinitionBlock = (MacroDefinitionBlock)((Object)this.repository.get(this.repository.normalizeKey((CharSequence)node.getText())));
        if (macroDefinitionBlock != null) {
            if (macroDefinitionBlock.hasChildren() && !macroDefinitionBlock.isInExpansion()) {
                try {
                    macroDefinitionBlock.setInExpansion(true);
                    Node child = macroDefinitionBlock.getFirstChild();
                    if (child instanceof Paragraph && child == macroDefinitionBlock.getLastChild()) {
                        if (this.options.sourceWrapMacroReferences) {
                            html.srcPos(node.getChars()).withAttr(AttributablePart.NODE_POSITION).tag((CharSequence)"span");
                            context.renderChildren(child);
                            html.tag((CharSequence)"/span");
                        }
                        context.renderChildren(child);
                    }
                    if (this.options.sourceWrapMacroReferences) {
                        ((HtmlWriter)((HtmlWriter)html.srcPos(node.getChars()).withAttr(AttributablePart.NODE_POSITION).tag((CharSequence)"div")).indent()).line();
                        context.renderChildren((Node)macroDefinitionBlock);
                        ((HtmlWriter)html.unIndent()).tag((CharSequence)"/div");
                    }
                    context.renderChildren((Node)macroDefinitionBlock);
                }
                finally {
                    macroDefinitionBlock.setInExpansion(false);
                }
            }
        } else {
            html.text((CharSequence)node.getChars());
        }
    }

    private void render(MacroDefinitionBlock node, NodeRendererContext context, HtmlWriter html) {
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer create(DataHolder options) {
            return new MacrosNodeRenderer(options);
        }
    }
}

