/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.issues.internal;

import com.vladsch.flexmark.ext.gfm.issues.GfmIssue;
import com.vladsch.flexmark.ext.gfm.issues.internal.GfmIssuesOptions;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashSet;
import java.util.Set;

public class GfmIssuesNodeRenderer
implements NodeRenderer {
    private final GfmIssuesOptions options;

    public GfmIssuesNodeRenderer(DataHolder options) {
        this.options = new GfmIssuesOptions(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(GfmIssue.class, (CustomNodeRenderer)new CustomNodeRenderer<GfmIssue>(){

            public void render(GfmIssue node, NodeRendererContext context, HtmlWriter html) {
                GfmIssuesNodeRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    private void render(GfmIssue node, NodeRendererContext context, HtmlWriter html) {
        if (context.isDoNotRenderLinks()) {
            html.text((CharSequence)node.getChars());
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(this.options.gitHubIssuesUrlRoot).append(this.options.gitHubIssueUrlPrefix).append((CharSequence)node.getText()).append(this.options.gitHubIssueUrlSuffix);
            ((HtmlWriter)html.srcPos(node.getChars()).attr((CharSequence)"href", (CharSequence)sb.toString())).withAttr().tag((CharSequence)"a");
            html.raw((CharSequence)this.options.gitHubIssueTextPrefix);
            html.text((CharSequence)node.getChars());
            html.raw((CharSequence)this.options.gitHubIssueTextSuffix);
            html.tag((CharSequence)"/a");
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer create(DataHolder options) {
            return new GfmIssuesNodeRenderer(options);
        }
    }
}

