/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.admonition.internal;

import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.util.Parsing;
import com.vladsch.flexmark.ext.admonition.AdmonitionBlock;
import com.vladsch.flexmark.ext.admonition.internal.AdmonitionOptions;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AdmonitionBlockParser
extends AbstractBlockParser {
    private static final String ADMONITION_START_FORMAT = "^(\\?{3}\\+|\\?{3}|!{3})\\s+(%s)(?:\\s+(%s))?\\s*$";
    final AdmonitionBlock block;
    private final AdmonitionOptions options;
    private final int contentIndent;
    private boolean hadBlankLine;

    AdmonitionBlockParser(AdmonitionOptions options, int contentIndent) {
        this.options = options;
        this.contentIndent = contentIndent;
        this.block = new AdmonitionBlock();
    }

    private int getContentIndent() {
        return this.contentIndent;
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean isContainer() {
        return true;
    }

    public boolean canContain(ParserState state, BlockParser blockParser, Block block) {
        return true;
    }

    public BlockContinue tryContinue(ParserState state) {
        int nonSpaceIndex = state.getNextNonSpaceIndex();
        if (state.isBlank()) {
            this.hadBlankLine = true;
            return BlockContinue.atIndex((int)nonSpaceIndex);
        }
        if (!this.hadBlankLine && this.options.allowLazyContinuation) {
            return BlockContinue.atIndex((int)nonSpaceIndex);
        }
        if (state.getIndent() >= this.options.contentIndent) {
            int contentIndent = state.getColumn() + this.options.contentIndent;
            return BlockContinue.atColumn((int)contentIndent);
        }
        return BlockContinue.none();
    }

    public void closeBlock(ParserState state) {
        this.block.setCharsFromContent();
    }

    static boolean isMarker(ParserState state, int index, boolean inParagraph, boolean inParagraphListItem, AdmonitionOptions options) {
        boolean allowLeadingSpace = options.allowLeadingSpace;
        boolean interruptsParagraph = options.interruptsParagraph;
        boolean interruptsItemParagraph = options.interruptsItemParagraph;
        boolean withLeadSpacesInterruptsItemParagraph = options.withSpacesInterruptsItemParagraph;
        BasedSequence line = state.getLine();
        if (!(inParagraph && !interruptsParagraph || !allowLeadingSpace && state.getIndent() != 0 || inParagraphListItem && !interruptsItemParagraph)) {
            if (inParagraphListItem && !withLeadSpacesInterruptsItemParagraph) {
                return state.getIndent() == 0;
            }
            return state.getIndent() < state.getParsing().CODE_BLOCK_INDENT;
        }
        return false;
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final AdmonitionOptions options;

        BlockFactory(DataHolder options) {
            super(options);
            this.options = new AdmonitionOptions(options);
        }

        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            boolean inParagraphListItem;
            if (state.getIndent() >= 4) {
                return BlockStart.none();
            }
            int nextNonSpace = state.getNextNonSpaceIndex();
            BlockParser matched = matchedBlockParser.getBlockParser();
            boolean inParagraph = matched.isParagraphParser();
            boolean bl = inParagraphListItem = inParagraph && matched.getBlock().getParent() instanceof ListItem && matched.getBlock() == matched.getBlock().getParent().getFirstChild();
            if (AdmonitionBlockParser.isMarker(state, nextNonSpace, inParagraph, inParagraphListItem, this.options)) {
                BasedSequence line = state.getLine();
                BasedSequence trySequence = line.subSequence(nextNonSpace, line.length());
                Parsing parsing = state.getParsing();
                Pattern startPattern = Pattern.compile(String.format(AdmonitionBlockParser.ADMONITION_START_FORMAT, parsing.ATTRIBUTENAME, parsing.LINK_TITLE_STRING));
                Matcher matcher = startPattern.matcher((CharSequence)trySequence);
                if (matcher.find()) {
                    BasedSequence openingMarker = line.subSequence(nextNonSpace + matcher.start(1), nextNonSpace + matcher.end(1));
                    BasedSequence info = line.subSequence(nextNonSpace + matcher.start(2), nextNonSpace + matcher.end(2));
                    BasedSequence titleChars = matcher.group(3) == null ? BasedSequence.NULL : line.subSequence(nextNonSpace + matcher.start(3), nextNonSpace + matcher.end(3));
                    int contentOffset = this.options.contentIndent;
                    AdmonitionBlockParser admonitionBlockParser = new AdmonitionBlockParser(this.options, contentOffset);
                    admonitionBlockParser.block.setOpeningMarker(openingMarker);
                    admonitionBlockParser.block.setInfo(info);
                    admonitionBlockParser.block.setTitleChars(titleChars);
                    return BlockStart.of((BlockParser[])new BlockParser[]{admonitionBlockParser}).atIndex(line.length());
                }
                return BlockStart.none();
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        public Set<Class<? extends CustomBlockParserFactory>> getAfterDependents() {
            return null;
        }

        public Set<Class<? extends CustomBlockParserFactory>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        public BlockParserFactory create(DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

