/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support.exceptions;

import com.vertica.support.IMessageSource;
import com.vertica.support.exceptions.DiagState;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class ErrorException
extends Exception {
    public static final int JDBC_ERROR = 1;
    public static final int DSI_ERROR = 2;
    public static final int MESSAGES_ERROR = 5;
    public static final int COMMUNICATIONS_ERROR = 6;
    public static final int SQLENGINE_ERROR = 7;
    public static final int SUPPORT_CHANNELS = 8;
    public static final String JDBC_COMPONENT_NAME = "JDBC";
    public static final String DSI_COMPONENT_NAME = "JDSI";
    public static final String MESSAGES_COMPONENT_NAME = "JMessages";
    public static final String SQLENGINE_COMPONENT_NAME = "JSQLEngine";
    public static final String DSI_ERROR_MESSAGES = "DSIMessages";
    public static final String JDBC_ERROR_MESSAGES = "JDBCMessages";
    public static final String SQLENGINE_ERROR_MESSAGES = "SQLEngineMessages";
    public static final String SUPPORT_CHANNELS_ERROR_MESSAGES = "messages";
    public static final String JDBCClient_ERROR_MESSAGES = "ClientMessages";
    public static final String SUPPORT_CHANNELS_NAME = "SupportChannels";
    private static final long serialVersionUID = 4070171084841472995L;
    private static final Method s_addSuppressedMethod;
    private static final Method s_getSuppressedMethod;
    protected int m_columnNumber;
    protected int m_rowNumber;
    private DiagState m_diagState;
    private String[] m_msgParams;
    private String m_msgKeyOrText = "";
    private String m_customState;
    private int m_componentId;
    private int m_nativeErrorCode = 0;
    private boolean m_hasPreformattedMessage;
    private boolean m_hasCachedMessage;
    private final List<ErrorException> m_suppressed = s_addSuppressedMethod == null ? Collections.synchronizedList(new ArrayList()) : null;

    public ErrorException(DiagState diagState, int componentId, String msgKey) {
        this(diagState, componentId, msgKey, -1, -1);
    }

    public ErrorException(DiagState diagState, int componentId, String msgKey, int rowNumber, int columnNumber) {
        this.m_diagState = diagState;
        this.m_componentId = componentId;
        this.m_msgKeyOrText = msgKey;
        this.m_rowNumber = rowNumber;
        this.m_columnNumber = columnNumber;
        this.m_hasCachedMessage = false;
    }

    public ErrorException(DiagState diagState, int componentId, String msgKey, int rowNumber, int columnNumber, Throwable cause) {
        super(cause);
        this.m_diagState = diagState;
        this.m_componentId = componentId;
        this.m_msgKeyOrText = msgKey;
        this.m_rowNumber = rowNumber;
        this.m_columnNumber = columnNumber;
        this.m_hasCachedMessage = false;
    }

    public ErrorException(DiagState diagState, int componentId, String msgKey, String[] msgParams) {
        this(diagState, componentId, msgKey, msgParams, -1, -1);
    }

    public ErrorException(DiagState diagState, int componentId, String msgKey, String[] msgParams, int rowNumber, int columnNumber) {
        this.m_diagState = diagState;
        this.m_componentId = componentId;
        this.m_msgParams = msgParams;
        this.m_rowNumber = rowNumber;
        this.m_columnNumber = columnNumber;
        this.m_msgKeyOrText = msgKey;
        this.m_hasCachedMessage = false;
    }

    public ErrorException(DiagState diagState, int componentId, String msgKey, String[] msgParams, int rowNumber, int columnNumber, Throwable cause) {
        super(cause);
        this.m_diagState = diagState;
        this.m_componentId = componentId;
        this.m_msgKeyOrText = msgKey;
        this.m_msgParams = msgParams;
        this.m_rowNumber = rowNumber;
        this.m_columnNumber = columnNumber;
        this.m_hasCachedMessage = false;
    }

    public ErrorException(DiagState diagState, int componentId, String msgKey, String[] msgParams, Throwable cause) {
        this(diagState, componentId, msgKey, msgParams, -1, -1, cause);
    }

    public ErrorException(DiagState diagState, int componentId, String msgKey, Throwable cause) {
        this(diagState, componentId, msgKey, -1, -1, cause);
    }

    public ErrorException(DiagState diagState, String message, int nativeErrorCode) {
        this(diagState, message, nativeErrorCode, -1, -1);
    }

    public ErrorException(DiagState diagState, String message, int nativeErrorCode, int rowNumber, int columnNumber) {
        this(diagState, null, message, nativeErrorCode, rowNumber, columnNumber);
    }

    public ErrorException(DiagState diagState, String sqlState, String message, int nativeErrorCode, int rowNumber, int columnNumber) {
        super(message);
        this.m_diagState = diagState;
        this.m_customState = sqlState;
        this.m_rowNumber = rowNumber;
        this.m_columnNumber = columnNumber;
        this.m_hasPreformattedMessage = true;
        this.m_msgKeyOrText = message;
        this.m_nativeErrorCode = nativeErrorCode;
    }

    public ErrorException(DiagState diagState, String message, int nativeErrorCode, int rowNumber, int columnNumber, Throwable cause) {
        super(message, cause);
        this.m_diagState = diagState;
        this.m_customState = null;
        this.m_rowNumber = rowNumber;
        this.m_columnNumber = columnNumber;
        this.m_hasPreformattedMessage = true;
        this.m_msgKeyOrText = message;
        this.m_nativeErrorCode = nativeErrorCode;
    }

    public ErrorException(DiagState diagState, String message, int nativeErrorCode, Throwable cause) {
        this(diagState, message, nativeErrorCode, -1, -1, cause);
    }

    public ErrorException(String customState, int componentId, String msgKey) {
        this(customState, componentId, msgKey, -1, -1);
    }

    public ErrorException(String customState, int componentId, String msgKey, int rowNumber, int columnNumber) {
        this.m_customState = customState;
        this.m_componentId = componentId;
        this.m_msgKeyOrText = msgKey;
        this.m_rowNumber = rowNumber;
        this.m_columnNumber = columnNumber;
        this.m_hasCachedMessage = false;
    }

    public ErrorException(String customState, int componentId, String msgKey, int rowNumber, int columnNumber, Throwable cause) {
        super(cause);
        this.m_customState = customState;
        this.m_componentId = componentId;
        this.m_msgKeyOrText = msgKey;
        this.m_rowNumber = rowNumber;
        this.m_columnNumber = columnNumber;
        this.m_hasCachedMessage = false;
    }

    public ErrorException(String customState, int componentId, String msgKey, String[] msgParams) {
        this(customState, componentId, msgKey, msgParams, -1, -1);
    }

    public ErrorException(String customState, int componentId, String msgKey, String[] msgParams, int rowNumber, int columnNumber) {
        this.m_customState = customState;
        this.m_componentId = componentId;
        this.m_msgKeyOrText = msgKey;
        this.m_msgParams = msgParams;
        this.m_rowNumber = rowNumber;
        this.m_columnNumber = columnNumber;
        this.m_hasCachedMessage = false;
    }

    public ErrorException(String customState, int componentId, String msgKey, String[] msgParams, int rowNumber, int columnNumber, Throwable cause) {
        super(cause);
        this.m_customState = customState;
        this.m_componentId = componentId;
        this.m_msgKeyOrText = msgKey;
        this.m_msgParams = msgParams;
        this.m_rowNumber = rowNumber;
        this.m_columnNumber = columnNumber;
        this.m_hasCachedMessage = false;
    }

    public ErrorException(String customState, int componentId, String msgKey, String[] msgParams, Throwable cause) {
        this(customState, componentId, msgKey, msgParams, -1, -1, cause);
    }

    public ErrorException(String customState, int componentId, String msgKey, Throwable cause) {
        this(customState, componentId, msgKey, -1, -1, cause);
    }

    public ErrorException(String customState, String message, int nativeErrorCode) {
        this(customState, message, nativeErrorCode, -1, -1);
    }

    public ErrorException(String customState, String message, int nativeErrorCode, int rowNumber, int columnNumber) {
        super(message);
        this.m_diagState = DiagState.DIAG_GENERAL_ERROR;
        this.m_customState = customState;
        this.m_rowNumber = rowNumber;
        this.m_columnNumber = columnNumber;
        this.m_hasPreformattedMessage = true;
        this.m_msgKeyOrText = message;
        this.m_nativeErrorCode = nativeErrorCode;
    }

    public ErrorException(String customState, String message, int nativeErrorCode, int rowNumber, int columnNumber, Throwable cause) {
        super(message, cause);
        this.m_diagState = DiagState.DIAG_GENERAL_ERROR;
        this.m_customState = customState;
        this.m_rowNumber = rowNumber;
        this.m_columnNumber = columnNumber;
        this.m_hasPreformattedMessage = true;
        this.m_msgKeyOrText = message;
        this.m_nativeErrorCode = nativeErrorCode;
    }

    public ErrorException(String customState, String message, int nativeErrorCode, Throwable cause) {
        this(customState, message, nativeErrorCode, -1, -1, cause);
    }

    public int getColumnNumber() {
        return this.m_columnNumber;
    }

    public String getCustomState() {
        return this.m_customState;
    }

    public DiagState getDiagState() {
        return this.m_diagState;
    }

    @Override
    public String getLocalizedMessage() {
        return this.m_msgKeyOrText;
    }

    @Override
    public String getMessage() {
        assert (this.m_hasCachedMessage || this.m_hasPreformattedMessage);
        return this.m_msgKeyOrText;
    }

    public String getMessage(IMessageSource messageSource, Locale locale) {
        if (this.m_hasCachedMessage || this.m_hasPreformattedMessage) {
            return this.m_msgKeyOrText;
        }
        this.loadMessage(messageSource, locale);
        return this.m_msgKeyOrText;
    }

    public String getMessageKeyOrText() {
        return this.m_msgKeyOrText;
    }

    public String[] getMessageParams() {
        return this.m_msgParams;
    }

    public int getNativeErrorCode(IMessageSource messageSource, Locale locale) {
        if (this.m_hasCachedMessage || this.m_hasPreformattedMessage) {
            return this.m_nativeErrorCode;
        }
        this.loadMessage(messageSource, locale);
        return this.m_nativeErrorCode;
    }

    public int getRowNumber() {
        return this.m_rowNumber;
    }

    public boolean hasCustomState() {
        return null != this.m_customState;
    }

    public boolean hasMessageParams() {
        return null != this.m_msgParams;
    }

    public boolean hasPreformattedMessage() {
        return this.m_hasPreformattedMessage;
    }

    public void loadMessage(IMessageSource messageSource, Locale locale) {
        if (this.m_hasPreformattedMessage || this.m_hasCachedMessage) {
            return;
        }
        if (null == messageSource) {
            this.m_msgKeyOrText = "Cannot create a message with a null message source.";
            return;
        }
        String message = null;
        message = this.hasMessageParams() ? messageSource.loadMessage(locale, this.m_componentId, this.m_msgKeyOrText, this.m_msgParams) : messageSource.loadMessage(locale, this.m_componentId, this.m_msgKeyOrText);
        this.m_hasCachedMessage = true;
        this.m_msgKeyOrText = message;
        this.loadNativeErrCode();
    }

    public void loadMessage(IMessageSource messageSource, Locale locale, boolean isConcatVendor, boolean isConcatComponent) {
        if (this.m_hasPreformattedMessage || this.m_hasCachedMessage) {
            return;
        }
        if (null == messageSource) {
            String msg;
            this.m_msgKeyOrText = msg = "Error retrieving the error message for " + this.m_msgKeyOrText;
            return;
        }
        String message = null;
        message = this.hasMessageParams() ? messageSource.loadMessage(locale, this.m_componentId, this.m_msgKeyOrText, isConcatVendor, isConcatComponent, (Object[])this.m_msgParams) : messageSource.loadMessage(locale, this.m_componentId, this.m_msgKeyOrText);
        this.m_hasCachedMessage = true;
        this.m_msgKeyOrText = message;
        this.loadNativeErrCode();
    }

    public final void addSuppressedCustom(ErrorException exception) {
        if (s_addSuppressedMethod != null) {
            try {
                s_addSuppressedMethod.invoke((Object)this, exception);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            if (exception == null) {
                throw null;
            }
            this.m_suppressed.add(exception);
        }
    }

    public final ErrorException[] getSuppressedCustom() {
        Throwable[] suppressed;
        if (s_getSuppressedMethod == null) {
            return this.m_suppressed.toArray(new ErrorException[this.m_suppressed.size()]);
        }
        try {
            suppressed = (Throwable[])s_getSuppressedMethod.invoke((Object)this, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ArrayList<ErrorException> filtered = new ArrayList<ErrorException>(suppressed.length);
        for (Throwable t : suppressed) {
            if (!(t instanceof ErrorException)) continue;
            filtered.add((ErrorException)t);
        }
        return filtered.toArray(new ErrorException[filtered.size()]);
    }

    private void loadNativeErrCode() {
        assert (this.m_hasCachedMessage || this.m_hasPreformattedMessage);
        int indexOfOpeningParen = this.m_msgKeyOrText.indexOf(40);
        int indexOfClosingParen = this.m_msgKeyOrText.indexOf(41);
        if (-1 != indexOfOpeningParen && -1 != indexOfClosingParen && indexOfClosingParen > indexOfOpeningParen) {
            String errorCode = this.m_msgKeyOrText.substring(++indexOfOpeningParen, indexOfClosingParen);
            try {
                this.m_nativeErrorCode = Integer.parseInt(errorCode);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    static {
        Method tempAdd = null;
        Method tempGet = null;
        try {
            tempAdd = Throwable.class.getMethod("addSuppressed", Throwable.class);
            tempAdd.setAccessible(true);
            tempGet = Throwable.class.getMethod("getSuppressed", new Class[0]);
            tempGet.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        s_addSuppressedMethod = tempAdd;
        s_getSuppressedMethod = tempGet;
    }
}

