/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.kv;

import com.vertica.jdbc.kv.OutputColumn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ProjectionMetadata {
    String schema;
    String table;
    String name;
    boolean isSegmented;
    private boolean complete;
    int offset = -1;
    private List<ProjectionColumnMetadata> segColumns;
    private List<ProjectionColumnMetadata> sortColumns;
    private List<ProjectionColumnMetadata> allColumns;
    private Map<String, String> tableColToProjCol;
    List<SegmentMetadata> segments;
    String[] buddies;

    ProjectionMetadata(String string, String string2, String string3, boolean bl) {
        this.schema = string.toLowerCase();
        this.table = string2.toLowerCase();
        this.name = string3.toLowerCase();
        this.isSegmented = bl;
        this.segments = new ArrayList<SegmentMetadata>();
        this.allColumns = new ArrayList<ProjectionColumnMetadata>();
    }

    void addSegment(String string, long l, long l2) {
        if (this.complete) {
            throw new IllegalStateException("Projection is complete. Cannot add new segments.");
        }
        this.segments.add(new SegmentMetadata(string, l, l2));
    }

    void addColumn(String string, String string2, int n, int n2) {
        if (this.complete) {
            throw new IllegalStateException("Projection is complete. Cannot add new columns.");
        }
        this.allColumns.add(new ProjectionColumnMetadata(string, string2, n, n2));
    }

    void markComplete() {
        this.complete = true;
        this.segColumns = new ArrayList<ProjectionColumnMetadata>();
        for (ProjectionColumnMetadata projectionColumnMetadata : this.allColumns) {
            if (!projectionColumnMetadata.inSegKey) continue;
            this.segColumns.add(projectionColumnMetadata);
        }
        Collections.sort(this.segColumns, ProjColBySegOrder.sort);
        this.sortColumns = new ArrayList<ProjectionColumnMetadata>();
        for (ProjectionColumnMetadata projectionColumnMetadata : this.allColumns) {
            if (!projectionColumnMetadata.inSort) continue;
            this.sortColumns.add(projectionColumnMetadata);
        }
        Collections.sort(this.sortColumns, ProjColBySortOrder.sort);
        Collections.sort(this.segments);
        this.tableColToProjCol = new HashMap<String, String>();
        for (ProjectionColumnMetadata projectionColumnMetadata : this.allColumns) {
            this.tableColToProjCol.put(projectionColumnMetadata.nameInTable, projectionColumnMetadata.nameInProj);
        }
    }

    String getNodeFor(long l) {
        if (this.segments.size() == 1) {
            return this.segments.get((int)0).node;
        }
        int n = Collections.binarySearch(this.segments, new SegmentMetadata("", 0L, l &= 0xFFFFFFFFL));
        if (n < 0) {
            n = -(n + 1);
        }
        if (n == this.segments.size()) {
            n = 0;
        }
        return this.segments.get((int)n).node;
    }

    String[] getAllNodes() {
        String[] stringArray = new String[this.segments.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.segments.get((int)i).node;
        }
        return stringArray;
    }

    String getProjColName(String string) {
        if (!this.complete) {
            throw new IllegalStateException("Projection not marked complete; table column to projection column mapping not computed.");
        }
        return this.tableColToProjCol.get(string);
    }

    boolean canServiceQuery(Set<String> set, List<OutputColumn> list) {
        HashSet<String> hashSet = new HashSet<String>(set);
        for (ProjectionColumnMetadata object : this.segColumns) {
            if (!set.contains(object.nameInTable)) {
                return false;
            }
            hashSet.remove(object.nameInTable);
        }
        for (OutputColumn outputColumn : list) {
            if (outputColumn.isExpr) continue;
            hashSet.add(outputColumn.colOrExpr);
        }
        for (String string : hashSet) {
            if (this.tableColToProjCol.containsKey(string)) continue;
            return false;
        }
        return true;
    }

    public int calculateRank(Set<String> set) {
        int n = 0;
        for (ProjectionColumnMetadata projectionColumnMetadata : this.sortColumns) {
            if (!set.contains(projectionColumnMetadata.nameInTable)) break;
            ++n;
        }
        return 100 * n + (this.isSegmented ? 1 : 0);
    }

    public List<ProjectionColumnMetadata> getSegmentationColumns() {
        if (!this.complete) {
            throw new IllegalStateException("Projection not marked complete; segmentation columns not computed.");
        }
        return this.segColumns;
    }

    public List<ProjectionColumnMetadata> getSortColumns() {
        if (!this.complete) {
            throw new IllegalStateException("Projection not marked complete; sort columns not computed.");
        }
        return this.sortColumns;
    }

    public List<ProjectionColumnMetadata> getColumns() {
        if (!this.complete) {
            throw new IllegalStateException("Projection not marked complete; columns not computed.");
        }
        return this.allColumns;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.schema);
        stringBuilder.append(".");
        stringBuilder.append(this.name);
        stringBuilder.append(" (");
        stringBuilder.append(this.table);
        stringBuilder.append(") (");
        for (ProjectionColumnMetadata projectionColumnMetadata : this.allColumns) {
            stringBuilder.append(projectionColumnMetadata.toString());
            stringBuilder.append(" ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    static class ProjColBySegOrder
    implements Comparator<ProjectionColumnMetadata> {
        static ProjColBySegOrder sort = new ProjColBySegOrder();

        ProjColBySegOrder() {
        }

        @Override
        public int compare(ProjectionColumnMetadata projectionColumnMetadata, ProjectionColumnMetadata projectionColumnMetadata2) {
            return projectionColumnMetadata.ordinalInSeg < projectionColumnMetadata2.ordinalInSeg ? -1 : (projectionColumnMetadata.ordinalInSeg > projectionColumnMetadata2.ordinalInSeg ? 1 : 0);
        }
    }

    static class ProjColBySortOrder
    implements Comparator<ProjectionColumnMetadata> {
        static ProjColBySortOrder sort = new ProjColBySortOrder();

        ProjColBySortOrder() {
        }

        @Override
        public int compare(ProjectionColumnMetadata projectionColumnMetadata, ProjectionColumnMetadata projectionColumnMetadata2) {
            return projectionColumnMetadata.ordinalInSort < projectionColumnMetadata2.ordinalInSort ? -1 : (projectionColumnMetadata.ordinalInSort > projectionColumnMetadata2.ordinalInSort ? 1 : 0);
        }
    }

    static class ProjectionColumnMetadata {
        String nameInProj;
        String nameInTable;
        boolean inSegKey;
        boolean inSort;
        int ordinalInSeg;
        int ordinalInSort;

        ProjectionColumnMetadata(String string, String string2, int n, int n2) {
            this.nameInTable = string.toLowerCase();
            this.nameInProj = string2.toLowerCase();
            this.inSegKey = n != Integer.MAX_VALUE;
            this.ordinalInSeg = n;
            this.ordinalInSort = n2;
            this.inSort = n2 != Integer.MAX_VALUE;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            stringBuilder.append(this.nameInProj);
            if (!this.nameInProj.equals(this.nameInTable)) {
                stringBuilder.append("(");
                stringBuilder.append(this.nameInTable);
                stringBuilder.append(")");
            }
            if (this.inSegKey) {
                stringBuilder.append(" seg #" + this.ordinalInSeg);
            }
            if (this.inSort) {
                stringBuilder.append(" sort #" + this.ordinalInSort);
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    static class SegmentMetadata
    implements Comparable<SegmentMetadata> {
        String node;
        long low;
        long high;

        public SegmentMetadata(String string, long l, long l2) {
            this.node = string;
            this.high = l2;
            this.low = l;
        }

        @Override
        public int compareTo(SegmentMetadata segmentMetadata) {
            return this.high < segmentMetadata.high ? -1 : (this.high > segmentMetadata.high ? 1 : 0);
        }
    }

    static class ProjectionRanking
    implements Comparable<ProjectionRanking> {
        int rank;
        ProjectionMetadata proj;

        public ProjectionRanking(int n, ProjectionMetadata projectionMetadata) {
            this.rank = n;
            this.proj = projectionMetadata;
        }

        @Override
        public int compareTo(ProjectionRanking projectionRanking) {
            return this.rank < projectionRanking.rank ? 1 : (this.rank > projectionRanking.rank ? -1 : 0);
        }

        public String toString() {
            return this.proj.toString() + " Rank: " + this.rank;
        }
    }
}

