/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.hybrid;

import com.vertica.exceptions.ExceptionConverter;
import com.vertica.support.RebrandingUtilities;
import com.vertica.utilities.JDBCVersion;
import java.lang.reflect.Constructor;

public class HybridUtilities {
    private HybridUtilities() {
    }

    public static void setExeceptionConverter(JDBCVersion version) {
        switch (version) {
            case JDBC4: 
            case JDBC41: 
            case JDBC42: {
                ExceptionConverter.setInstance(HybridUtilities.createJDBC4ExceptionConverter());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private static ExceptionConverter createJDBC4ExceptionConverter() {
        try {
            Class<?> JDBC4ExceptionConverterClass = Class.forName(HybridUtilities.getJDBC4ExceptionConverterClassName());
            Constructor<?> JDBC4ExceptionConverterConstructor = JDBC4ExceptionConverterClass.getConstructor(new Class[0]);
            Object JDBC4ExceptionConverterObj = JDBC4ExceptionConverterConstructor.newInstance(new Object[0]);
            return (ExceptionConverter)JDBC4ExceptionConverterObj;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static final String getJDBC4ExceptionConverterClassName() {
        return String.format("com.%s.exceptions.jdbc4.JDBC4ExceptionConverter", RebrandingUtilities.getPackageBranding());
    }
}

