/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.core.VConnection;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.jdbc.VerticaConnection;
import com.vertica.jdbc.VerticaConnectionSharedImpl;
import com.vertica.jdbc.VerticaDatabaseErrorInfo;
import com.vertica.jdbc.jdbc42.S42Connection;
import com.vertica.support.LogUtilities;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.util.concurrent.Executor;

public class VerticaJdbc42ConnectionImpl
extends S42Connection
implements VerticaConnection {
    protected VConnection m_vconn;
    private static final SQLPermission SQL_PERMISSION_NETWORK_TIMEOUT = new SQLPermission("setNetworkTimeout");

    protected VerticaJdbc42ConnectionImpl(IConnection iConnection, String string) throws SQLException {
        super(iConnection, string);
        LogUtilities.logFunctionEntrance(iConnection.getConnectionLog(), iConnection, string);
        this.m_vconn = (VConnection)iConnection;
    }

    @Override
    public Object getProperty(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_vconn.getConnectionLog(), string);
        return VerticaConnectionSharedImpl.getInstance().getProperty(this.m_vconn, string);
    }

    @Override
    public void setProperty(String string, Object object) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_vconn.getConnectionLog(), string);
        VerticaConnectionSharedImpl.getInstance().setProperty(this.m_vconn, string, object);
    }

    @Override
    public VerticaDatabaseErrorInfo getLastDatabaseError() {
        LogUtilities.logFunctionEntrance(this.m_vconn.getConnectionLog(), new Object[0]);
        return VerticaConnectionSharedImpl.getInstance().getLastDatabaseError(this.m_vconn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_vconn.getConnectionLog(), new Object[0]);
        this.m_vconn.lock();
        try {
            super.commit();
        }
        finally {
            this.m_vconn.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_vconn.getConnectionLog(), new Object[0]);
        this.m_vconn.lock();
        try {
            super.rollback();
        }
        finally {
            this.m_vconn.unlock();
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SQL_PERMISSION_NETWORK_TIMEOUT);
        }
        try {
            this.m_vconn.setNetworkTimeout(n);
        }
        catch (IOException iOException) {
            throw ExceptionConverter.getInstance().toSQLException(iOException, this.m_vconn.getWarningListener());
        }
    }

    @Override
    public int getNetworkTimeout() {
        return this.m_vconn.getNetworkTimeout();
    }
}

