/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support.conv;

import com.vertica.support.conv.ConversionResult;
import com.vertica.support.conv.ConverterConstants;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class DateTimeConverter {
    private DateTimeConverter() {
    }

    public static int calculateFractionalSeconds(int fractionalSeconds, int precision) {
        return fractionalSeconds - fractionalSeconds % ConverterConstants.FRACTIONAL_MOD[precision];
    }

    public static String toChar(Date input, long targetLength, Calendar inputCalendar, ConversionResult out_result) {
        inputCalendar.clear();
        inputCalendar.set(1, 0, 1, 0, 0, 0);
        inputCalendar.set(14, 0);
        long zeroTimeAD = inputCalendar.getTimeInMillis();
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        f.setTimeZone(inputCalendar.getTimeZone());
        String result = f.format(input);
        if (input.getTime() < zeroTimeAD) {
            result = '-' + result;
        }
        if ((long)result.length() > targetLength) {
            out_result.setState(ConversionResult.TypeConversionState.STRING_RIGHT_TRUNCATION);
            result = result.substring(0, (int)targetLength);
        } else {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        return result;
    }

    public static String toChar(Timestamp input, long targetLength, int sourcePrecision, Calendar inputCal, ConversionResult out_result) {
        int startIndex;
        char[] buf = new char[]{'-', '0', '0', '0', '0', '0', '0', '0', '0', '0', '-', '0', '0', '-', '0', '0', ' ', '0', '0', ':', '0', '0', ':', '0', '0', '.', '0', '0', '0', '0', '0', '0', '0', '0', '0'};
        inputCal.clear();
        inputCal.setTimeInMillis(input.getTime());
        int year = inputCal.get(1);
        int month = inputCal.get(2) + 1;
        int day = inputCal.get(5);
        int hour = inputCal.get(11);
        int minute = inputCal.get(12);
        int second = inputCal.get(13);
        if (year <= 9999) {
            startIndex = 6;
            buf[6] = (char)(48 + year / 1000);
        } else if (year <= 999999) {
            if (year <= 99999) {
                startIndex = 5;
                buf[5] = (char)(48 + year / 10000 % 10);
                buf[6] = (char)(48 + year / 1000 % 10);
            } else {
                startIndex = 4;
                buf[4] = (char)(48 + year / 100000 % 10);
                buf[5] = (char)(48 + year / 10000 % 10);
                buf[6] = (char)(48 + year / 1000 % 10);
            }
        } else if (year <= 9999999) {
            startIndex = 3;
            buf[3] = (char)(48 + year / 1000000 % 10);
            buf[4] = (char)(48 + year / 100000 % 10);
            buf[5] = (char)(48 + year / 10000 % 10);
            buf[6] = (char)(48 + year / 1000 % 10);
        } else if (year <= 99999999) {
            startIndex = 2;
            buf[2] = (char)(48 + year / 10000000 % 10);
            buf[3] = (char)(48 + year / 1000000 % 10);
            buf[4] = (char)(48 + year / 100000 % 10);
            buf[5] = (char)(48 + year / 10000 % 10);
            buf[6] = (char)(48 + year / 1000 % 10);
        } else {
            startIndex = 1;
            buf[1] = (char)(48 + year / 100000000 % 10);
            buf[2] = (char)(48 + year / 10000000 % 10);
            buf[3] = (char)(48 + year / 1000000 % 10);
            buf[4] = (char)(48 + year / 100000 % 10);
            buf[5] = (char)(48 + year / 10000 % 10);
            buf[6] = (char)(48 + year / 1000 % 10);
        }
        buf[7] = (char)(48 + year / 100 % 10);
        buf[8] = (char)(48 + year / 10 % 10);
        buf[9] = (char)(48 + year % 10);
        buf[11] = (char)(48 + month / 10);
        buf[12] = (char)(48 + month % 10);
        buf[14] = (char)(48 + day / 10);
        buf[15] = (char)(48 + day % 10);
        buf[17] = (char)(48 + hour / 10);
        buf[18] = (char)(48 + hour % 10);
        buf[20] = (char)(48 + minute / 10);
        buf[21] = (char)(48 + minute % 10);
        buf[23] = (char)(48 + second / 10);
        buf[24] = (char)(48 + second % 10);
        inputCal.clear();
        inputCal.set(1, 0, 1, 0, 0, 0);
        inputCal.set(14, 0);
        long zeroTimeAD = inputCal.getTimeInMillis();
        if (input.getTime() < zeroTimeAD) {
            buf[--startIndex] = 45;
        }
        int charCount = 25 - startIndex;
        if (0 < sourcePrecision) {
            int nanos = input.getNanos();
            buf[26] = (char)(48 + nanos / 100000000);
            buf[27] = (char)(48 + nanos / 10000000 % 10);
            buf[28] = (char)(48 + nanos / 1000000 % 10);
            buf[29] = (char)(48 + nanos / 100000 % 10);
            buf[30] = (char)(48 + nanos / 10000 % 10);
            buf[31] = (char)(48 + nanos / 1000 % 10);
            buf[32] = (char)(48 + nanos / 100 % 10);
            buf[33] = (char)(48 + nanos / 10 % 10);
            buf[34] = (char)(48 + nanos % 10);
            charCount = 26 + sourcePrecision - startIndex;
        }
        if ((long)charCount > targetLength) {
            out_result.setState(ConversionResult.TypeConversionState.STRING_RIGHT_TRUNCATION);
            charCount = (int)targetLength;
        } else {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        String result = new String(buf, startIndex, charCount);
        return result;
    }

    public static String toChar(Time input, long targetLength, int sourcePrecision, Calendar inputCalendar, ConversionResult out_result) {
        assert (sourcePrecision >= 0) : "Negative source precision.";
        char[] buf = new char[]{'0', '0', ':', '0', '0', ':', '0', '0', '.', '0', '0', '0'};
        inputCalendar.clear();
        inputCalendar.setTimeInMillis(input.getTime());
        inputCalendar.set(1970, 0, 1);
        int hour = inputCalendar.get(11);
        int minute = inputCalendar.get(12);
        int second = inputCalendar.get(13);
        int millis = inputCalendar.get(14);
        buf[0] = (char)(48 + hour / 10);
        buf[1] = (char)(48 + hour % 10);
        buf[3] = (char)(48 + minute / 10);
        buf[4] = (char)(48 + minute % 10);
        buf[6] = (char)(48 + second / 10);
        buf[7] = (char)(48 + second % 10);
        for (int i = 11; i > 8; --i) {
            buf[i] = (char)(48 + millis % 10);
            millis /= 10;
        }
        if (0 >= sourcePrecision) {
            sourcePrecision = -1;
        } else if (3 < sourcePrecision) {
            sourcePrecision = 3;
        }
        int charCount = 9 + sourcePrecision;
        if ((long)charCount <= targetLength) {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            charCount = (int)targetLength;
            out_result.setState(ConversionResult.TypeConversionState.STRING_RIGHT_TRUNCATION);
        }
        String result = new String(buf, 0, charCount);
        return result;
    }

    public static Date toDate(Timestamp source, Calendar cal, ConversionResult cr) {
        cal.clear();
        cal.setTimeInMillis(source.getTime());
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cr.setState(ConversionResult.TypeConversionState.SUCCESS);
        return new Date(cal.getTimeInMillis());
    }

    public static Time toTime(Timestamp input, Calendar cal, int outputPrecision, ConversionResult cr) {
        assert (outputPrecision >= 0) : "negative precision";
        cal.clear();
        cal.setTimeInMillis(input.getTime());
        if (cal instanceof GregorianCalendar) {
            cal.set(0, 1);
        }
        cal.set(1970, 0, 1);
        int nanos = input.getNanos();
        int diff = nanos % ConverterConstants.FRACTIONAL_MOD[Math.min(outputPrecision, 3)];
        if (0 != diff) {
            cr.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
        } else {
            cr.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        cal.set(14, (nanos - diff) / 1000000);
        return new Time(cal.getTimeInMillis());
    }

    public static Time toTime(Time input, ConversionResult out_result, int outputPrecision, Calendar outputCalendar) {
        assert (outputPrecision >= 0);
        outputCalendar.clear();
        outputCalendar.setTimeInMillis(input.getTime());
        outputCalendar.set(1970, 0, 1);
        int millis = outputCalendar.get(14);
        int outMillis = millis - millis % ConverterConstants.MILLIS_MOD[Math.min(outputPrecision, 3)];
        outputCalendar.set(14, outMillis);
        if (millis != outMillis) {
            out_result.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
        } else {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        Time result = new Time(outputCalendar.getTimeInMillis());
        return result;
    }

    public static Timestamp toTimestamp(Date input, ConversionResult out_result, Calendar inputCalendar) {
        inputCalendar.clear();
        inputCalendar.setTimeInMillis(input.getTime());
        inputCalendar.set(11, 0);
        inputCalendar.set(12, 0);
        inputCalendar.set(13, 0);
        inputCalendar.set(14, 0);
        Timestamp result = new Timestamp(inputCalendar.getTimeInMillis());
        result.setNanos(0);
        out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
        return result;
    }

    public static Timestamp toTimestamp(Timestamp input, ConversionResult out_result, int outputPrecision) {
        int outNanos;
        assert (outputPrecision >= 0);
        int nanos = input.getNanos();
        if (nanos != (outNanos = DateTimeConverter.calculateFractionalSeconds(nanos, outputPrecision))) {
            out_result.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
        } else {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        Timestamp result = new Timestamp(input.getTime());
        result.setNanos(outNanos);
        return result;
    }

    public static Timestamp toTimestamp(Time source, ConversionResult cr, Calendar sourceCalendar, int outPrecision) {
        assert (outPrecision >= 0);
        sourceCalendar.clear();
        sourceCalendar.setTimeInMillis(source.getTime());
        sourceCalendar.set(1, 1970);
        sourceCalendar.set(2, 0);
        sourceCalendar.set(5, 1);
        Timestamp result = new Timestamp(sourceCalendar.getTimeInMillis());
        int nanos = result.getNanos();
        int outNanos = DateTimeConverter.calculateFractionalSeconds(nanos, outPrecision);
        if (nanos != outNanos) {
            cr.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
        } else {
            cr.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        return result;
    }
}

