/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support.conv;

import com.vertica.support.conv.ConversionResult;
import com.vertica.support.conv.ConverterConstants;
import com.vertica.support.conv.ExactNumConverter;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ApproxNumConverter {
    private static final double SMALLEST_DOUBLE_GREATER_THAN_NEGATIVE_ONE = -1.0 + Math.ulp(1.0);
    private static final double SBIGINT_MIN = ConverterConstants.SIGNED_BIGINT_MIN.doubleValue();
    private static final double SBIGINT_MAX_PLUS_ONE = ConverterConstants.SIGNED_BIGINT_MAX.doubleValue();
    private static final double UBIGINT_MAX_PLUS_ONE = ConverterConstants.UNSIGNED_BIGINT_MAX.doubleValue();

    private ApproxNumConverter() {
        throw new UnsupportedOperationException();
    }

    public static BigDecimal toBigDecimal(double val, short precision, short scale, ConversionResult out_convRes) {
        if (Double.isNaN(val)) {
            out_convRes.setState(ConversionResult.TypeConversionState.INVALID_DATA);
            return null;
        }
        if (Double.POSITIVE_INFINITY == val) {
            out_convRes.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            return null;
        }
        if (Double.NEGATIVE_INFINITY == val) {
            out_convRes.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            return null;
        }
        return ExactNumConverter.setPrecScale(new BigDecimal(val), precision, scale, out_convRes);
    }

    public static BigInteger toBigInt(double input, boolean isSigned, ConversionResult convResult) {
        double minValue;
        if (Double.isNaN(input)) {
            convResult.setState(ConversionResult.TypeConversionState.INVALID_DATA);
            return null;
        }
        double d = minValue = isSigned ? SBIGINT_MIN : SMALLEST_DOUBLE_GREATER_THAN_NEGATIVE_ONE;
        if (input >= SBIGINT_MAX_PLUS_ONE) {
            if (!isSigned && input < UBIGINT_MAX_PLUS_ONE) {
                convResult.setState(ConversionResult.TypeConversionState.SUCCESS);
                BigDecimal bd = new BigDecimal(input);
                return bd.toBigIntegerExact();
            }
            convResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            return null;
        }
        if (input < minValue) {
            convResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            return null;
        }
        long truncated = (long)input;
        if ((double)truncated == input) {
            convResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            convResult.setState(0.0 < input ? ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN : ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
        }
        return BigInteger.valueOf(truncated);
    }

    public static String toChar(double input, long targetLength, ConversionResult out_result) {
        String result = Double.POSITIVE_INFINITY == input ? "INFINITY" : (Double.NEGATIVE_INFINITY == input ? "-INFINITY" : Double.toString(input));
        if ((long)result.length() <= targetLength) {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            out_result.setState(ConversionResult.TypeConversionState.STRING_RIGHT_TRUNCATION);
            result = result.substring(0, (int)targetLength);
        }
        return result;
    }

    public static float toFloat(double source, ConversionResult res) {
        res.setState(ConversionResult.TypeConversionState.SUCCESS);
        return (float)source;
    }

    public static long toInteger(double input, boolean isSigned, ConversionResult convResult) {
        double maxValue;
        double minValue;
        long result = 0L;
        if (Double.isNaN(input)) {
            convResult.setState(ConversionResult.TypeConversionState.INVALID_DATA);
            return result;
        }
        if (isSigned) {
            minValue = -2.147483648E9;
            maxValue = 2.147483647E9;
        } else {
            minValue = 0.0;
            maxValue = 4.294967295E9;
        }
        result = (long)input;
        if (input > maxValue) {
            if ((long)maxValue == result) {
                convResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
            } else {
                convResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            }
        } else if (input < minValue) {
            if ((long)minValue == result) {
                convResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
            } else {
                convResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            }
        } else if ((double)result == input) {
            convResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            convResult.setState(0.0 < input ? ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN : ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
        }
        return result;
    }

    public static int toSmallInt(double input, boolean isSigned, ConversionResult convResult) {
        double maxValue;
        double minValue;
        int result = 0;
        if (Double.isNaN(input)) {
            convResult.setState(ConversionResult.TypeConversionState.INVALID_DATA);
            return result;
        }
        if (isSigned) {
            minValue = -32768.0;
            maxValue = 32767.0;
        } else {
            minValue = 0.0;
            maxValue = 65535.0;
        }
        result = (int)input;
        if (input > maxValue) {
            if ((int)maxValue == result) {
                convResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
            } else {
                convResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            }
        } else if (input < minValue) {
            if ((int)minValue == result) {
                convResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
            } else {
                convResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            }
        } else if ((double)result == input) {
            convResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            convResult.setState(0.0 < input ? ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN : ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
        }
        return result;
    }

    public static short toTinyInt(double input, boolean isSigned, ConversionResult convResult) {
        double maxValue;
        double minValue;
        int result = 0;
        if (Double.isNaN(input)) {
            convResult.setState(ConversionResult.TypeConversionState.INVALID_DATA);
            return (short)result;
        }
        if (isSigned) {
            minValue = -128.0;
            maxValue = 127.0;
        } else {
            minValue = 0.0;
            maxValue = 255.0;
        }
        result = (int)input;
        if (input > maxValue) {
            if ((int)maxValue == result) {
                convResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
            } else {
                convResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            }
        } else if (input < minValue) {
            if ((int)minValue == result) {
                convResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
            } else {
                convResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            }
        } else if ((double)result == input) {
            convResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            convResult.setState(0.0 < input ? ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN : ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
        }
        return (short)result;
    }
}

