/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.core.utilities;

import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.NumericOverflowException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AttributeDataMap {
    private Map<Integer, Variant> m_map = Collections.synchronizedMap(new HashMap());

    public Enumeration<Integer> getKeysEnum() {
        return Collections.enumeration(this.m_map.keySet());
    }

    public Set<Map.Entry<Integer, Variant>> getEntrySet() {
        return this.m_map.entrySet();
    }

    public Iterator<Integer> getKeysIterator() {
        return this.m_map.keySet().iterator();
    }

    public Variant getProperty(int key) {
        return this.m_map.get(key);
    }

    public boolean isProperty(int key) {
        return this.m_map.containsKey(key);
    }

    public void setProperty(int key, int valuetype, Object value) throws IncorrectTypeException, NumericOverflowException {
        Variant attribute = new Variant(valuetype, value);
        this.m_map.put(key, attribute);
    }

    public void setProperty(int key, Variant value) {
        this.m_map.put(key, value);
    }

    public boolean isEmpty() {
        return this.m_map.isEmpty();
    }

    public void clear() {
        this.m_map.clear();
    }

    public boolean contains(int propKey) {
        return this.m_map.containsKey(propKey);
    }
}

