/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.util.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtility {
    public static final String EMPTY = "";
    public static final String NEWLINE = "\r\n";

    public static boolean isNullOrEmpty(String input) {
        return input == null || EMPTY.equals(input);
    }

    public static String getNullIfEmpty(String input) {
        return EMPTY.equals(input) ? null : input;
    }

    public static String getEmptyIfNull(String input) {
        return input != null ? input : EMPTY;
    }

    public static String repeatChar(char character, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be non-negative");
        }
        char[] c = new char[count];
        for (int x = 0; x < count; ++x) {
            c[x] = character;
        }
        return new String(c);
    }

    public static String padRight(String input, int totalWidth) {
        if (totalWidth < 0) {
            throw new IllegalArgumentException("Total Width must be non-negative.");
        }
        if (totalWidth == 0) {
            return input;
        }
        String format = String.format("%%%ds", -totalWidth);
        return String.format(format, input);
    }

    public static String padLeft(String input, int totalWidth) {
        if (totalWidth < 0) {
            throw new IllegalArgumentException("Total Width must be non-negative.");
        }
        if (totalWidth == 0) {
            return input;
        }
        String format = String.format("%%%ds", totalWidth);
        return String.format(format, input);
    }

    public static int compare(String str1, String str2, boolean ignoreCase) {
        int result = 0;
        if (str1 != null) {
            result = str2 != null ? (ignoreCase ? str1.compareToIgnoreCase(str2) : str1.compareTo(str2)) : 1;
        } else if (str2 != null) {
            result = -1;
        }
        return result;
    }

    public static String join(String separator, String[] value) {
        if (value != null) {
            if (separator == null) {
                separator = EMPTY;
            }
            boolean addSeparator = false;
            StringBuilder builder = new StringBuilder();
            for (String s : value) {
                if (addSeparator) {
                    builder.append(separator);
                }
                if (s != null) {
                    builder.append(s);
                }
                addSeparator = true;
            }
            return builder.toString();
        }
        throw new IllegalArgumentException("Attempted to join the elements of a null String array.");
    }

    public static String[] split(String value, String regex, boolean removeEmptyEntries) {
        if (value != null) {
            if (!removeEmptyEntries) {
                return value.split(regex, -1);
            }
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(value.split(regex, -1)));
            for (int x = list.size() - 1; x >= 0; --x) {
                if (!EMPTY.equals(list.get(x))) continue;
                list.remove(x);
            }
            return list.toArray(new String[0]);
        }
        throw new IllegalArgumentException("Attempted to split a null String.");
    }

    public static byte[] getBytes(String input, String charSet) {
        byte[] bytes = null;
        if (input != null) {
            try {
                bytes = input.getBytes(charSet);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bytes;
    }

    public static final boolean validateGUID(String s) {
        if (StringUtility.isNullOrEmpty(s)) {
            return false;
        }
        Pattern p = Pattern.compile("\\p{XDigit}{32}");
        Matcher m = p.matcher(s);
        return m.matches();
    }

    public static String escapeNewline(String taintedText) {
        if (taintedText == null) {
            return null;
        }
        String cleansedText = taintedText.replace("\n", "\\n");
        cleansedText = cleansedText.replace("\r", "\\r");
        cleansedText = cleansedText.replace("%0D", "%250D");
        cleansedText = cleansedText.replace("%0A", "%250A");
        cleansedText = cleansedText.replace("%0d", "%250d");
        cleansedText = cleansedText.replace("%0a", "%250a");
        return cleansedText;
    }

    public static String unEscapeNewline(String taintedText) {
        if (null == taintedText) {
            return null;
        }
        String cleansedText = taintedText.replace("\\n", "\n");
        cleansedText = cleansedText.replace("\\r", "\r");
        return cleansedText;
    }

    public static boolean isValidApiHostName(String hostName) {
        if (null == hostName || hostName.isEmpty()) {
            return false;
        }
        return hostName.matches("[\\p{Alnum}-\\.]+(\\.veracode\\.[\\p{Alpha}]+)");
    }

    private StringUtility() {
    }
}

