/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.parser.util;

import com.veracode.parser.annotations.Option;
import com.veracode.parser.core.AttributeMemberPair;
import com.veracode.parser.options.CommandLineOptionsBase;
import com.veracode.parser.util.StringUtility;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public final class ReflectionUtil {
    public static String[] getEnumNames(Field member, boolean sorted) {
        String[] names = null;
        if (member != null && member.getType().isEnum()) {
            Enum[] enumElements = (Enum[])member.getType().getEnumConstants();
            names = new String[enumElements.length];
            for (int x = 0; x < enumElements.length; ++x) {
                names[x] = enumElements[x].name();
            }
        }
        if (names != null && sorted) {
            Arrays.sort(names);
        }
        return names;
    }

    public static ArrayList<AttributeMemberPair<Option, Field>> retrieveMemberList(CommandLineOptionsBase options) {
        ArrayList<AttributeMemberPair<Option, Field>> list = new ArrayList<AttributeMemberPair<Option, Field>>();
        if (options != null) {
            Field[] membersInfo;
            for (Field member : membersInfo = options.getClass().getDeclaredFields()) {
                Option attribute;
                if (!ReflectionUtil.isValidMember(member) || (attribute = member.getAnnotation(Option.class)) == null) continue;
                list.add(new AttributeMemberPair<Option, Field>(attribute, member));
            }
        }
        Collections.sort(list, new Comparator<AttributeMemberPair<Option, Field>>(){

            @Override
            public int compare(AttributeMemberPair<Option, Field> x, AttributeMemberPair<Option, Field> y) {
                return StringUtility.compare(x.getLeft().longName(), y.getLeft().longName(), false);
            }
        });
        return list;
    }

    private static boolean isValidMember(Field member) {
        if (member != null) {
            int modifiers = member.getModifiers();
            return !Modifier.isFinal(modifiers) && !Modifier.isStatic(modifiers);
        }
        return false;
    }
}

