/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.parser.core;

import com.veracode.parser.annotations.Option;
import com.veracode.parser.exceptions.ParseException;
import com.veracode.parser.options.CommandLineOptionsBase;
import com.veracode.parser.util.Convert;
import com.veracode.parser.util.StringUtility;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public final class OptionInfo {
    private CommandLineOptionsBase _options;
    private Option _optionAttribute;
    private Field _field;
    private String _shortName;
    private String _longName;
    private Object[] _requiredBy;
    private Object[] _optionalBy;
    private boolean _isInputPath;
    private boolean _isOutputPath;
    private boolean _parseOnce;
    private Object _customDefaultValue;
    private boolean _overridesRules;
    private String _helpText;
    private String _mutuallyExclusiveSet;
    private String _mutuallyInclusiveSet;
    private boolean _isReadOnly;
    private boolean _isRequired;
    private boolean _isDefined;
    private boolean _isMissingArgument;
    private boolean _hasInvalidArgument;
    private boolean _hasIncompatibleArgument;
    private boolean _hasInvalidPath;

    private CommandLineOptionsBase getOptions() {
        return this._options;
    }

    private void setOptions(CommandLineOptionsBase options) {
        this._options = options;
    }

    private Option getOptionAttribute() {
        return this._optionAttribute;
    }

    private void setOptionAttribute(Option optionAttribute) {
        this._optionAttribute = optionAttribute;
    }

    private Field getField() {
        return this._field;
    }

    private void setField(Field field) {
        this._field = field;
    }

    public String getShortName() {
        return this._shortName;
    }

    public void setShortName(String shortName) {
        this._shortName = shortName;
    }

    public String getLongName() {
        return this._longName;
    }

    public void setLongName(String longName) {
        this._longName = longName;
    }

    public Object[] getRequiredBy() {
        return this._requiredBy;
    }

    public void setRequiredBy(Object[] requiredBy) {
        this._requiredBy = requiredBy;
    }

    public Object[] getOptionalBy() {
        return this._optionalBy;
    }

    public void setOptionalBy(Object[] optionalBy) {
        this._optionalBy = optionalBy;
    }

    public boolean getIsInputPath() {
        return this._isInputPath;
    }

    public void setIsInputPath(boolean isInputPath) {
        this._isInputPath = isInputPath;
    }

    public boolean getIsOutputPath() {
        return this._isOutputPath;
    }

    public void setIsOutputPath(boolean isOutputPath) {
        this._isOutputPath = isOutputPath;
    }

    public boolean getParseOnce() {
        return this._parseOnce;
    }

    public void setParseOnce(boolean parseOnce) {
        this._parseOnce = parseOnce;
    }

    private Object getCustomDefaultValue() {
        return this._customDefaultValue;
    }

    private void setCustomDefaultValue(Object customDefaultValue) {
        this._customDefaultValue = customDefaultValue;
    }

    public boolean getOverridesRules() {
        return this._overridesRules;
    }

    public void setOverridesRules(boolean overridesRules) {
        this._overridesRules = overridesRules;
    }

    public String getHelpText() {
        return this._helpText;
    }

    public void setHelpText(String helpText) {
        this._helpText = helpText;
    }

    public String getMutuallyExclusiveSet() {
        return this._mutuallyExclusiveSet;
    }

    public void setMutuallyExclusiveSet(String mutuallyExclusiveSet) {
        this._mutuallyExclusiveSet = mutuallyExclusiveSet;
    }

    public String getMutuallyInclusiveSet() {
        return this._mutuallyInclusiveSet;
    }

    public void setMutuallyInclusiveSet(String mutuallyInclusiveSet) {
        this._mutuallyInclusiveSet = mutuallyInclusiveSet;
    }

    public boolean getIsReadOnly() {
        return this._isReadOnly;
    }

    public void setIsReadOnly(boolean isReadOnly) {
        this._isReadOnly = isReadOnly;
    }

    public boolean getIsRequired() {
        return this._isRequired;
    }

    public void setIsRequired(boolean isRequired) {
        this._isRequired = isRequired;
    }

    public boolean getIsDefined() {
        return this._isDefined;
    }

    public void setIsDefined(boolean isDefined) {
        this._isDefined = isDefined;
    }

    public boolean getIsMissingArgument() {
        return this._isMissingArgument;
    }

    public void setIsMissingArgument(boolean isMissingArgument) {
        this._isMissingArgument = isMissingArgument;
    }

    public boolean getHasInvalidArgument() {
        return this._hasInvalidArgument;
    }

    public void setHasInvalidArgument(boolean hasInvalidArgument) {
        this._hasInvalidArgument = hasInvalidArgument;
    }

    public boolean getHasIncompatibleArgument() {
        return this._hasIncompatibleArgument;
    }

    public void setHasIncompatibleArgument(boolean hasIncompatibleArgument) {
        this._hasIncompatibleArgument = hasIncompatibleArgument;
    }

    public boolean getHasInvalidPath() {
        return this._hasInvalidPath;
    }

    public void setHasInvalidPath(boolean hasInvalidPath) {
        this._hasInvalidPath = hasInvalidPath;
    }

    public Class<?> getMemberType() {
        Class<?> memberType = null;
        if (this._field != null) {
            memberType = this._field.getType();
        }
        return memberType;
    }

    public Object getMemberValue() {
        try {
            Object memberValue = null;
            if (this._field != null) {
                return this._field.get(this._options);
            }
            return memberValue;
        }
        catch (IllegalAccessException e) {
            throw new ParseException(e);
        }
    }

    public Object getDefaultValue() {
        if (this._field != null) {
            return Convert.toDefaultValue(this._field.getType());
        }
        throw new ParseException(new IllegalArgumentException("The field is mandatory\r\nParameter name: field"));
    }

    public boolean hasCustomDefaultValue() {
        return this._customDefaultValue != null && (!(this._customDefaultValue instanceof String) || !"".equals(this._customDefaultValue));
    }

    public boolean hasRequiredBy() {
        return this._requiredBy != null;
    }

    public boolean hasOptionalBy() {
        return this._optionalBy != null;
    }

    public boolean hasBothNames() {
        return this._shortName != null && this._longName != null;
    }

    public boolean isBoolean() {
        return this._field.getType() == Boolean.TYPE;
    }

    public boolean isArray() {
        return this._field.getType().isArray();
    }

    public boolean isList() {
        return List.class.isAssignableFrom(this._field.getType());
    }

    public boolean isNullable() {
        Class<?> type = this._field.getType();
        return type == Character.class || type == Boolean.class || type == Byte.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class;
    }

    public boolean isParsed() {
        Object value = this.getMemberValue();
        return value != null && !value.equals(this.getDefaultValue());
    }

    public void preInitialize() {
        if (this.getParseOnce()) {
            if (this.isParsed()) {
                this.setIsReadOnly(true);
            }
        } else if (this.hasCustomDefaultValue()) {
            this.preInitialize(this.getCustomDefaultValue());
        } else {
            this.preInitialize(this.getDefaultValue());
        }
    }

    private void preInitialize(Object value) {
        try {
            if (value != null) {
                this._field.set(this._options, Convert.changeType((String)value, this._field.getType()));
            }
        }
        catch (Exception e) {
            throw new ParseException(new IllegalArgumentException("Invalid pre-init value.", e));
        }
    }

    public boolean setValue(String value) {
        if (!this.getIsReadOnly()) {
            if (this.isList()) {
                return this.setListValue(value);
            }
            if (this.isNullable()) {
                return this.setNullableValue(value);
            }
            return this.setScalarValue(value);
        }
        return true;
    }

    public boolean setBooleanValue(boolean value) {
        if (!this.getIsReadOnly()) {
            try {
                this._field.set(this._options, value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean setArrayValue(List<String> values) {
        if (!this.getIsReadOnly()) {
            try {
                int i;
                Object array = null;
                Object previousArray = this._field.get(this._options);
                Class<?> elementType = this._field.getType().getComponentType();
                if (previousArray != null) {
                    array = Array.newInstance(elementType, Array.getLength(previousArray) + values.size());
                    for (i = 0; i < Array.getLength(previousArray); ++i) {
                        Array.set(array, i, Array.get(previousArray, i));
                    }
                } else {
                    previousArray = Array.newInstance(elementType, 0);
                    array = Array.newInstance(elementType, values.size());
                }
                for (i = 0; i < values.size(); ++i) {
                    Array.set(array, i + Array.getLength(previousArray), Convert.changeType(values.get(i), elementType));
                }
                this._field.set(this._options, array);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setScalarValue(String value) {
        try {
            if (this._field.getType().isEnum()) {
                Enum enumElement = null;
                for (Enum e : (Enum[])this._field.getType().getEnumConstants()) {
                    if (StringUtility.compare(e.toString(), value, true) != 0) continue;
                    enumElement = e;
                    break;
                }
                if (enumElement == null) return false;
                this._field.set(this._options, enumElement);
                return true;
            } else {
                this._field.set(this._options, Convert.changeType(value, this._field.getType()));
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean setNullableValue(String value) {
        try {
            Class<?> fieldType = this._field.getType();
            this._field.set(this._options, Convert.changeType(value, fieldType));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean setListValue(String value) {
        try {
            ArrayList<String> fieldRef = new ArrayList<String>();
            String[] values = value.split(String.valueOf(' '), -1);
            for (int i = 0; i < values.length; ++i) {
                fieldRef.add(values[i]);
            }
            this._field.set(this._options, fieldRef);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    OptionInfo(CommandLineOptionsBase options, String longName) {
        this._options = options;
        this._longName = longName;
    }

    private OptionInfo(CommandLineOptionsBase options, Option attribute) {
        if (attribute == null) {
            throw new ParseException(new IllegalArgumentException("The attribute is mandatory\r\nParameter name: attribute"));
        }
        this._options = options;
        this._optionAttribute = attribute;
        this._shortName = StringUtility.getNullIfEmpty(attribute.shortName());
        this._longName = StringUtility.getNullIfEmpty(attribute.longName());
        this._helpText = StringUtility.getNullIfEmpty(attribute.helpText());
        this._isRequired = attribute.required();
        this._requiredBy = attribute.requiredBy();
        this._optionalBy = attribute.optionalBy();
        this._isInputPath = attribute.inputPath();
        this._isOutputPath = attribute.outputPath();
        this._parseOnce = attribute.parseOnce();
        this._overridesRules = attribute.overridesRules();
        this._mutuallyExclusiveSet = StringUtility.getNullIfEmpty(attribute.mutuallyExclusiveSet());
        this._mutuallyInclusiveSet = StringUtility.getNullIfEmpty(attribute.mutuallyInclusiveSet());
        this._customDefaultValue = attribute.customDefaultValue();
    }

    OptionInfo(CommandLineOptionsBase options, Option attribute, Field field) {
        this(options, attribute);
        if (field == null) {
            throw new ParseException(new IllegalArgumentException("The field is mandatory\r\nParameter name: field"));
        }
        this._field = field;
    }
}

