/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.parser.core;

import com.veracode.parser.CommandLineParserSettings;
import com.veracode.parser.core.CLineEnumerator;
import com.veracode.parser.core.OptionInfo;
import com.veracode.parser.core.OptionInfoMap;
import com.veracode.parser.core.ParsingIssue;
import com.veracode.parser.enums.ItemKind;
import com.veracode.parser.enums.ParserState;
import com.veracode.parser.enums.ParsingIssueType;
import com.veracode.parser.exceptions.ParseException;
import com.veracode.parser.options.CommandLineOptionsBase;
import com.veracode.parser.util.Convert;
import com.veracode.parser.util.StringUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public final class CLineParser {
    private CommandLineOptionsBase _options;
    private CommandLineParserSettings _settings;
    private OptionInfoMap _optionInfoMap;
    private CLineEnumerator _commandLineEnumerator;
    private boolean _ignoreCustomRules;

    private CommandLineOptionsBase getOptions() {
        return this._options;
    }

    private void setOptions(CommandLineOptionsBase options) {
        this._options = options;
    }

    private CommandLineParserSettings getSettings() {
        return this._settings;
    }

    private void setSettings(CommandLineParserSettings settings) {
        this._settings = settings;
    }

    private OptionInfoMap getOptionInfoMap() {
        return this._optionInfoMap;
    }

    private void setOptionInfoMap(OptionInfoMap optionInfoMap) {
        this._optionInfoMap = optionInfoMap;
    }

    private CLineEnumerator getCommandLineEnumerator() {
        return this._commandLineEnumerator;
    }

    private void setCommandLineEnumerator(CLineEnumerator commandLineEnumerator) {
        this._commandLineEnumerator = commandLineEnumerator;
    }

    private boolean getIgnoreCustomRules() {
        return this._ignoreCustomRules;
    }

    private void setIgnoreCustomRules(boolean ignoreCustomRules) {
        this._ignoreCustomRules = ignoreCustomRules;
    }

    public String getCurrent() {
        return this._commandLineEnumerator.getCurrent();
    }

    public String getNext() {
        return this._commandLineEnumerator.getNext();
    }

    public boolean isLast() {
        return this._commandLineEnumerator.isLast();
    }

    public boolean moveNext() {
        return this._commandLineEnumerator.moveNext();
    }

    public boolean movePrevious() {
        return this._commandLineEnumerator.movePrevious();
    }

    public void reset() {
        this._commandLineEnumerator.reset();
        this._ignoreCustomRules = false;
    }

    public ParserState parseCurrentItem() {
        if (this.getItemKind(this.getCurrent()) == ItemKind.Parameter) {
            return this.processParameter(this.getCurrent());
        }
        return ParserState.NotAParameter;
    }

    private ParserState processParameter(String currentParameter) {
        String[] currentParameterArray = new String[]{currentParameter};
        String[] currentParameterArgumentArray = new String[1];
        this.splitParameter(currentParameterArray, currentParameterArgumentArray);
        currentParameter = currentParameterArray[0];
        String currentParameterArgument = currentParameterArgumentArray[0];
        OptionInfo option = this._optionInfoMap.get(currentParameter);
        if (option != null) {
            option.setIsDefined(true);
            if (!StringUtility.isNullOrEmpty(currentParameterArgument)) {
                return this.processTwoPartParameter(option, currentParameterArgument);
            }
            return this.processOnePartParameter(option);
        }
        OptionInfo unknownOption = new OptionInfo(this._options, currentParameter);
        this.addParsingError(unknownOption, ParsingIssueType.Unknown);
        return this._settings.getIgnoreUnknownCommands() ? ParserState.MoveOnNextElement : ParserState.Failure;
    }

    private void splitParameter(String[] currentParameterArray, String[] currentParameterArgumentArray) {
        String[] parameterArgumentPair = this.getParameterAndArgument(currentParameterArray[0], '=');
        currentParameterArgumentArray[0] = parameterArgumentPair.length == 2 && !StringUtility.isNullOrEmpty(parameterArgumentPair[1]) ? parameterArgumentPair[1] : null;
        currentParameterArray[0] = parameterArgumentPair[0];
    }

    private String[] getParameterAndArgument(String currentParameter, char separator) {
        String currentSwitch = this.getItemSwitch(currentParameter);
        return currentParameter.substring(currentSwitch.length()).split(String.valueOf(separator), 2);
    }

    private ParserState processTwoPartParameter(OptionInfo option, String parameterArgument) {
        if (!option.isBoolean()) {
            boolean valueAssigned = false;
            if (!option.isArray()) {
                valueAssigned = option.setValue(parameterArgument);
                this.processAssignableOption(option, valueAssigned);
                return this.getParserState(valueAssigned, false);
            }
            List<String> nextArguments = this.parseNextArguments();
            nextArguments.add(0, parameterArgument);
            valueAssigned = option.setArrayValue(nextArguments);
            this.processAssignableOption(option, valueAssigned);
            return this.getParserState(valueAssigned, false);
        }
        return ParserState.Failure;
    }

    private ParserState processOnePartParameter(OptionInfo option) {
        if (!option.isBoolean()) {
            if (this.getItemKind(this.getNext()) == ItemKind.Argument && !this.isLast()) {
                boolean valueAssigned = false;
                if (!option.isArray()) {
                    valueAssigned = option.setValue(this.getNext());
                    this.processAssignableOption(option, valueAssigned);
                    return this.getParserState(valueAssigned, true);
                }
                List<String> nextArguments = this.parseNextArguments();
                valueAssigned = option.setArrayValue(nextArguments);
                this.processAssignableOption(option, valueAssigned);
                return this.getParserState(valueAssigned, false);
            }
            option.setIsMissingArgument(true);
            this.addParsingError(option, ParsingIssueType.MissingArgument);
            return ParserState.Failure;
        }
        boolean valueAssigned = option.setBooleanValue(true);
        this.processAssignableOption(option, valueAssigned);
        return this.getParserState(valueAssigned, false);
    }

    private void processAssignableOption(OptionInfo option, boolean valueAssigned) {
        if (!valueAssigned) {
            option.setHasInvalidArgument(true);
            this.addParsingError(option, ParsingIssueType.InvalidArgument);
        } else if (option.getOverridesRules()) {
            this.setIgnoreCustomRules(true);
        }
    }

    private ParserState getParserState(boolean valueAssigned, boolean moveNext) {
        if (valueAssigned) {
            if (moveNext) {
                return ParserState.MoveOnNextElement;
            }
            return ParserState.Success;
        }
        return ParserState.Failure;
    }

    private List<String> parseNextArguments() {
        ArrayList<String> nextArguments = new ArrayList<String>();
        while (this.moveNext() && this.getItemKind(this.getCurrent()) == ItemKind.Argument) {
            nextArguments.add(this.getCurrent());
        }
        if (!this.movePrevious()) {
            throw new ParseException("Move Previous failed.");
        }
        return nextArguments;
    }

    private ItemKind getItemKind(String currentItem) {
        if (this.itemIsInvalid(currentItem)) {
            return ItemKind.Neither;
        }
        if (this.itemHasLongSwitch(currentItem)) {
            return ItemKind.Parameter;
        }
        if (this.itemHasShortSwitch(currentItem)) {
            return ItemKind.Parameter;
        }
        return ItemKind.Argument;
    }

    private String getItemSwitch(String currentItem) {
        String currentSwitch = null;
        if (this.itemHasLongSwitch(currentItem)) {
            currentSwitch = this._options.longSwitch;
        } else if (this.itemHasShortSwitch(currentItem)) {
            currentSwitch = this._options.shortSwitch;
        }
        return currentSwitch;
    }

    private boolean itemIsInvalid(String currentItem) {
        return StringUtility.isNullOrEmpty(currentItem) || currentItem.equals(this._options.shortSwitch) || currentItem.equals(this._options.longSwitch);
    }

    private boolean itemHasLongSwitch(String currentItem) {
        return currentItem.length() > this._options.longSwitch.length() && currentItem.substring(0, this._options.longSwitch.length()).equals(this._options.longSwitch);
    }

    private boolean itemHasShortSwitch(String currentItem) {
        return currentItem.length() > this._options.shortSwitch.length() && currentItem.substring(0, this._options.shortSwitch.length()).equals(this._options.shortSwitch);
    }

    public boolean enforceRules() {
        return (this.enforceMutuallyExclusiveRule() && this.enforceMutuallyInclusiveRule() && this.enforceRequiredRule()) & this.enforceIncompatibleArgumentRules() & this.enforceRequiredByRule() & this.enforceOptionalByRule() & this.enforceValidFilePathRule();
    }

    private boolean enforceOptionalByRule() {
        for (OptionInfo optionInfo : this._optionInfoMap.getNameOptionInfoMap().values()) {
            if (!optionInfo.hasOptionalBy() || optionInfo.getOptionalBy().length <= 0) continue;
            try {
                OptionInfo[] refOptionInfoArray = new OptionInfo[1];
                boolean optionIsOptionalBy = this.getReferencedOptionInfo(optionInfo.getOptionalBy(), refOptionInfoArray);
                OptionInfo refOptionInfo = refOptionInfoArray[0];
                if (!optionIsOptionalBy || optionInfo.getIsRequired() || optionInfo.getIsDefined() || !refOptionInfo.getIsDefined() && !refOptionInfo.isBoolean() || refOptionInfo.getIsMissingArgument() || refOptionInfo.getHasInvalidArgument()) continue;
                this.addParsingInfo(optionInfo, ParsingIssueType.OptionalBy);
            }
            catch (Exception e) {
                throw new ParseException(String.format("OptionAttribute '%s' has an OptionalBy argument with invalid elements.", optionInfo.getLongName()), e);
            }
        }
        return true;
    }

    private boolean enforceRequiredByRule() {
        boolean allRequiredByRulesMet = true;
        for (OptionInfo optionInfo : this._optionInfoMap.getNameOptionInfoMap().values()) {
            if (!optionInfo.hasRequiredBy() || optionInfo.getRequiredBy().length <= 0) continue;
            try {
                OptionInfo[] refOptionInfoArray = new OptionInfo[1];
                boolean optionIsRequiredBy = this.getReferencedOptionInfo(optionInfo.getRequiredBy(), refOptionInfoArray);
                OptionInfo refOptionInfo = refOptionInfoArray[0];
                if (!optionIsRequiredBy || optionInfo.getIsRequired() || optionInfo.getIsDefined() || !refOptionInfo.getIsDefined() && !refOptionInfo.isBoolean() || refOptionInfo.getIsMissingArgument() || refOptionInfo.getHasInvalidArgument() || refOptionInfo.getHasIncompatibleArgument() || !this.isReqByOptByCompatible(optionInfo, refOptionInfo)) continue;
                this.addParsingError(optionInfo, ParsingIssueType.RequiredBy);
                allRequiredByRulesMet = false;
            }
            catch (Exception e) {
                throw new ParseException(String.format("OptionAttribute '%s' has a RequiredBy argument with invalid elements.", optionInfo.getLongName()), e);
            }
        }
        return this.getIgnoreCustomRules() || allRequiredByRulesMet;
    }

    private boolean getReferencedOptionInfo(Object[] optionNamePlusArgsArray, OptionInfo[] refOptionInfoArray) {
        String refName = this.getReferencedOptionName(optionNamePlusArgsArray);
        String[] refNameArray = new String[]{refName};
        boolean flipResult = this.fixReferencedOptionName(refNameArray);
        refOptionInfoArray[0] = this.getReferencedOptionInfo(refNameArray[0]);
        boolean argumentMatchesValue = true;
        if (optionNamePlusArgsArray.length > 1) {
            argumentMatchesValue = false;
            Object parsedValue = refOptionInfoArray[0].getMemberValue();
            Class<?> parsedType = refOptionInfoArray[0].getMemberType();
            for (int x = 1; x < optionNamePlusArgsArray.length; ++x) {
                Object specifiedArg = optionNamePlusArgsArray[x];
                Class<?> specifiedArgType = specifiedArg.getClass();
                if ((specifiedArg = Convert.changeType((String)specifiedArg, parsedType)) != null) {
                    if (!specifiedArg.equals(parsedValue)) continue;
                    argumentMatchesValue = true;
                    continue;
                }
                throw new IllegalArgumentException(String.format("Type mismatch: %s [%s] vs %s [%s]", refNameArray[0], parsedType, optionNamePlusArgsArray[x], specifiedArgType));
            }
        }
        if (flipResult) {
            argumentMatchesValue = !argumentMatchesValue;
        }
        return argumentMatchesValue;
    }

    private String getReferencedOptionName(Object[] optionNamePlusArgsArray) {
        Object refObj = null;
        String refName = null;
        try {
            refObj = optionNamePlusArgsArray[0];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("OptionAttribute's named parameter has an invalid object[] arg.");
        }
        try {
            refName = (String)refObj;
        }
        catch (ClassCastException e) {
            throw new ClassCastException("The first element must be of type System.String.");
        }
        return refName;
    }

    private boolean fixReferencedOptionName(String[] refNameArray) {
        boolean flipResult = false;
        if (refNameArray[0].length() > 0 && (refNameArray[0].charAt(0) == '~' || refNameArray[0].charAt(0) == '!')) {
            try {
                refNameArray[0] = refNameArray[0].substring(1);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ArrayIndexOutOfBoundsException(String.format("The first element references an OptionAttribute with an invalid name: %s", refNameArray[0]));
            }
            flipResult = true;
        }
        return flipResult;
    }

    private OptionInfo getReferencedOptionInfo(String refName) {
        OptionInfo refOptionInfo = null;
        try {
            refOptionInfo = this._optionInfoMap.getNameOptionInfoMap().get(refName);
        }
        catch (NullPointerException e) {
            throw new NullPointerException(String.format("The first element references a non-existent OptionAttribute: %s", refName));
        }
        return refOptionInfo;
    }

    private boolean isReqByOptByCompatible(OptionInfo optionInfo, OptionInfo reqOptionInfo) {
        boolean compatible = true;
        if (optionInfo.hasOptionalBy() && optionInfo.getOptionalBy().length > 0) {
            OptionInfo[] optOptionInfoArray = new OptionInfo[1];
            boolean optionIsOptionalBy = this.getReferencedOptionInfo(optionInfo.getOptionalBy(), optOptionInfoArray);
            OptionInfo optOptionInfo = optOptionInfoArray[0];
            if (!(StringUtility.compare(reqOptionInfo.getLongName(), optOptionInfo.getLongName(), false) == 0 || optionIsOptionalBy || optionInfo.getIsRequired() || optionInfo.getIsDefined() || !optOptionInfo.getIsDefined() && !optOptionInfo.isBoolean() || optOptionInfo.getIsMissingArgument() || optOptionInfo.getHasInvalidArgument())) {
                compatible = false;
            }
        }
        return compatible;
    }

    private boolean enforceIncompatibleArgumentRules() {
        boolean allRequiredRulesMet = true;
        List<String> optionsWithIncompatibleArguments = this._options.optionsWithIncompatibleArguments();
        if (optionsWithIncompatibleArguments != null) {
            for (String optionWithIncompatibleArgument : optionsWithIncompatibleArguments) {
                OptionInfo optionInfo = this._optionInfoMap.get(optionWithIncompatibleArgument);
                if (optionInfo != null) {
                    if (!optionInfo.getIsDefined() || optionInfo.getIsMissingArgument() || optionInfo.getHasInvalidArgument()) continue;
                    optionInfo.setHasIncompatibleArgument(true);
                    this.addParsingError(optionInfo, ParsingIssueType.IncompatibleArgument);
                    allRequiredRulesMet = false;
                    continue;
                }
                throw new ParseException(new IllegalArgumentException("Invalid Member Name: " + optionWithIncompatibleArgument));
            }
        }
        return allRequiredRulesMet;
    }

    private boolean enforceRequiredRule() {
        boolean allRequiredRulesMet = true;
        for (OptionInfo optionInfo : this._optionInfoMap.getNameOptionInfoMap().values()) {
            if (!optionInfo.getIsRequired() || optionInfo.getIsDefined()) continue;
            this.addParsingError(optionInfo, ParsingIssueType.Required);
            allRequiredRulesMet = false;
        }
        return allRequiredRulesMet;
    }

    private boolean enforceMutuallyExclusiveRule() {
        boolean allMERulesMet = true;
        boolean[] allMERulesMetArray = new boolean[]{allMERulesMet};
        Hashtable<String, List<OptionInfo>> meDict = this.getMutuallyExclusiveDict();
        this.procesMutuallyExclusiveDict(meDict, allMERulesMetArray);
        return allMERulesMetArray[0];
    }

    private Hashtable<String, List<OptionInfo>> getMutuallyExclusiveDict() {
        Hashtable<String, List<OptionInfo>> meDict = new Hashtable<String, List<OptionInfo>>();
        for (OptionInfo optionInfo : this._optionInfoMap.getNameOptionInfoMap().values()) {
            String meSets = optionInfo.getMutuallyExclusiveSet();
            if (StringUtility.isNullOrEmpty(meSets)) continue;
            for (String s : StringUtility.split(meSets, ",", true)) {
                List<Object> list;
                if (StringUtility.isNullOrEmpty(s)) continue;
                String meSet = s.trim();
                if (!meDict.containsKey(meSet)) {
                    list = new ArrayList<OptionInfo>();
                    list.add(optionInfo);
                    meDict.put(meSet, list);
                    continue;
                }
                list = meDict.get(meSet);
                list.add(optionInfo);
            }
        }
        return meDict;
    }

    private void procesMutuallyExclusiveDict(Hashtable<String, List<OptionInfo>> meDict, boolean[] allMERulesMetArray) {
        for (List<OptionInfo> list : meDict.values()) {
            if (list.size() <= 1) continue;
            int parsedAndDefined = 0;
            for (OptionInfo optionInfo : list) {
                if (optionInfo.getIsDefined() && !optionInfo.getIsMissingArgument() && !optionInfo.getHasInvalidArgument()) {
                    ++parsedAndDefined;
                }
                if (parsedAndDefined <= 1) continue;
                break;
            }
            if (parsedAndDefined <= 0) continue;
            for (OptionInfo optionInfo : list) {
                if (!optionInfo.getIsDefined()) {
                    if (optionInfo.getIsRequired()) {
                        optionInfo.setIsRequired(false);
                    }
                    if (optionInfo.hasRequiredBy()) {
                        optionInfo.setRequiredBy(null);
                    }
                }
                if (parsedAndDefined <= 1 || !optionInfo.getIsDefined()) continue;
                this.addParsingError(optionInfo, ParsingIssueType.MutualExclusiveness);
                allMERulesMetArray[0] = false;
            }
        }
    }

    private boolean enforceMutuallyInclusiveRule() {
        boolean allMIRulesMet = true;
        boolean[] allMIRulesMetArray = new boolean[]{allMIRulesMet};
        Hashtable<String, List<OptionInfo>> miDict = this.getMutuallyInclusiveDict();
        this.processMutuallyInclusiveDict(miDict, allMIRulesMetArray);
        return allMIRulesMetArray[0];
    }

    private Hashtable<String, List<OptionInfo>> getMutuallyInclusiveDict() {
        Hashtable<String, List<OptionInfo>> miDict = new Hashtable<String, List<OptionInfo>>();
        for (OptionInfo optionInfo : this._optionInfoMap.getNameOptionInfoMap().values()) {
            String miSets = optionInfo.getMutuallyInclusiveSet();
            if (StringUtility.isNullOrEmpty(miSets)) continue;
            for (String s : StringUtility.split(miSets, ",", true)) {
                List<Object> list;
                if (StringUtility.isNullOrEmpty(s)) continue;
                String miSet = s.trim();
                if (!miDict.containsKey(miSet)) {
                    list = new ArrayList<OptionInfo>();
                    list.add(optionInfo);
                    miDict.put(miSet, list);
                    continue;
                }
                list = miDict.get(miSet);
                list.add(optionInfo);
            }
        }
        return miDict;
    }

    private void processMutuallyInclusiveDict(Hashtable<String, List<OptionInfo>> miDict, boolean[] allMIRulesMetArray) {
        for (List<OptionInfo> list : miDict.values()) {
            if (list.size() <= 1) continue;
            int parsedAndDefined = 0;
            for (OptionInfo optionInfo : list) {
                if (!optionInfo.getIsDefined()) continue;
                ++parsedAndDefined;
            }
            if (parsedAndDefined <= 0 || parsedAndDefined >= list.size()) continue;
            for (OptionInfo optionInfo : list) {
                if (optionInfo.getIsDefined()) continue;
                if (optionInfo.getIsRequired()) {
                    optionInfo.setIsRequired(false);
                }
                if (optionInfo.hasRequiredBy()) {
                    optionInfo.setRequiredBy(null);
                }
                this.addParsingError(optionInfo, ParsingIssueType.MutualInclusiveness);
                allMIRulesMetArray[0] = false;
            }
        }
    }

    private boolean enforceValidFilePathRule() {
        boolean allValidFilePaths = true;
        for (OptionInfo optionInfo : this._optionInfoMap.getNameOptionInfoMap().values()) {
            if (optionInfo.getIsInputPath()) {
                if (!optionInfo.getIsDefined() || optionInfo.getIsMissingArgument() || optionInfo.getHasInvalidArgument() || optionInfo.getHasIncompatibleArgument() || this.inputPathExists(optionInfo.getMemberValue())) continue;
                optionInfo.setHasInvalidPath(true);
                this.addParsingError(optionInfo, ParsingIssueType.InvalidPath);
                allValidFilePaths = false;
                continue;
            }
            if (!optionInfo.getIsOutputPath() || !optionInfo.getIsDefined() || optionInfo.getIsMissingArgument() || optionInfo.getHasInvalidArgument() || optionInfo.getHasIncompatibleArgument() || this.outputPathAppearsValid(optionInfo.getMemberValue())) continue;
            optionInfo.setHasInvalidPath(true);
            this.addParsingError(optionInfo, ParsingIssueType.InvalidPath);
            allValidFilePaths = false;
        }
        return allValidFilePaths;
    }

    private boolean inputPathExists(Object memberValue) {
        boolean inputPathExists;
        block5: {
            block6: {
                inputPathExists = true;
                if (memberValue == null) break block5;
                if (!(memberValue instanceof String)) break block6;
                String filepath = (String)memberValue;
                if (this.pathExists(filepath)) break block5;
                inputPathExists = false;
                break block5;
            }
            if (memberValue instanceof String[]) {
                String[] filepaths;
                for (String filepath : filepaths = (String[])memberValue) {
                    if (this.pathExists(filepath)) continue;
                    inputPathExists = false;
                    break;
                }
            } else if (memberValue instanceof ArrayList) {
                ArrayList filepaths = (ArrayList)memberValue;
                for (Object filepath : filepaths) {
                    if (!(filepath instanceof String) || this.pathExists((String)filepath)) continue;
                    inputPathExists = false;
                    break;
                }
            }
        }
        return inputPathExists;
    }

    private boolean pathExists(String filepath) {
        boolean pathExists = true;
        try {
            if (!new File(filepath).exists()) {
                pathExists = false;
            }
        }
        catch (Exception e) {
            pathExists = false;
        }
        return pathExists;
    }

    private boolean outputPathAppearsValid(Object memberValue) {
        boolean outputPathAppearsValid;
        block5: {
            block6: {
                outputPathAppearsValid = true;
                if (memberValue == null) break block5;
                if (!(memberValue instanceof String)) break block6;
                String filepath = (String)memberValue;
                if (this.pathAppearsValid(filepath)) break block5;
                outputPathAppearsValid = false;
                break block5;
            }
            if (memberValue instanceof String[]) {
                String[] filepaths;
                for (String filepath : filepaths = (String[])memberValue) {
                    if (this.pathAppearsValid(filepath)) continue;
                    outputPathAppearsValid = false;
                    break;
                }
            } else if (memberValue instanceof ArrayList) {
                ArrayList filepaths = (ArrayList)memberValue;
                for (Object filepath : filepaths) {
                    if (!(filepath instanceof String) || this.pathAppearsValid((String)filepath)) continue;
                    outputPathAppearsValid = false;
                    break;
                }
            }
        }
        return outputPathAppearsValid;
    }

    private boolean pathAppearsValid(String filepath) {
        boolean pathAppearsValid = true;
        try {
            File file = new File(filepath);
            if (file.exists()) {
                if (file.isFile() && !file.canWrite()) {
                    pathAppearsValid = false;
                }
            } else {
                File parentDirectory = file.getCanonicalFile().getParentFile();
                if (parentDirectory == null || !parentDirectory.exists()) {
                    pathAppearsValid = false;
                }
            }
        }
        catch (Exception e) {
            pathAppearsValid = false;
        }
        return pathAppearsValid;
    }

    private void addParsingError(OptionInfo optionWithError, ParsingIssueType parsingIssueType) {
        if (this._options != null) {
            ParsingIssue parsingError = new ParsingIssue(optionWithError.getShortName(), optionWithError.getLongName());
            parsingError.setParsingIssueType(parsingIssueType);
            if (!this._options.parsingErrorList.contains(parsingError)) {
                this._options.parsingErrorList.add(parsingError);
            }
        }
    }

    private void addParsingInfo(OptionInfo optionWithInfo, ParsingIssueType parsingIssueType) {
        if (this._options != null) {
            ParsingIssue parsingInfo = new ParsingIssue(optionWithInfo.getShortName(), optionWithInfo.getLongName());
            parsingInfo.setParsingIssueType(parsingIssueType);
            this._options.parsingInfoList.add(parsingInfo);
        }
    }

    public CLineParser(CommandLineOptionsBase options, CommandLineParserSettings settings, String[] args) {
        this._options = options;
        this._settings = settings;
        this._optionInfoMap = OptionInfoMap.createMap(options, settings);
        this._commandLineEnumerator = new CLineEnumerator(args);
    }
}

